/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules.helpers;

import appeng.api.config.FuzzyMode;
import appeng.util.InventoryAdaptor;
import appeng.util.Platform;
import appeng.util.inv.IInventoryDestination;
import appeng.util.inv.ItemSlot;
import appeng.util.iterators.StackToSlotIterator;
import java.util.Iterator;
import net.mcft.copy.betterstorage.api.crate.ICrateStorage;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class BSCrateStorageAdaptor
extends InventoryAdaptor {
    final ICrateStorage cs;
    final ForgeDirection side;

    public BSCrateStorageAdaptor(Object te, ForgeDirection d) {
        this.cs = (ICrateStorage)te;
        this.side = d;
    }

    @Override
    public ItemStack removeItems(int how_many, ItemStack Filter, IInventoryDestination destination) {
        ItemStack target = null;
        for (ItemStack is : this.cs.getContents()) {
            if (is == null || is.field_77994_a <= 0 || Filter != null && !Platform.isSameItem(Filter, is) || destination != null && !destination.canInsert(is)) continue;
            target = is;
            break;
        }
        if (target != null) {
            ItemStack f = Platform.cloneItemStack(target);
            f.field_77994_a = how_many;
            return this.cs.extractItems(f, how_many);
        }
        return null;
    }

    @Override
    public ItemStack simulateRemove(int how_many, ItemStack Filter, IInventoryDestination destination) {
        ItemStack target = null;
        for (ItemStack is : this.cs.getContents()) {
            if (is == null || is.field_77994_a <= 0 || Filter != null && !Platform.isSameItem(Filter, is) || destination != null && !destination.canInsert(is)) continue;
            target = is;
            break;
        }
        if (target != null) {
            int cnt = this.cs.getItemCount(target);
            if (cnt == 0) {
                return null;
            }
            if (cnt > how_many) {
                cnt = how_many;
            }
            ItemStack c = target.func_77946_l();
            c.field_77994_a = cnt;
            return c;
        }
        return null;
    }

    @Override
    public ItemStack removeSimilarItems(int amount, ItemStack filter, FuzzyMode fuzzyMode, IInventoryDestination destination) {
        ItemStack target = null;
        for (ItemStack is : this.cs.getContents()) {
            if (is == null || is.field_77994_a <= 0 || filter != null && !Platform.isSameItemFuzzy(filter, is, fuzzyMode) || destination != null && !destination.canInsert(is)) continue;
            target = is;
            break;
        }
        if (target != null) {
            ItemStack f = Platform.cloneItemStack(target);
            f.field_77994_a = amount;
            return this.cs.extractItems(f, amount);
        }
        return null;
    }

    @Override
    public ItemStack simulateSimilarRemove(int how_many, ItemStack filter, FuzzyMode fuzzyMode, IInventoryDestination destination) {
        ItemStack target = null;
        for (ItemStack is : this.cs.getContents()) {
            if (is == null || is.field_77994_a <= 0 || filter != null && !Platform.isSameItemFuzzy(filter, is, fuzzyMode) || destination != null && !destination.canInsert(is)) continue;
            target = is;
            break;
        }
        if (target != null) {
            int cnt = this.cs.getItemCount(target);
            if (cnt == 0) {
                return null;
            }
            if (cnt > how_many) {
                cnt = how_many;
            }
            ItemStack c = target.func_77946_l();
            c.field_77994_a = cnt;
            return c;
        }
        return null;
    }

    @Override
    public ItemStack addItems(ItemStack A) {
        return this.cs.insertItems(A);
    }

    @Override
    public ItemStack simulateAdd(ItemStack A) {
        int items = this.cs.getSpaceForItem(A);
        ItemStack B = Platform.cloneItemStack(A);
        if (A.field_77994_a <= items) {
            return null;
        }
        B.field_77994_a -= items;
        return B;
    }

    @Override
    public boolean containsItems() {
        return this.cs.getUniqueItems() > 0;
    }

    @Override
    public Iterator<ItemSlot> iterator() {
        return new StackToSlotIterator(this.cs.getContents().iterator());
    }
}

