/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration.modules;

import appeng.integration.BaseModule;
import appeng.integration.abstraction.IMJ6;
import appeng.transformer.annotations.integration;
import buildcraft.api.mj.IBatteryObject;
import buildcraft.api.mj.IBatteryProvider;
import buildcraft.api.mj.ISidedBatteryProvider;
import buildcraft.api.power.IPowerReceptor;
import buildcraft.api.power.PowerHandler;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class MJ6
extends BaseModule
implements IMJ6 {
    public static MJ6 instance;

    public MJ6() {
        this.testClassExistence(IBatteryObject.class);
        this.testClassExistence(IBatteryProvider.class);
        this.testClassExistence(ISidedBatteryProvider.class);
    }

    @Override
    public void init() throws Throwable {
    }

    @Override
    public void postInit() {
    }

    @Override
    @integration.Method(iname="MJ5")
    public IBatteryObject provider(TileEntity te, final ForgeDirection side) {
        if (te instanceof IPowerReceptor) {
            IPowerReceptor receptor = (IPowerReceptor)te;
            final PowerHandler.PowerReceiver ph = receptor.getPowerReceiver(side);
            if (ph == null) {
                return null;
            }
            return new IBatteryObject(){

                public void setEnergyStored(double mj) {
                }

                public IBatteryObject reconfigure(double maxCapacity, double maxReceivedPerCycle, double minimumConsumption) {
                    return this;
                }

                public double minimumConsumption() {
                    return ph.getMinEnergyReceived();
                }

                public double maxReceivedPerCycle() {
                    return ph.getMaxEnergyReceived();
                }

                public double maxCapacity() {
                    return ph.getMaxEnergyStored();
                }

                public String kind() {
                    return "buildcraft.kinesis";
                }

                public double getEnergyStored() {
                    return ph.getEnergyStored();
                }

                public double getEnergyRequested() {
                    return ph.getMaxEnergyStored() - ph.getEnergyStored();
                }

                public double addEnergy(double mj, boolean ignoreCycleLimit) {
                    return ph.receiveEnergy(PowerHandler.Type.PIPE, mj, side);
                }

                public double addEnergy(double mj) {
                    return ph.receiveEnergy(PowerHandler.Type.PIPE, mj, side);
                }
            };
        }
        return null;
    }
}

