/*
 * Decompiled with CFR 0.152.
 */
package appeng.integration;

import appeng.api.exceptions.ModNotInstalled;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.integration.IIntegrationModule;
import appeng.integration.IntegrationStage;
import appeng.integration.IntegrationType;
import cpw.mods.fml.common.Loader;
import java.lang.reflect.Field;

public class IntegrationNode {
    IntegrationStage state = IntegrationStage.PRE_INIT;
    IntegrationStage failedStage = IntegrationStage.PRE_INIT;
    Throwable exception = null;
    final String displayName;
    final String modID;
    final IntegrationType shortName;
    String name = null;
    Class classValue = null;
    Object instance;
    IIntegrationModule mod = null;

    public IntegrationNode(String displayName, String modID, IntegrationType shortName, String name) {
        this.displayName = displayName;
        this.shortName = shortName;
        this.modID = modID;
        this.name = name;
    }

    public String toString() {
        return this.shortName.name() + ':' + this.state.name();
    }

    void Call(IntegrationStage stage) {
        if (this.state != IntegrationStage.FAILED) {
            if (this.state.ordinal() > stage.ordinal()) {
                return;
            }
            try {
                switch (stage) {
                    case PRE_INIT: {
                        boolean enabled = this.modID == null || Loader.isModLoaded((String)this.modID);
                        AEConfig.instance.addCustomCategoryComment("ModIntegration", "Valid Values are 'AUTO', 'ON', or 'OFF' - defaults to 'AUTO' ; Suggested that you leave this alone unless your experiencing an issue, or wish to disable the integration for a reason.");
                        String Mode = AEConfig.instance.get("ModIntegration", this.displayName.replace(" ", ""), "AUTO").getString();
                        if (Mode.toUpperCase().equals("ON")) {
                            enabled = true;
                        }
                        if (Mode.toUpperCase().equals("OFF")) {
                            enabled = false;
                        }
                        if (!enabled) {
                            throw new ModNotInstalled(this.modID);
                        }
                        this.classValue = this.getClass().getClassLoader().loadClass(this.name);
                        this.mod = (IIntegrationModule)this.classValue.getConstructor(new Class[0]).newInstance(new Object[0]);
                        Field f = this.classValue.getField("instance");
                        this.instance = this.mod;
                        f.set(this.classValue, this.instance);
                        this.state = IntegrationStage.INIT;
                        break;
                    }
                    case INIT: {
                        this.mod.init();
                        this.state = IntegrationStage.POST_INIT;
                        break;
                    }
                    case POST_INIT: {
                        this.mod.postInit();
                        this.state = IntegrationStage.READY;
                        break;
                    }
                }
            }
            catch (Throwable t) {
                this.failedStage = stage;
                this.exception = t;
                this.state = IntegrationStage.FAILED;
            }
        }
        if (stage == IntegrationStage.POST_INIT) {
            if (this.state == IntegrationStage.FAILED) {
                AELog.info(this.displayName + " - Integration Disabled", new Object[0]);
                if (!(this.exception instanceof ModNotInstalled)) {
                    AELog.integration(this.exception);
                }
            } else {
                AELog.info(this.displayName + " - Integration Enable", new Object[0]);
            }
        }
    }

    public boolean isActive() {
        if (this.state == IntegrationStage.PRE_INIT) {
            this.Call(IntegrationStage.PRE_INIT);
        }
        return this.state != IntegrationStage.FAILED;
    }
}

