/*
 * Decompiled with CFR 0.152.
 */
package appeng.hooks;

import appeng.api.AEApi;
import appeng.api.networking.IGridNode;
import appeng.api.parts.CableRenderMode;
import appeng.api.util.AEColor;
import appeng.core.AEConfig;
import appeng.core.AELog;
import appeng.core.CommonHelper;
import appeng.core.sync.packets.PacketPaintedEntity;
import appeng.crafting.CraftingJob;
import appeng.entity.EntityFloatingItem;
import appeng.me.Grid;
import appeng.me.NetworkList;
import appeng.tile.AEBaseTile;
import appeng.util.Platform;
import com.google.common.base.Stopwatch;
import com.google.common.collect.LinkedListMultimap;
import com.google.common.collect.Multimap;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Queue;
import java.util.WeakHashMap;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import net.minecraft.world.World;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.WorldEvent;

public class TickHandler {
    public static final TickHandler INSTANCE = new TickHandler();
    private final WeakHashMap<World, Queue<Callable>> callQueue = new WeakHashMap();
    final Queue<Callable> serverQueue = new LinkedList<Callable>();
    private final HandlerRep server = new HandlerRep();
    private final HandlerRep client = new HandlerRep();
    private final HashMap<Integer, PlayerColor> cliPlayerColors = new HashMap();
    private final HashMap<Integer, PlayerColor> srvPlayerColors = new HashMap();
    CableRenderMode crm = CableRenderMode.Standard;
    final Multimap<World, CraftingJob> craftingJobs = LinkedListMultimap.create();

    public HashMap<Integer, PlayerColor> getPlayerColors() {
        if (Platform.isServer()) {
            return this.srvPlayerColors;
        }
        return this.cliPlayerColors;
    }

    private void tickColors(HashMap<Integer, PlayerColor> playerSet) {
        Iterator<PlayerColor> i = playerSet.values().iterator();
        while (i.hasNext()) {
            PlayerColor pc = i.next();
            if (pc.ticksLeft-- > 0) continue;
            i.remove();
        }
    }

    HandlerRep getRepo() {
        if (Platform.isServer()) {
            return this.server;
        }
        return this.client;
    }

    public void addCallable(World w, Callable c) {
        if (w == null) {
            this.serverQueue.add(c);
        } else {
            Queue<Callable> queue = this.callQueue.get(w);
            if (queue == null) {
                queue = new LinkedList<Callable>();
                this.callQueue.put(w, queue);
            }
            queue.add(c);
        }
    }

    public void addInit(AEBaseTile tile) {
        if (Platform.isServer()) {
            this.getRepo().tiles.add(tile);
        }
    }

    public void addNetwork(Grid grid) {
        if (Platform.isServer()) {
            this.getRepo().networks.add(grid);
        }
    }

    public void removeNetwork(Grid grid) {
        if (Platform.isServer()) {
            this.getRepo().networks.remove(grid);
        }
    }

    public Iterable<Grid> getGridList() {
        return this.getRepo().networks;
    }

    public void shutdown() {
        this.getRepo().clear();
    }

    @SubscribeEvent
    public void unloadWorld(WorldEvent.Unload ev) {
        if (Platform.isServer()) {
            LinkedList<IGridNode> toDestroy = new LinkedList<IGridNode>();
            for (Grid g : this.getRepo().networks) {
                for (IGridNode n : g.getNodes()) {
                    if (n.getWorld() != ev.world) continue;
                    toDestroy.add(n);
                }
            }
            for (IGridNode n : toDestroy) {
                n.destroy();
            }
        }
    }

    @SubscribeEvent
    public void onChunkLoad(ChunkEvent.Load load) {
        for (Object te : load.getChunk().field_150816_i.values()) {
            if (!(te instanceof AEBaseTile)) continue;
            ((AEBaseTile)te).onChunkLoad();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void onTick(TickEvent ev) {
        if (ev.type == TickEvent.Type.CLIENT && ev.phase == TickEvent.Phase.START) {
            this.tickColors(this.cliPlayerColors);
            EntityFloatingItem.ageStatic = (EntityFloatingItem.ageStatic + 1) % 60000;
            CableRenderMode currentMode = AEApi.instance().partHelper().getCableRenderMode();
            if (currentMode != this.crm) {
                this.crm = currentMode;
                CommonHelper.proxy.triggerUpdates();
            }
        }
        if (ev.type == TickEvent.Type.WORLD && ev.phase == TickEvent.Phase.END) {
            TickEvent.WorldTickEvent wte = (TickEvent.WorldTickEvent)ev;
            Multimap<World, CraftingJob> multimap = this.craftingJobs;
            synchronized (multimap) {
                Collection jobSet = this.craftingJobs.get((Object)wte.world);
                if (!jobSet.isEmpty()) {
                    int simTime = Math.max(1, AEConfig.instance.craftingCalculationTimePerTick / jobSet.size());
                    Iterator i = jobSet.iterator();
                    while (i.hasNext()) {
                        CraftingJob cj = (CraftingJob)i.next();
                        if (cj.simulateFor(simTime)) continue;
                        i.remove();
                    }
                }
            }
        } else if (ev.type == TickEvent.Type.SERVER && ev.phase == TickEvent.Phase.END) {
            this.tickColors(this.srvPlayerColors);
            HandlerRep repo = this.getRepo();
            while (!repo.tiles.isEmpty()) {
                AEBaseTile bt = repo.tiles.poll();
                if (bt.func_145837_r()) continue;
                bt.onReady();
            }
            for (Grid g : this.getRepo().networks) {
                g.update();
            }
            this.processQueue(this.serverQueue);
        }
        if (ev.type == TickEvent.Type.WORLD && ev.phase == TickEvent.Phase.START) {
            this.processQueue(this.callQueue.get(((TickEvent.WorldTickEvent)ev).world));
        }
    }

    private void processQueue(Queue<Callable> queue) {
        if (queue == null) {
            return;
        }
        Stopwatch sw = Stopwatch.createStarted();
        Callable c = null;
        while ((c = queue.poll()) != null) {
            try {
                c.call();
                if (sw.elapsed(TimeUnit.MILLISECONDS) <= 50L) continue;
                break;
            }
            catch (Exception e) {
                AELog.error(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void registerCraftingSimulation(World world, CraftingJob craftingJob) {
        Multimap<World, CraftingJob> multimap = this.craftingJobs;
        synchronized (multimap) {
            this.craftingJobs.put((Object)world, (Object)craftingJob);
        }
    }

    public static class PlayerColor {
        public final AEColor myColor;
        protected final int myEntity;
        protected int ticksLeft;

        public PacketPaintedEntity getPacket() {
            return new PacketPaintedEntity(this.myEntity, this.myColor, this.ticksLeft);
        }

        public PlayerColor(int id, AEColor col, int ticks) {
            this.myEntity = id;
            this.myColor = col;
            this.ticksLeft = ticks;
        }
    }

    static class HandlerRep {
        public Queue<AEBaseTile> tiles = new LinkedList<AEBaseTile>();
        public Collection<Grid> networks = new NetworkList();

        HandlerRep() {
        }

        public void clear() {
            this.tiles = new LinkedList<AEBaseTile>();
            this.networks = new NetworkList();
        }
    }
}

