/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync.packets;

import appeng.core.sync.AppEngPacket;
import appeng.core.sync.network.INetworkInfo;
import appeng.core.sync.packets.PacketCompassRequest;
import appeng.hooks.CompassManager;
import appeng.hooks.CompassResult;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import net.minecraft.entity.player.EntityPlayer;

public class PacketCompassResponse
extends AppEngPacket {
    public final long attunement;
    public final int cx;
    public final int cz;
    public final int cdy;
    public CompassResult cr;

    public PacketCompassResponse(ByteBuf stream) {
        this.attunement = stream.readLong();
        this.cx = stream.readInt();
        this.cz = stream.readInt();
        this.cdy = stream.readInt();
        this.cr = new CompassResult(stream.readBoolean(), stream.readBoolean(), stream.readDouble());
    }

    @Override
    public void clientPacketData(INetworkInfo network, AppEngPacket packet, EntityPlayer player) {
        CompassManager.INSTANCE.postResult(this.attunement, this.cx << 4, this.cdy << 5, this.cz << 4, this.cr);
    }

    public PacketCompassResponse(PacketCompassRequest req, boolean hasResult, boolean spin, double radians) {
        ByteBuf data = Unpooled.buffer();
        data.writeInt(this.getPacketID());
        this.attunement = req.attunement;
        data.writeLong(this.attunement);
        this.cx = req.cx;
        data.writeInt(this.cx);
        this.cz = req.cz;
        data.writeInt(this.cz);
        this.cdy = req.cdy;
        data.writeInt(this.cdy);
        data.writeBoolean(hasResult);
        data.writeBoolean(spin);
        data.writeDouble(radians);
        this.configureWrite(data);
    }
}

