/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.sync;

import appeng.core.sync.AppEngPacket;
import appeng.core.sync.packets.PacketAssemblerAnimation;
import appeng.core.sync.packets.PacketClick;
import appeng.core.sync.packets.PacketCompassRequest;
import appeng.core.sync.packets.PacketCompassResponse;
import appeng.core.sync.packets.PacketCompressedNBT;
import appeng.core.sync.packets.PacketConfigButton;
import appeng.core.sync.packets.PacketCraftRequest;
import appeng.core.sync.packets.PacketInventoryAction;
import appeng.core.sync.packets.PacketLightning;
import appeng.core.sync.packets.PacketMEInventoryUpdate;
import appeng.core.sync.packets.PacketMatterCannon;
import appeng.core.sync.packets.PacketMockExplosion;
import appeng.core.sync.packets.PacketMultiPart;
import appeng.core.sync.packets.PacketNEIRecipe;
import appeng.core.sync.packets.PacketNewStorageDimension;
import appeng.core.sync.packets.PacketPaintedEntity;
import appeng.core.sync.packets.PacketPartPlacement;
import appeng.core.sync.packets.PacketPartialItem;
import appeng.core.sync.packets.PacketPatternSlot;
import appeng.core.sync.packets.PacketProgressBar;
import appeng.core.sync.packets.PacketSwapSlots;
import appeng.core.sync.packets.PacketSwitchGuis;
import appeng.core.sync.packets.PacketTransitionEffect;
import appeng.core.sync.packets.PacketValueConfig;
import io.netty.buffer.ByteBuf;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.Map;

public class AppEngPacketHandlerBase {
    public static final Map<Class, PacketTypes> REVERSE_LOOKUP = new HashMap<Class, PacketTypes>();

    public static enum PacketTypes {
        PACKET_COMPASS_REQUEST(PacketCompassRequest.class),
        PACKET_COMPASS_RESPONSE(PacketCompassResponse.class),
        PACKET_INVENTORY_ACTION(PacketInventoryAction.class),
        PACKET_ME_INVENTORY_UPDATE(PacketMEInventoryUpdate.class),
        PACKET_CONFIG_BUTTON(PacketConfigButton.class),
        PACKET_MULTIPART(PacketMultiPart.class),
        PACKET_PART_PLACEMENT(PacketPartPlacement.class),
        PACKET_LIGHTNING(PacketLightning.class),
        PACKET_MATTER_CANNON(PacketMatterCannon.class),
        PACKET_MOCK_EXPLOSION(PacketMockExplosion.class),
        PACKET_VALUE_CONFIG(PacketValueConfig.class),
        PACKET_TRANSITION_EFFECT(PacketTransitionEffect.class),
        PACKET_PROGRESS_VALUE(PacketProgressBar.class),
        PACKET_CLICK(PacketClick.class),
        PACKET_NEW_STORAGE_DIMENSION(PacketNewStorageDimension.class),
        PACKET_SWITCH_GUIS(PacketSwitchGuis.class),
        PACKET_SWAP_SLOTS(PacketSwapSlots.class),
        PACKET_PATTERN_SLOT(PacketPatternSlot.class),
        PACKET_RECIPE_NEI(PacketNEIRecipe.class),
        PACKET_PARTIAL_ITEM(PacketPartialItem.class),
        PACKET_CRAFTING_REQUEST(PacketCraftRequest.class),
        PACKET_ASSEMBLER_ANIMATION(PacketAssemblerAnimation.class),
        PACKET_COMPRESSED_NBT(PacketCompressedNBT.class),
        PACKET_PAINTED_ENTITY(PacketPaintedEntity.class);

        public final Class pc;
        public final Constructor con;

        private PacketTypes(Class c) {
            this.pc = c;
            Constructor x = null;
            try {
                x = this.pc.getConstructor(ByteBuf.class);
            }
            catch (NoSuchMethodException ignored) {
            }
            catch (SecurityException ignored) {
                // empty catch block
            }
            this.con = x;
            REVERSE_LOOKUP.put(this.pc, this);
            if (this.con == null) {
                throw new RuntimeException("Invalid Packet Class, must be constructable on DataInputStream");
            }
        }

        public AppEngPacket parsePacket(ByteBuf in) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException {
            return (AppEngPacket)this.con.newInstance(in);
        }

        public static PacketTypes getPacket(int id) {
            return PacketTypes.values()[id];
        }

        public static PacketTypes getID(Class<? extends AppEngPacket> c) {
            return REVERSE_LOOKUP.get(c);
        }
    }
}

