/*
 * Decompiled with CFR 0.152.
 */
package appeng.core.features.registries;

import appeng.api.features.IWorldGen;
import java.util.HashSet;
import net.minecraft.world.World;
import net.minecraft.world.WorldProvider;

public class WorldGenRegistry
implements IWorldGen {
    final TypeSet[] types = new TypeSet[IWorldGen.WorldGenType.values().length];
    public static final WorldGenRegistry INSTANCE = new WorldGenRegistry();

    private WorldGenRegistry() {
        for (IWorldGen.WorldGenType type : IWorldGen.WorldGenType.values()) {
            this.types[type.ordinal()] = new TypeSet();
        }
    }

    @Override
    public boolean isWorldGenEnabled(IWorldGen.WorldGenType type, World w) {
        if (type == null) {
            throw new IllegalArgumentException("Bad Type Passed");
        }
        if (w == null) {
            throw new IllegalArgumentException("Bad Provider Passed");
        }
        boolean isBadProvider = this.types[type.ordinal()].badProviders.contains(w.field_73011_w.getClass());
        boolean isBadDimension = this.types[type.ordinal()].badDimensions.contains(w.field_73011_w.field_76574_g);
        boolean isGoodDimension = this.types[type.ordinal()].enabledDimensions.contains(w.field_73011_w.field_76574_g);
        if (isBadProvider || isBadDimension) {
            return false;
        }
        return isGoodDimension || type != IWorldGen.WorldGenType.Meteorites;
    }

    @Override
    public void disableWorldGenForProviderID(IWorldGen.WorldGenType type, Class<? extends WorldProvider> provider) {
        if (type == null) {
            throw new IllegalArgumentException("Bad Type Passed");
        }
        if (provider == null) {
            throw new IllegalArgumentException("Bad Provider Passed");
        }
        this.types[type.ordinal()].badProviders.add(provider);
    }

    @Override
    public void disableWorldGenForDimension(IWorldGen.WorldGenType type, int dimensionID) {
        if (type == null) {
            throw new IllegalArgumentException("Bad Type Passed");
        }
        this.types[type.ordinal()].badDimensions.add(dimensionID);
    }

    @Override
    public void enableWorldGenForDimension(IWorldGen.WorldGenType type, int dimensionID) {
        if (type == null) {
            throw new IllegalArgumentException("Bad Type Passed");
        }
        this.types[type.ordinal()].enabledDimensions.add(dimensionID);
    }

    private static class TypeSet {
        final HashSet<Class<? extends WorldProvider>> badProviders = new HashSet();
        final HashSet<Integer> badDimensions = new HashSet();
        final HashSet<Integer> enabledDimensions = new HashSet();

        private TypeSet() {
        }
    }
}

