/*
 * Decompiled with CFR 0.152.
 */
package appeng.core;

import appeng.core.AEConfig;
import appeng.core.features.AEFeature;
import appeng.tile.AEBaseTile;
import appeng.util.Platform;
import cpw.mods.fml.relauncher.FMLRelaunchLog;
import org.apache.logging.log4j.Level;

public class AELog {
    public static final FMLRelaunchLog instance = FMLRelaunchLog.log;

    private AELog() {
    }

    private static void log(Level level, String format, Object ... data) {
        if (AEConfig.instance == null || AEConfig.instance.isFeatureEnabled(AEFeature.Logging)) {
            FMLRelaunchLog.log((String)("AE2:" + (Platform.isServer() ? "S" : "C")), (Level)level, (String)format, (Object[])data);
        }
    }

    public static void severe(String format, Object ... data) {
        AELog.log(Level.ERROR, format, data);
    }

    public static void warning(String format, Object ... data) {
        AELog.log(Level.WARN, format, data);
    }

    public static void info(String format, Object ... data) {
        AELog.log(Level.INFO, format, data);
    }

    public static void grinder(String o) {
        if (AEConfig.instance.isFeatureEnabled(AEFeature.GrinderLogging)) {
            AELog.log(Level.DEBUG, "grinder: " + o, new Object[0]);
        }
    }

    public static void error(Throwable e) {
        if (AEConfig.instance.isFeatureEnabled(AEFeature.Logging)) {
            AELog.severe("Error: " + e.getClass().getName() + " : " + e.getMessage(), new Object[0]);
            e.printStackTrace();
        }
    }

    public static void integration(Throwable exception) {
        if (AEConfig.instance.isFeatureEnabled(AEFeature.IntegrationLogging)) {
            AELog.error(exception);
        }
    }

    public static void blockUpdate(int xCoord, int yCoord, int zCoord, AEBaseTile aeBaseTile) {
        if (AEConfig.instance.isFeatureEnabled(AEFeature.UpdateLogging)) {
            AELog.info(aeBaseTile.getClass().getName() + " @ " + xCoord + ", " + yCoord + ", " + zCoord, new Object[0]);
        }
    }

    public static void crafting(String format, Object ... data) {
        if (AEConfig.instance.isFeatureEnabled(AEFeature.CraftingLog)) {
            AELog.log(Level.INFO, format, data);
        }
    }
}

