/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.blocks;

import appeng.api.AEApi;
import appeng.api.util.AEColor;
import appeng.block.AEBaseBlock;
import appeng.block.crafting.BlockCraftingMonitor;
import appeng.block.crafting.BlockCraftingUnit;
import appeng.client.render.BaseBlockRender;
import appeng.client.render.BusRenderHelper;
import appeng.client.render.BusRenderer;
import appeng.client.texture.ExtraBlockTextures;
import appeng.tile.crafting.TileCraftingMonitorTile;
import appeng.tile.crafting.TileCraftingTile;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class RenderBlockCraftingCPU
extends BaseBlockRender {
    protected RenderBlockCraftingCPU(boolean useTESR, int range) {
        super(useTESR, range);
    }

    public RenderBlockCraftingCPU() {
        super(false, 20.0);
    }

    @Override
    public boolean renderInWorld(AEBaseBlock blk, IBlockAccess w, int x, int y, int z, RenderBlocks renderer) {
        IIcon theIcon = null;
        boolean formed = false;
        boolean emitsLight = false;
        TileCraftingTile ct = (TileCraftingTile)blk.getTileEntity(w, x, y, z);
        if (ct != null && ct.isFormed()) {
            formed = true;
            emitsLight = ct.isPowered();
        }
        int meta = w.func_72805_g(x, y, z) & 3;
        boolean isMonitor = blk.getClass() == BlockCraftingMonitor.class;
        IIcon nonForward = theIcon = blk.func_149691_a(ForgeDirection.SOUTH.ordinal(), meta | (formed ? 8 : 0));
        if (isMonitor) {
            nonForward = AEApi.instance().blocks().blockCraftingUnit.block().func_149691_a(0, meta | (formed ? 8 : 0));
        }
        if (formed && renderer.field_147840_d == null) {
            renderer = BusRenderer.INSTANCE.renderer;
            BusRenderHelper i = BusRenderHelper.INSTANCE;
            BusRenderer.INSTANCE.renderer.isFacade = true;
            renderer.field_147845_a = w;
            i.setPass(0);
            i.setOrientation(ForgeDirection.EAST, ForgeDirection.UP, ForgeDirection.SOUTH);
            try {
                ct.lightCache = i.useSimplifiedRendering(x, y, z, null, ct.lightCache);
            }
            catch (Throwable ignored) {
                // empty catch block
            }
            float highX = this.isConnected(w, x, y, z, ForgeDirection.EAST) ? 16.0f : 13.01f;
            float lowX = this.isConnected(w, x, y, z, ForgeDirection.WEST) ? 0.0f : 2.99f;
            float highY = this.isConnected(w, x, y, z, ForgeDirection.UP) ? 16.0f : 13.01f;
            float lowY = this.isConnected(w, x, y, z, ForgeDirection.DOWN) ? 0.0f : 2.99f;
            float highZ = this.isConnected(w, x, y, z, ForgeDirection.SOUTH) ? 16.0f : 13.01f;
            float lowZ = this.isConnected(w, x, y, z, ForgeDirection.NORTH) ? 0.0f : 2.99f;
            this.renderCorner(i, renderer, w, x, y, z, ForgeDirection.UP, ForgeDirection.EAST, ForgeDirection.NORTH);
            this.renderCorner(i, renderer, w, x, y, z, ForgeDirection.UP, ForgeDirection.EAST, ForgeDirection.SOUTH);
            this.renderCorner(i, renderer, w, x, y, z, ForgeDirection.UP, ForgeDirection.WEST, ForgeDirection.NORTH);
            this.renderCorner(i, renderer, w, x, y, z, ForgeDirection.UP, ForgeDirection.WEST, ForgeDirection.SOUTH);
            this.renderCorner(i, renderer, w, x, y, z, ForgeDirection.DOWN, ForgeDirection.EAST, ForgeDirection.NORTH);
            this.renderCorner(i, renderer, w, x, y, z, ForgeDirection.DOWN, ForgeDirection.EAST, ForgeDirection.SOUTH);
            this.renderCorner(i, renderer, w, x, y, z, ForgeDirection.DOWN, ForgeDirection.WEST, ForgeDirection.NORTH);
            this.renderCorner(i, renderer, w, x, y, z, ForgeDirection.DOWN, ForgeDirection.WEST, ForgeDirection.SOUTH);
            for (ForgeDirection side : ForgeDirection.VALID_DIRECTIONS) {
                i.setBounds(this.fso(side, lowX, ForgeDirection.WEST), this.fso(side, lowY, ForgeDirection.DOWN), this.fso(side, lowZ, ForgeDirection.NORTH), this.fso(side, highX, ForgeDirection.EAST), this.fso(side, highY, ForgeDirection.UP), this.fso(side, highZ, ForgeDirection.SOUTH));
                i.prepareBounds(renderer);
                boolean LocalEmit = emitsLight;
                if (blk instanceof BlockCraftingMonitor && ct.getForward() != side) {
                    LocalEmit = false;
                }
                this.handleSide(blk, meta, x, y, z, i, renderer, ct.getForward() == side ? theIcon : nonForward, LocalEmit, isMonitor, side, w);
            }
            BusRenderer.INSTANCE.renderer.isFacade = false;
            i.setFacesToRender(EnumSet.allOf(ForgeDirection.class));
            i.normalRendering();
            return true;
        }
        double a = 0.0;
        double o = 1.0;
        renderer.func_147782_a(a, a, a, o, o, o);
        return renderer.func_147784_q((Block)blk, x, y, z);
    }

    private void renderCorner(BusRenderHelper i, RenderBlocks renderer, IBlockAccess w, int x, int y, int z, ForgeDirection up, ForgeDirection east, ForgeDirection south) {
        if (this.isConnected(w, x, y, z, up)) {
            return;
        }
        if (this.isConnected(w, x, y, z, east)) {
            return;
        }
        if (this.isConnected(w, x, y, z, south)) {
            return;
        }
        i.setBounds(this.gso(east, 3.0f, ForgeDirection.WEST), this.gso(up, 3.0f, ForgeDirection.DOWN), this.gso(south, 3.0f, ForgeDirection.NORTH), this.gso(east, 13.0f, ForgeDirection.EAST), this.gso(up, 13.0f, ForgeDirection.UP), this.gso(south, 13.0f, ForgeDirection.SOUTH));
        i.prepareBounds(renderer);
        i.setTexture(ExtraBlockTextures.BlockCraftingUnitRing.getIcon());
        i.renderBlockCurrentBounds(x, y, z, renderer);
    }

    private float gso(ForgeDirection side, float def, ForgeDirection target) {
        if (side != target) {
            if (side.offsetX > 0 || side.offsetY > 0 || side.offsetZ > 0) {
                return 16.0f;
            }
            return 0.0f;
        }
        return def;
    }

    private float fso(ForgeDirection side, float def, ForgeDirection target) {
        if (side == target) {
            if (side.offsetX > 0 || side.offsetY > 0 || side.offsetZ > 0) {
                return 16.0f;
            }
            return 0.0f;
        }
        return def;
    }

    private void handleSide(AEBaseBlock blk, int meta, int x, int y, int z, BusRenderHelper i, RenderBlocks renderer, IIcon color, boolean emitsLight, boolean isMonitor, ForgeDirection side, IBlockAccess w) {
        if (this.isConnected(w, x, y, z, side)) {
            return;
        }
        i.setFacesToRender(EnumSet.of(side));
        if (meta == 0 && blk.getClass() == BlockCraftingUnit.class) {
            i.setTexture(ExtraBlockTextures.BlockCraftingUnitFit.getIcon());
            i.renderBlockCurrentBounds(x, y, z, renderer);
        } else {
            if (color == ExtraBlockTextures.BlockCraftingMonitorFit_Light.getIcon()) {
                i.setTexture(ExtraBlockTextures.BlockCraftingMonitorOuter.getIcon());
            } else {
                i.setTexture(ExtraBlockTextures.BlockCraftingFitSolid.getIcon());
            }
            i.renderBlockCurrentBounds(x, y, z, renderer);
            if (color != null) {
                i.setTexture(color);
                if (!emitsLight) {
                    if (color == ExtraBlockTextures.BlockCraftingMonitorFit_Light.getIcon()) {
                        int b = w.func_72802_i(x + side.offsetX, y + side.offsetY, z + side.offsetZ, 0);
                        TileCraftingMonitorTile sr = (TileCraftingMonitorTile)blk.getTileEntity(w, x, y, z);
                        AEColor col = sr.getColor();
                        Tessellator.field_78398_a.func_78380_c(b);
                        Tessellator.field_78398_a.func_78378_d(col.whiteVariant);
                        i.renderFace(x, y, z, color, side, renderer);
                        Tessellator.field_78398_a.func_78378_d(col.mediumVariant);
                        i.renderFace(x, y, z, ExtraBlockTextures.BlockCraftingMonitorFit_Medium.getIcon(), side, renderer);
                        Tessellator.field_78398_a.func_78378_d(col.blackVariant);
                        i.renderFace(x, y, z, ExtraBlockTextures.BlockCraftingMonitorFit_Dark.getIcon(), side, renderer);
                    } else {
                        i.renderBlockCurrentBounds(x, y, z, renderer);
                    }
                } else if (isMonitor) {
                    TileCraftingMonitorTile sr = (TileCraftingMonitorTile)blk.getTileEntity(w, x, y, z);
                    AEColor col = sr.getColor();
                    Tessellator.field_78398_a.func_78378_d(col.whiteVariant);
                    Tessellator.field_78398_a.func_78380_c(0xD000D0);
                    i.renderFace(x, y, z, color, side, renderer);
                    Tessellator.field_78398_a.func_78378_d(col.mediumVariant);
                    Tessellator.field_78398_a.func_78380_c(0xD000D0);
                    i.renderFace(x, y, z, ExtraBlockTextures.BlockCraftingMonitorFit_Medium.getIcon(), side, renderer);
                    Tessellator.field_78398_a.func_78378_d(col.blackVariant);
                    Tessellator.field_78398_a.func_78380_c(0xD000D0);
                    i.renderFace(x, y, z, ExtraBlockTextures.BlockCraftingMonitorFit_Dark.getIcon(), side, renderer);
                } else {
                    Tessellator.field_78398_a.func_78386_a(1.0f, 1.0f, 1.0f);
                    Tessellator.field_78398_a.func_78380_c(0xD000D0);
                    i.renderFace(x, y, z, color, side, renderer);
                }
            }
        }
        for (ForgeDirection a : ForgeDirection.VALID_DIRECTIONS) {
            if (a == side || a == side.getOpposite()) continue;
            if (!(side.offsetX == 0 && side.offsetZ == 0 || a != ForgeDirection.NORTH && a != ForgeDirection.EAST && a != ForgeDirection.WEST && a != ForgeDirection.SOUTH)) {
                i.setTexture(ExtraBlockTextures.BlockCraftingUnitRingLongRotated.getIcon());
            } else if (side.offsetY != 0 && (a == ForgeDirection.EAST || a == ForgeDirection.WEST)) {
                i.setTexture(ExtraBlockTextures.BlockCraftingUnitRingLongRotated.getIcon());
            } else {
                i.setTexture(ExtraBlockTextures.BlockCraftingUnitRingLong.getIcon());
            }
            double width = 0.1875;
            if (i.getBound(a) < 0.001 || i.getBound(a) > 15.999) continue;
            switch (a) {
                case DOWN: {
                    renderer.field_147855_j = 0.0;
                    renderer.field_147857_k = width;
                    break;
                }
                case EAST: {
                    renderer.field_147861_i = 1.0;
                    renderer.field_147859_h = 1.0 - width;
                    renderer.field_147867_u = 1;
                    renderer.field_147865_v = 1;
                    renderer.field_147873_r = 1;
                    renderer.field_147875_q = 1;
                    break;
                }
                case NORTH: {
                    renderer.field_147851_l = 0.0;
                    renderer.field_147853_m = width;
                    renderer.field_147873_r = 1;
                    renderer.field_147869_t = 1;
                    renderer.field_147871_s = 1;
                    break;
                }
                case SOUTH: {
                    renderer.field_147853_m = 1.0;
                    renderer.field_147851_l = 1.0 - width;
                    renderer.field_147869_t = 1;
                    renderer.field_147871_s = 1;
                    break;
                }
                case UP: {
                    renderer.field_147857_k = 1.0;
                    renderer.field_147855_j = 1.0 - width;
                    break;
                }
                case WEST: {
                    renderer.field_147859_h = 0.0;
                    renderer.field_147861_i = width;
                    renderer.field_147867_u = 1;
                    renderer.field_147865_v = 1;
                    renderer.field_147873_r = 1;
                    renderer.field_147875_q = 1;
                    break;
                }
            }
            i.renderBlockCurrentBounds(x, y, z, renderer);
            i.prepareBounds(renderer);
        }
    }

    private boolean isConnected(IBlockAccess w, int x, int y, int z, ForgeDirection side) {
        int tileYPos = y + side.offsetY;
        if (0 <= tileYPos && tileYPos <= 255) {
            TileEntity tile = w.func_147438_o(x + side.offsetX, tileYPos, z + side.offsetZ);
            return tile instanceof TileCraftingTile;
        }
        return false;
    }
}

