/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.render.blocks;

import appeng.api.networking.IGridHost;
import appeng.api.parts.IBoxProvider;
import appeng.api.parts.IPart;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartHost;
import appeng.api.util.IOrientable;
import appeng.block.AEBaseBlock;
import appeng.block.crafting.BlockMolecularAssembler;
import appeng.client.render.BaseBlockRender;
import appeng.client.render.BusRenderHelper;
import appeng.client.render.BusRenderer;
import appeng.client.texture.ExtraBlockTextures;
import appeng.client.texture.TaughtIcon;
import appeng.parts.networking.PartCable;
import appeng.tile.crafting.TileMolecularAssembler;
import appeng.util.Platform;
import java.util.EnumSet;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.common.util.ForgeDirection;

public class RenderBlockAssembler
extends BaseBlockRender
implements IBoxProvider {
    IIcon getConnectedCable(IBlockAccess world, int x, int y, int z, ForgeDirection side, boolean covered) {
        PartCable pc;
        IPartHost ph;
        IPart pcx;
        TileEntity ne;
        int tileYPos = y + side.offsetY;
        if (-1 < tileYPos && tileYPos < 256 && (ne = world.func_147438_o(x + side.offsetX, tileYPos, z + side.offsetZ)) instanceof IGridHost && ne instanceof IPartHost && (pcx = (ph = (IPartHost)ne).getPart(ForgeDirection.UNKNOWN)) instanceof PartCable && (pc = (PartCable)pcx).isConnected(side.getOpposite())) {
            if (covered) {
                return pc.getCoveredTexture(pc.getCableColor());
            }
            return pc.getGlassTexture(pc.getCableColor());
        }
        return null;
    }

    public void renderCableAt(double Thickness, IBlockAccess world, int x, int y, int z, AEBaseBlock block, RenderBlocks renderer, double pull, boolean covered) {
        IIcon texture = null;
        texture = this.getConnectedCable(world, x, y, z, ForgeDirection.WEST, covered);
        block.getRendererInstance().setTemporaryRenderIcon(texture);
        if (texture != null) {
            renderer.func_147782_a(0.0, 0.5 - Thickness, 0.5 - Thickness, 0.5 - Thickness - pull, 0.5 + Thickness, 0.5 + Thickness);
            renderer.func_147784_q((Block)block, x, y, z);
        }
        texture = this.getConnectedCable(world, x, y, z, ForgeDirection.EAST, covered);
        block.getRendererInstance().setTemporaryRenderIcon(texture);
        if (texture != null) {
            renderer.func_147782_a(0.5 + Thickness + pull, 0.5 - Thickness, 0.5 - Thickness, 1.0, 0.5 + Thickness, 0.5 + Thickness);
            renderer.func_147784_q((Block)block, x, y, z);
        }
        texture = this.getConnectedCable(world, x, y, z, ForgeDirection.NORTH, covered);
        block.getRendererInstance().setTemporaryRenderIcon(texture);
        if (texture != null) {
            renderer.func_147782_a(0.5 - Thickness, 0.5 - Thickness, 0.0, 0.5 + Thickness, 0.5 + Thickness, 0.5 - Thickness - pull);
            renderer.func_147784_q((Block)block, x, y, z);
        }
        texture = this.getConnectedCable(world, x, y, z, ForgeDirection.SOUTH, covered);
        block.getRendererInstance().setTemporaryRenderIcon(texture);
        if (texture != null) {
            renderer.func_147782_a(0.5 - Thickness, 0.5 - Thickness, 0.5 + Thickness + pull, 0.5 + Thickness, 0.5 + Thickness, 1.0);
            renderer.func_147784_q((Block)block, x, y, z);
        }
        texture = this.getConnectedCable(world, x, y, z, ForgeDirection.DOWN, covered);
        block.getRendererInstance().setTemporaryRenderIcon(texture);
        if (texture != null) {
            renderer.func_147782_a(0.5 - Thickness, 0.0, 0.5 - Thickness, 0.5 + Thickness, 0.5 - Thickness - pull, 0.5 + Thickness);
            renderer.func_147784_q((Block)block, x, y, z);
        }
        texture = this.getConnectedCable(world, x, y, z, ForgeDirection.UP, covered);
        block.getRendererInstance().setTemporaryRenderIcon(texture);
        if (texture != null) {
            renderer.func_147782_a(0.5 - Thickness, 0.5 + Thickness + pull, 0.5 - Thickness, 0.5 + Thickness, 1.0, 0.5 + Thickness);
            renderer.func_147784_q((Block)block, x, y, z);
        }
        block.getRendererInstance().setTemporaryRenderIcon(null);
    }

    public RenderBlockAssembler() {
        super(false, 20.0);
    }

    @Override
    public void renderInventory(AEBaseBlock blk, ItemStack is, RenderBlocks renderer, IItemRenderer.ItemRenderType type, Object[] obj) {
        renderer.func_147757_a(blk.func_149691_a(0, 0));
        this.setInvRenderBounds(renderer, 2, 14, 0, 14, 16, 2);
        this.renderInvBlock(EnumSet.allOf(ForgeDirection.class), blk, is, Tessellator.field_78398_a, 0xFFFFFF, renderer);
        this.setInvRenderBounds(renderer, 0, 14, 2, 2, 16, 14);
        this.renderInvBlock(EnumSet.allOf(ForgeDirection.class), blk, is, Tessellator.field_78398_a, 0xFFFFFF, renderer);
        this.setInvRenderBounds(renderer, 2, 0, 14, 14, 2, 16);
        this.renderInvBlock(EnumSet.allOf(ForgeDirection.class), blk, is, Tessellator.field_78398_a, 0xFFFFFF, renderer);
        this.setInvRenderBounds(renderer, 14, 0, 2, 16, 2, 14);
        this.renderInvBlock(EnumSet.allOf(ForgeDirection.class), blk, is, Tessellator.field_78398_a, 0xFFFFFF, renderer);
        this.setInvRenderBounds(renderer, 0, 0, 0, 16, 2, 2);
        this.renderInvBlock(EnumSet.allOf(ForgeDirection.class), blk, is, Tessellator.field_78398_a, 0xFFFFFF, renderer);
        this.setInvRenderBounds(renderer, 0, 2, 0, 2, 16, 2);
        this.renderInvBlock(EnumSet.allOf(ForgeDirection.class), blk, is, Tessellator.field_78398_a, 0xFFFFFF, renderer);
        this.setInvRenderBounds(renderer, 0, 0, 2, 2, 2, 16);
        this.renderInvBlock(EnumSet.allOf(ForgeDirection.class), blk, is, Tessellator.field_78398_a, 0xFFFFFF, renderer);
        this.setInvRenderBounds(renderer, 0, 14, 14, 16, 16, 16);
        this.renderInvBlock(EnumSet.allOf(ForgeDirection.class), blk, is, Tessellator.field_78398_a, 0xFFFFFF, renderer);
        this.setInvRenderBounds(renderer, 14, 0, 14, 16, 14, 16);
        this.renderInvBlock(EnumSet.allOf(ForgeDirection.class), blk, is, Tessellator.field_78398_a, 0xFFFFFF, renderer);
        this.setInvRenderBounds(renderer, 14, 14, 0, 16, 16, 14);
        this.renderInvBlock(EnumSet.allOf(ForgeDirection.class), blk, is, Tessellator.field_78398_a, 0xFFFFFF, renderer);
        this.setInvRenderBounds(renderer, 14, 2, 0, 16, 14, 2);
        this.renderInvBlock(EnumSet.allOf(ForgeDirection.class), blk, is, Tessellator.field_78398_a, 0xFFFFFF, renderer);
        this.setInvRenderBounds(renderer, 0, 2, 14, 2, 14, 16);
        this.renderInvBlock(EnumSet.allOf(ForgeDirection.class), blk, is, Tessellator.field_78398_a, 0xFFFFFF, renderer);
        this.setInvRenderBounds(renderer, 1, 1, 1, 15, 15, 15);
        this.renderInvBlock(EnumSet.allOf(ForgeDirection.class), blk, is, Tessellator.field_78398_a, 0xFFFFFF, renderer);
        renderer.func_147757_a(null);
    }

    @Override
    public boolean renderInWorld(AEBaseBlock block, IBlockAccess world, int x, int y, int z, RenderBlocks renderer) {
        BlockMolecularAssembler blk = (BlockMolecularAssembler)block;
        TileMolecularAssembler tma = (TileMolecularAssembler)blk.getTileEntity(world, x, y, z);
        if (BlockMolecularAssembler.booleanAlphaPass) {
            if (tma.isPowered()) {
                this.renderBlockBounds(renderer, 1.0, 1.0, 1.0, 15.0, 15.0, 15.0, ForgeDirection.WEST, ForgeDirection.UP, ForgeDirection.SOUTH);
                TaughtIcon lights = new TaughtIcon(ExtraBlockTextures.BlockMolecularAssemblerLights.getIcon(), -2.0f);
                Tessellator.field_78398_a.func_78369_a(1.0f, 1.0f, 1.0f, 0.3f);
                Tessellator.field_78398_a.func_78380_c(0xE000E0);
                renderer.func_147798_e((Block)blk, (double)x, (double)y, (double)z, (IIcon)lights);
                renderer.func_147764_f((Block)blk, (double)x, (double)y, (double)z, (IIcon)lights);
                renderer.func_147768_a((Block)blk, (double)x, (double)y, (double)z, (IIcon)lights);
                renderer.func_147806_b((Block)blk, (double)x, (double)y, (double)z, (IIcon)lights);
                renderer.func_147761_c((Block)blk, (double)x, (double)y, (double)z, (IIcon)lights);
                renderer.func_147734_d((Block)blk, (double)x, (double)y, (double)z, (IIcon)lights);
                return true;
            }
            return false;
        }
        BusRenderer.INSTANCE.renderer.field_147845_a = renderer.field_147845_a;
        renderer = BusRenderer.INSTANCE.renderer;
        this.preRenderInWorld(block, world, x, y, z, renderer);
        tma.lightCache = BusRenderHelper.INSTANCE.useSimplifiedRendering(x, y, z, this, tma.lightCache);
        BusRenderer.INSTANCE.renderer.isFacade = true;
        IOrientable te = this.getOrientable(block, world, x, y, z);
        ForgeDirection fdy = te.getUp();
        ForgeDirection fdz = te.getForward();
        ForgeDirection fdx = Platform.crossProduct(fdz, fdy).getOpposite();
        renderer.field_147837_f = true;
        this.renderCableAt(0.11, world, x, y, z, block, renderer, 0.141, false);
        this.renderCableAt(0.188, world, x, y, z, block, renderer, 0.1875, true);
        blk.getRendererInstance().setTemporaryRenderIcon(blk.func_149691_a(0, 0));
        this.renderBlockBounds(renderer, 2.0, 14.0, 0.0, 14.0, 16.0, 2.0, fdx, fdy, fdz);
        renderer.func_147784_q((Block)blk, x, y, z);
        this.renderBlockBounds(renderer, 0.0, 14.0, 2.0, 2.0, 16.0, 14.0, fdx, fdy, fdz);
        renderer.func_147784_q((Block)blk, x, y, z);
        this.renderBlockBounds(renderer, 2.0, 0.0, 14.0, 14.0, 2.0, 16.0, fdx, fdy, fdz);
        renderer.func_147784_q((Block)blk, x, y, z);
        this.renderBlockBounds(renderer, 14.0, 0.0, 2.0, 16.0, 2.0, 14.0, fdx, fdy, fdz);
        renderer.func_147784_q((Block)blk, x, y, z);
        this.renderBlockBounds(renderer, 0.0, 0.0, 0.0, 16.0, 2.0, 2.0, fdx, fdy, fdz);
        renderer.func_147784_q((Block)blk, x, y, z);
        this.renderBlockBounds(renderer, 0.0, 2.0, 0.0, 2.0, 16.0, 2.0, fdx, fdy, fdz);
        renderer.func_147784_q((Block)blk, x, y, z);
        this.renderBlockBounds(renderer, 0.0, 0.0, 2.0, 2.0, 2.0, 16.0, fdx, fdy, fdz);
        renderer.func_147784_q((Block)blk, x, y, z);
        this.renderBlockBounds(renderer, 0.0, 14.0, 14.0, 16.0, 16.0, 16.0, fdx, fdy, fdz);
        renderer.func_147784_q((Block)blk, x, y, z);
        this.renderBlockBounds(renderer, 14.0, 0.0, 14.0, 16.0, 14.0, 16.0, fdx, fdy, fdz);
        renderer.func_147784_q((Block)blk, x, y, z);
        this.renderBlockBounds(renderer, 14.0, 14.0, 0.0, 16.0, 16.0, 14.0, fdx, fdy, fdz);
        renderer.func_147784_q((Block)blk, x, y, z);
        this.renderBlockBounds(renderer, 14.0, 2.0, 0.0, 16.0, 14.0, 2.0, fdx, fdy, fdz);
        renderer.func_147784_q((Block)blk, x, y, z);
        this.renderBlockBounds(renderer, 0.0, 2.0, 14.0, 2.0, 14.0, 16.0, fdx, fdy, fdz);
        renderer.func_147784_q((Block)blk, x, y, z);
        this.renderBlockBounds(renderer, 1.0, 1.0, 1.0, 15.0, 15.0, 15.0, fdx, fdy, fdz);
        renderer.func_147784_q((Block)blk, x, y, z);
        BusRenderHelper.INSTANCE.normalRendering();
        blk.getRendererInstance().setTemporaryRenderIcon(null);
        renderer.field_147837_f = false;
        BusRenderer.INSTANCE.renderer.isFacade = false;
        this.postRenderInWorld(renderer);
        return true;
    }

    @Override
    public void getBoxes(IPartCollisionHelper bch) {
        bch.addBox(0.0, 0.0, 0.0, 16.0, 16.0, 16.0);
    }
}

