/*
 * Decompiled with CFR 0.152.
 */
package appeng.client.gui.implementations;

import appeng.api.config.FuzzyMode;
import appeng.api.config.RedstoneMode;
import appeng.api.config.Settings;
import appeng.api.config.Upgrades;
import appeng.api.config.YesNo;
import appeng.api.implementations.IUpgradeableHost;
import appeng.client.gui.AEBaseGui;
import appeng.client.gui.widgets.GuiImgButton;
import appeng.container.implementations.ContainerUpgradeable;
import appeng.core.localization.GuiText;
import appeng.core.sync.network.NetworkHandler;
import appeng.core.sync.packets.PacketConfigButton;
import appeng.parts.automation.PartImportBus;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.InventoryPlayer;
import org.lwjgl.input.Mouse;

public class GuiUpgradeable
extends AEBaseGui {
    final ContainerUpgradeable cvb;
    final IUpgradeableHost bc;
    GuiImgButton redstoneMode;
    GuiImgButton fuzzyMode;
    GuiImgButton craftMode;

    public GuiUpgradeable(InventoryPlayer inventoryPlayer, IUpgradeableHost te) {
        this(new ContainerUpgradeable(inventoryPlayer, te));
    }

    public GuiUpgradeable(ContainerUpgradeable te) {
        super(te);
        this.cvb = te;
        this.bc = (IUpgradeableHost)te.getTarget();
        this.field_146999_f = this.hasToolbox() ? 246 : 211;
        this.field_147000_g = 184;
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.addButtons();
    }

    protected void addButtons() {
        this.redstoneMode = new GuiImgButton(this.field_147003_i - 18, this.field_147009_r + 8, Settings.REDSTONE_CONTROLLED, RedstoneMode.IGNORE);
        this.fuzzyMode = new GuiImgButton(this.field_147003_i - 18, this.field_147009_r + 28, Settings.FUZZY_MODE, FuzzyMode.IGNORE_ALL);
        this.craftMode = new GuiImgButton(this.field_147003_i - 18, this.field_147009_r + 48, Settings.CRAFT_ONLY, YesNo.NO);
        this.field_146292_n.add(this.craftMode);
        this.field_146292_n.add(this.redstoneMode);
        this.field_146292_n.add(this.fuzzyMode);
    }

    protected void func_146284_a(GuiButton btn) {
        super.func_146284_a(btn);
        boolean backwards = Mouse.isButtonDown((int)1);
        if (btn == this.redstoneMode) {
            NetworkHandler.instance.sendToServer(new PacketConfigButton(this.redstoneMode.getSetting(), backwards));
        }
        if (btn == this.craftMode) {
            NetworkHandler.instance.sendToServer(new PacketConfigButton(this.craftMode.getSetting(), backwards));
        }
        if (btn == this.fuzzyMode) {
            NetworkHandler.instance.sendToServer(new PacketConfigButton(this.fuzzyMode.getSetting(), backwards));
        }
    }

    protected boolean hasToolbox() {
        return ((ContainerUpgradeable)this.field_147002_h).hasToolbox();
    }

    @Override
    public void drawBG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.handleButtonVisibility();
        this.bindTexture(this.getBackground());
        this.func_73729_b(offsetX, offsetY, 0, 0, 177, this.field_147000_g);
        if (this.drawUpgrades()) {
            this.func_73729_b(offsetX + 177, offsetY, 177, 0, 35, 14 + this.cvb.availableUpgrades() * 18);
        }
        if (this.hasToolbox()) {
            this.func_73729_b(offsetX + 178, offsetY + this.field_147000_g - 90, 178, this.field_147000_g - 90, 68, 68);
        }
    }

    protected boolean drawUpgrades() {
        return true;
    }

    protected String getBackground() {
        return "guis/bus.png";
    }

    protected void handleButtonVisibility() {
        if (this.redstoneMode != null) {
            this.redstoneMode.setVisibility(this.bc.getInstalledUpgrades(Upgrades.REDSTONE) > 0);
        }
        if (this.fuzzyMode != null) {
            this.fuzzyMode.setVisibility(this.bc.getInstalledUpgrades(Upgrades.FUZZY) > 0);
        }
        if (this.craftMode != null) {
            this.craftMode.setVisibility(this.bc.getInstalledUpgrades(Upgrades.CRAFTING) > 0);
        }
    }

    @Override
    public void drawFG(int offsetX, int offsetY, int mouseX, int mouseY) {
        this.field_146289_q.func_78276_b(this.getGuiDisplayName(this.getName().getLocal()), 8, 6, 0x404040);
        this.field_146289_q.func_78276_b(GuiText.inventory.getLocal(), 8, this.field_147000_g - 96 + 3, 0x404040);
        if (this.redstoneMode != null) {
            this.redstoneMode.set(this.cvb.rsMode);
        }
        if (this.fuzzyMode != null) {
            this.fuzzyMode.set(this.cvb.fzMode);
        }
        if (this.craftMode != null) {
            this.craftMode.set(this.cvb.cMode);
        }
    }

    protected GuiText getName() {
        return this.bc instanceof PartImportBus ? GuiText.ImportBus : GuiText.ExportBus;
    }
}

