/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.tileEntities;

import buildcraftAdditions.config.ConfigurationHandler;
import buildcraftAdditions.tileEntities.Bases.TileCoilBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidHandler;

public class TileLavaCoil
extends TileCoilBase
implements IFluidHandler {
    public static int lavaVar;
    public int lava;

    public TileLavaCoil() {
        this.burnTime = 0;
        this.fullBurnTime = 0;
        this.lava = 0;
        this.shouldHeat = false;
        this.burning = false;
    }

    public static int getLavaAmount() {
        return lavaVar;
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.lava = tag.func_74762_e("lava");
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74768_a("lava", this.lava);
    }

    @Override
    public void func_145845_h() {
        lavaVar = this.lava;
        if (this.isBurning() && this.burnTime > 0) {
            --this.burnTime;
        }
        if (this.burnTime == 0) {
            this.burning = false;
        }
        if (!this.isBurning() && this.shouldHeat && this.lava >= 100) {
            this.lava -= 100;
            this.burnTime = 10000;
            this.increment = ConfigurationHandler.lavaCoilHeat;
            this.burning = true;
        }
        if (!this.isBurning()) {
            this.increment = 0;
        }
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        if (resource.getFluid().getID() == FluidRegistry.LAVA.getID()) {
            int amount = 3000;
            if (doFill) {
                if (resource.amount > 3000 - this.lava) {
                    amount = 3000 - this.lava;
                } else if (resource.amount < 3000 - this.lava) {
                    amount = resource.amount;
                }
                this.lava += amount;
                return amount;
            }
            if (resource.amount > 3000 - this.lava) {
                amount = 3000 - this.lava;
            } else if (resource.amount < 3000 - this.lava) {
                amount = resource.amount;
            }
            return amount;
        }
        return 0;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        if (doDrain) {
            int amount = maxDrain;
            if (maxDrain > this.lava) {
                amount = this.lava;
            }
            this.lava -= amount;
            return new FluidStack(FluidRegistry.LAVA, amount);
        }
        int amount = maxDrain;
        if (maxDrain > this.lava) {
            amount = this.lava;
        }
        return new FluidStack(FluidRegistry.LAVA, amount);
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return fluid == FluidRegistry.LAVA;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{new FluidTankInfo(new FluidStack(FluidRegistry.LAVA, this.lava), 3000)};
    }
}

