/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.tileEntities;

import buildcraftAdditions.BuildcraftAdditions;
import buildcraftAdditions.blocks.multiBlocks.MulitBlockBase;
import buildcraftAdditions.config.ConfigurationHandler;
import buildcraftAdditions.core.Logger;
import buildcraftAdditions.multiBlocks.IMultiBlockTile;
import buildcraftAdditions.multiBlocks.MultiBlockPatern;
import buildcraftAdditions.multiBlocks.MultiBlockPaternKEBT2;
import buildcraftAdditions.networking.MessageKEBT2;
import buildcraftAdditions.networking.PacketHandeler;
import buildcraftAdditions.reference.ItemsAndBlocks;
import buildcraftAdditions.tileEntities.Bases.TileKineticEnergyBufferBase;
import buildcraftAdditions.utils.Location;
import cofh.api.energy.IEnergyHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import eureka.api.EurekaKnowledge;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;

public class TileKEBT2
extends TileKineticEnergyBufferBase
implements IMultiBlockTile {
    public MultiBlockPatern patern = new MultiBlockPaternKEBT2();
    public boolean isMaster;
    public boolean partOfMultiBlock;
    public boolean moved = false;
    public boolean renderUpdate = true;
    public int masterX;
    public int masterY;
    public int masterZ;
    public int energyState;
    public int lastEnergyState;
    public int oldmasterX;
    public int oldmasterY;
    public int oldmasterZ;
    public TileKEBT2 master;

    public TileKEBT2() {
        super(25000000, 75000, 75000, ConfigurationHandler.KEB2powerloss, 2);
    }

    @Override
    public void func_145845_h() {
        if (this.moved) {
            if (!this.patern.isPaternValid(this.field_145850_b, this.masterX, this.masterY, this.masterZ)) {
                this.patern.destroyMultiblock(this.field_145850_b, this.masterX, this.masterY, this.masterZ);
                this.patern.destroyMultiblock(this.field_145850_b, this.oldmasterX, this.oldmasterY, this.oldmasterZ);
            }
            this.moved = false;
        }
        if (this.renderUpdate) {
            this.sync();
        }
        if (!this.isMaster || this.field_145850_b.field_72995_K) {
            return;
        }
        super.func_145845_h();
        this.energyState = this.energy * 5 / this.maxEnergy;
        if (this.energyState != this.lastEnergyState) {
            this.renderUpdate = true;
        }
        this.lastEnergyState = this.energyState;
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (!this.partOfMultiBlock) {
            return 0;
        }
        if (this.isMaster) {
            return super.receiveEnergy(from, maxReceive, simulate);
        }
        if (this.master == null) {
            this.findMaster();
        }
        if (this.master == null) {
            return 0;
        }
        return this.master.receiveEnergy(from, maxReceive, simulate);
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        if (!this.partOfMultiBlock) {
            return 0;
        }
        if (this.isMaster) {
            return super.extractEnergy(from, maxExtract, simulate);
        }
        if (this.master == null) {
            this.findMaster();
        }
        if (this.master == null) {
            return 0;
        }
        return this.master.receiveEnergy(from, maxExtract, simulate);
    }

    @Override
    public void changeSideMode(int side) {
        if (!this.partOfMultiBlock) {
            return;
        }
        if (this.isMaster) {
            super.changeSideMode(side);
            return;
        }
        if (this.master == null) {
            this.findMaster();
        }
        if (this.master == null) {
            return;
        }
        this.master.changeSideMode(side);
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        if (!this.partOfMultiBlock) {
            return 0;
        }
        if (this.isMaster) {
            return super.getEnergyStored(from);
        }
        if (this.master == null) {
            this.findMaster();
        }
        if (this.master == null) {
            return 0;
        }
        return this.master.getEnergyStored(from);
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        if (!this.partOfMultiBlock) {
            return 0;
        }
        if (this.isMaster) {
            return super.getMaxEnergyStored(from);
        }
        if (this.master == null) {
            this.findMaster();
        }
        if (this.master == null) {
            return 0;
        }
        return this.master.getMaxEnergyStored(from);
    }

    @Override
    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.masterX = tag.func_74762_e("masterX");
        this.masterY = tag.func_74762_e("masterY");
        this.masterZ = tag.func_74762_e("masterZ");
        this.isMaster = tag.func_74767_n("isMaster");
        this.partOfMultiBlock = tag.func_74767_n("partOfMultiblock");
    }

    @Override
    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74768_a("masterX", this.masterX);
        tag.func_74768_a("masterY", this.masterY);
        tag.func_74768_a("masterZ", this.masterZ);
        tag.func_74757_a("isMaster", this.isMaster);
        tag.func_74757_a("partOfMultiblock", this.partOfMultiBlock);
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        if (!this.partOfMultiBlock) {
            return false;
        }
        if (this.isMaster) {
            return super.canConnectEnergy(from);
        }
        if (this.master == null) {
            this.findMaster();
        }
        if (this.master == null) {
            return false;
        }
        return this.master.canConnectEnergy(from);
    }

    @Override
    public void outputEnergy() {
        if (this.energy == 0) {
            return;
        }
        ArrayList<Location> list = this.patern.getLocations(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        for (Location from : list) {
            for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
                if (this.configuration[direction.ordinal()] != 1) continue;
                Location location = from.copy();
                location.move(direction);
                IEnergyHandler target = (IEnergyHandler)location.getTileEntity();
                if (target == null || target instanceof TileKEBT2) continue;
                int output = this.maxOutput;
                if (output > this.energy) {
                    output = this.energy;
                }
                this.energy -= target.receiveEnergy(direction.getOpposite(), output, false);
            }
        }
    }

    @Override
    public boolean onBlockActivated(EntityPlayer player) {
        if (!this.partOfMultiBlock) {
            return false;
        }
        if (!this.field_145850_b.field_72995_K) {
            this.sync();
        }
        if (this.isMaster) {
            player.openGui((Object)BuildcraftAdditions.instance, 75, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        } else if (this.master == null) {
            this.findMaster();
        }
        if (this.master != null) {
            this.master.onBlockActivated(player);
        }
        return true;
    }

    public void destroyMultiblock() {
        MultiBlockPaternKEBT2 patern = new MultiBlockPaternKEBT2();
        patern.destroyMultiblock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    private void findMaster() {
        TileEntity tileEntity;
        if (this.isMaster) {
            this.master = (TileKEBT2)this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if ((tileEntity = this.field_145850_b.func_147438_o(this.masterX, this.masterY, this.masterZ)) != null && tileEntity instanceof IMultiBlockTile) {
            this.master = (TileKEBT2)tileEntity;
        } else {
            Logger.info("UNABLE TO FIND MASTER, SELF DESTRUCT INITIATED");
            MulitBlockBase block = (MulitBlockBase)this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            block.patern.destroyMultiblock(this.field_145850_b, this.masterX, this.masterY, this.masterZ);
        }
    }

    @Override
    public void makeMaster() {
        this.isMaster = true;
        this.partOfMultiBlock = true;
        EurekaKnowledge.makeProgress((EntityPlayer)this.destroyer, (String)"KEBT3", (int)1);
    }

    @Override
    public void sync() {
        if (!this.field_145850_b.field_72995_K) {
            PacketHandeler.instance.sendToAllAround((IMessage)new MessageKEBT2(this), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 15.0));
        }
    }

    @Override
    public void formMultiblock(int masterX, int masterY, int masterZ) {
        this.partOfMultiBlock = true;
        this.masterX = masterX;
        this.masterY = masterY;
        this.masterZ = masterZ;
        this.renderUpdate = true;
    }

    @Override
    public void invalidateMultiblock() {
        if (this.isMaster) {
            this.patern.destroyMultiblock(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            EurekaKnowledge.makeProgress((EntityPlayer)this.destroyer, (String)"KEBT3", (int)-1);
        } else {
            this.patern.destroyMultiblock(this.field_145850_b, this.masterX, this.masterY, this.masterZ);
        }
    }

    @Override
    public void invalidateBlock() {
        this.partOfMultiBlock = false;
        this.isMaster = false;
        this.energy = 0;
        for (int teller = 0; teller < 6; ++teller) {
            this.configuration[teller] = 0;
        }
        this.energyState = 0;
        this.lastEnergyState = 0;
        this.field_145850_b.func_72921_c(this.field_145851_c, this.field_145848_d, this.field_145849_e, 0, 2);
        this.field_145850_b.func_147464_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, (Block)ItemsAndBlocks.kebT2, 80);
        this.sync();
    }

    public void destruction() {
        if (this.isMaster) {
            this.byeBye();
        }
        if (this.master == null) {
            this.findMaster();
        }
        if (this.master != null) {
            this.master.byeBye();
        }
    }
}

