/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.tileEntities;

import buildcraftAdditions.inventories.CustomInventory;
import buildcraftAdditions.networking.MessageFluidicCompressorC;
import buildcraftAdditions.networking.PacketHandeler;
import buildcraftAdditions.tileEntities.Bases.TileMachineBase;
import buildcraftAdditions.utils.Tank;
import buildcraftAdditions.utils.Utils;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidContainerItem;
import net.minecraftforge.fluids.IFluidHandler;
import net.minecraftforge.fluids.IFluidTank;

public class TileFluidicCompressor
extends TileMachineBase
implements ISidedInventory,
IFluidHandler {
    public final int maxLiquid = 10000;
    public Tank tank = new Tank(10000, this);
    private final CustomInventory inventory = new CustomInventory("FluidicCompressor", 2, 1, this);
    public boolean fill;
    public boolean sync;

    public TileFluidicCompressor() {
        super(800);
    }

    @Override
    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ItemStack itemstack = this.inventory.func_70301_a(0);
        if (itemstack != null) {
            IFluidContainerItem item = null;
            Item itemInSlot = itemstack.func_77973_b();
            if (itemInSlot instanceof IFluidContainerItem) {
                item = (IFluidContainerItem)itemstack.func_77973_b();
            }
            if (item != null) {
                int amount = 100;
                if (this.fill && !this.tank.isEmpty()) {
                    if (this.tank.getFluid().amount < 100) {
                        amount = this.tank.getFluid().amount;
                    }
                    if (this.energy >= amount) {
                        this.drain(ForgeDirection.UNKNOWN, item.fill(itemstack, new FluidStack(this.tank.getFluid(), amount), true), true);
                        this.energy -= amount;
                        FluidStack fluid = Utils.getFluidStackFromItemStack(itemstack);
                        if (fluid != null && this.getProgress() == 16) {
                            if (this.inventory.func_70301_a(1) == null) {
                                this.inventory.func_70299_a(1, itemstack);
                                this.inventory.func_70299_a(0, null);
                            } else if (this.inventory.func_70301_a(1).func_77973_b() == this.inventory.func_70301_a(0).func_77973_b() && this.inventory.func_70301_a((int)1).field_77994_a < 4) {
                                ++this.inventory.func_70301_a((int)1).field_77994_a;
                                this.inventory.func_70299_a(0, null);
                            }
                        }
                    }
                } else {
                    amount = 50;
                    if (!this.fill && !this.tank.isFull() && Utils.getFluidStackFromItemStack(itemstack) != null) {
                        if (!this.tank.isEmpty() && this.tank.getCapacity() - this.tank.getFluid().amount < 1000) {
                            amount = this.tank.getCapacity() - this.tank.getFluid().amount;
                        }
                        if (amount > Utils.getFluidStackFromItemStack((ItemStack)itemstack).amount) {
                            amount = Utils.getFluidStackFromItemStack((ItemStack)itemstack).amount;
                        }
                        this.fill(ForgeDirection.UNKNOWN, item.drain(itemstack, amount, true), true);
                        if (this.getProgress() >= 16) {
                            itemstack.func_77978_p().func_82580_o("Fluid");
                            if (this.inventory.func_70301_a(1) == null) {
                                this.inventory.func_70299_a(1, itemstack);
                                this.inventory.func_70299_a(0, null);
                            } else if (this.inventory.func_70301_a(1).func_77973_b() == this.inventory.func_70301_a(0).func_77973_b() && this.inventory.func_70301_a((int)1).field_77994_a < 4) {
                                ++this.inventory.func_70301_a((int)1).field_77994_a;
                                this.inventory.func_70299_a(0, null);
                            }
                        }
                    }
                }
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbtTagCompound) {
        super.func_145839_a(nbtTagCompound);
        this.inventory.readNBT(nbtTagCompound);
        this.tank.readFromNBT(nbtTagCompound);
        this.fill = nbtTagCompound.func_74767_n("fill");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbtTagCompound) {
        super.func_145841_b(nbtTagCompound);
        this.inventory.writeNBT(nbtTagCompound);
        this.tank.writeToNBT(nbtTagCompound);
        nbtTagCompound.func_74757_a("fill", this.fill);
    }

    public int func_70302_i_() {
        return this.inventory.func_70302_i_();
    }

    public ItemStack func_70301_a(int slotId) {
        return this.inventory.func_70301_a(slotId);
    }

    public ItemStack func_70298_a(int slotId, int count) {
        return this.inventory.func_70298_a(slotId, count);
    }

    public ItemStack func_70304_b(int var1) {
        return this.inventory.func_70304_b(var1);
    }

    public void func_70299_a(int slotId, ItemStack itemstack) {
        this.inventory.func_70299_a(slotId, itemstack);
    }

    public String func_145825_b() {
        return this.inventory.func_145825_b();
    }

    public boolean func_145818_k_() {
        return this.inventory.func_145818_k_();
    }

    public int func_70297_j_() {
        return this.inventory.func_70297_j_();
    }

    public boolean func_70300_a(EntityPlayer entityPlayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this && entityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
        this.inventory.func_70295_k_();
    }

    public void func_70305_f() {
        this.inventory.func_70295_k_();
    }

    public boolean func_94041_b(int slotid, ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        Item item = itemStack.func_77973_b();
        return slotid == 0 && item instanceof IFluidContainerItem;
    }

    public int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int amount = this.tank.fill(resource, doFill);
        if (this.sync) {
            PacketHandeler.instance.sendToAllAround((IMessage)new MessageFluidicCompressorC(this), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 5.0));
        }
        return amount;
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        FluidStack fluid = this.tank.drain(maxDrain, doDrain);
        if (this.sync) {
            PacketHandeler.instance.sendToAllAround((IMessage)new MessageFluidicCompressorC(this), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 5.0));
        }
        return fluid;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return this.tank.getFluidType() == fluid;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        return new FluidTankInfo[]{new FluidTankInfo((IFluidTank)this.tank)};
    }

    public FluidStack getFluid() {
        return this.tank.getFluid();
    }

    public int getScaledLiquid(int i) {
        return this.tank.getFluid() != null ? (int)((float)this.tank.getFluid().amount / 10000.0f * (float)i) : 0;
    }

    public int getProgress() {
        ItemStack itemstack = this.inventory.func_70301_a(0);
        if (itemstack == null) {
            return 0;
        }
        Item item = itemstack.func_77973_b();
        if (!(item instanceof IFluidContainerItem)) {
            return 0;
        }
        FluidStack fluidstack = Utils.getFluidStackFromItemStack(itemstack);
        IFluidContainerItem canister = (IFluidContainerItem)itemstack.func_77973_b();
        if (fluidstack == null) {
            if (this.fill) {
                return 0;
            }
            return 0;
        }
        int capacity = canister.getCapacity(itemstack);
        if (this.fill) {
            return fluidstack.amount * 16 / capacity;
        }
        return (capacity - fluidstack.amount) * 16 / capacity;
    }

    public int[] func_94128_d(int side) {
        return Utils.createSlotArray(0, 2);
    }

    public boolean func_102007_a(int slot, ItemStack stack, int side) {
        return side != 0 && this.func_94041_b(slot, stack);
    }

    public boolean func_102008_b(int slot, ItemStack stack, int side) {
        return slot == 1;
    }

    public int getEnergyStored() {
        return this.energy;
    }

    public int getFluidStored() {
        if (this.tank.getFluid() != null) {
            return this.tank.getFluid().amount;
        }
        return 0;
    }
}

