/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.tileEntities.Bases;

import buildcraftAdditions.config.ConfigurationHandler;
import buildcraftAdditions.networking.MessageKEBConfiguration;
import buildcraftAdditions.networking.MessageSelfDestruct;
import buildcraftAdditions.networking.PacketHandeler;
import buildcraftAdditions.utils.Location;
import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyReceiver;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.Explosion;
import net.minecraftforge.common.util.ForgeDirection;

public abstract class TileKineticEnergyBufferBase
extends TileEntity
implements IEnergyHandler {
    public int energy;
    public int maxEnergy;
    public int maxInput;
    public int maxOutput;
    public int loss;
    public int fuse;
    public int[] configuration = new int[6];
    public int tier;
    public int timer;
    public boolean sync;
    public boolean selfDestruct;
    public String owner = "";
    public EntityPlayer destroyer;

    public TileKineticEnergyBufferBase(int maxEnergy, int maxInput, int maxOutput, int loss, int tier) {
        this.maxEnergy = maxEnergy;
        this.maxInput = maxInput;
        this.maxOutput = maxOutput;
        this.loss = loss;
        this.tier = tier;
        for (int teller = 0; teller < 6; ++teller) {
            this.configuration[teller] = 0;
        }
    }

    @Override
    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        if (this.configuration[from.ordinal()] != 0) {
            return 0;
        }
        int recieved = maxReceive;
        if (recieved > this.maxEnergy - this.energy) {
            recieved = this.maxEnergy - this.energy;
        }
        if (recieved > this.maxInput) {
            recieved = this.maxInput;
        }
        if (!simulate) {
            this.energy += recieved;
        }
        return recieved;
    }

    @Override
    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        if (this.configuration[from.ordinal()] != 1) {
            return 0;
        }
        int extracted = maxExtract;
        if (extracted > this.energy) {
            extracted = this.energy;
        }
        if (extracted > this.maxOutput) {
            extracted = this.maxOutput;
        }
        if (!simulate) {
            this.energy -= extracted;
        }
        return extracted;
    }

    public void changeSideMode(int side) {
        ForgeDirection direction = ForgeDirection.getOrientation((int)side);
        if (this.configuration[direction.ordinal()] == 0) {
            this.configuration[direction.ordinal()] = 1;
            return;
        }
        if (this.configuration[direction.ordinal()] == 1) {
            this.configuration[direction.ordinal()] = 2;
            return;
        }
        this.configuration[direction.ordinal()] = 0;
    }

    @Override
    public int getEnergyStored(ForgeDirection from) {
        return this.energy;
    }

    @Override
    public int getMaxEnergyStored(ForgeDirection from) {
        return this.maxEnergy;
    }

    public void func_145839_a(NBTTagCompound tag) {
        super.func_145839_a(tag);
        this.energy = tag.func_74762_e("energy");
        this.maxEnergy = tag.func_74762_e("maxEnergy");
        this.maxInput = tag.func_74762_e("maxInput");
        this.maxOutput = tag.func_74762_e("maxOutput");
        this.loss = tag.func_74762_e("loss");
        if (tag.func_74764_b("configuration")) {
            this.configuration = tag.func_74759_k("configuration");
        }
        if (tag.func_74764_b("owner")) {
            this.owner = tag.func_74779_i("owner");
        }
    }

    public void func_145841_b(NBTTagCompound tag) {
        super.func_145841_b(tag);
        tag.func_74768_a("energy", this.energy);
        tag.func_74768_a("maxEnergy", this.maxEnergy);
        tag.func_74768_a("maxInput", this.maxInput);
        tag.func_74768_a("maxOutput", this.maxOutput);
        tag.func_74768_a("loss", this.loss);
        tag.func_74783_a("configuration", this.configuration);
        if (this.owner != null) {
            tag.func_74778_a("owner", this.owner);
        }
    }

    public void func_145845_h() {
        if (this.selfDestruct) {
            --this.fuse;
            if (this.fuse % 20 == 0) {
                this.destroyer.func_146105_b((IChatComponent)new ChatComponentText("SELF DESTUCTION IN: " + this.fuse / 20));
            }
        }
        if (this.fuse <= 0 && this.selfDestruct) {
            this.byeBye();
        }
        if (this.sync) {
            if (this.timer == 0) {
                this.sync();
                this.timer = 20;
            }
            --this.timer;
        }
        if (ConfigurationHandler.powerloss) {
            this.energy -= this.loss;
        }
        if (this.energy < 0) {
            this.energy = 0;
        }
        this.outputEnergy();
    }

    public void outputEnergy() {
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            if (this.configuration[direction.ordinal()] != 1) continue;
            Location location = new Location(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
            location.move(direction);
            IEnergyHandler energyHandler = null;
            if (location.getTileEntity() != null && location.getTileEntity() instanceof IEnergyReceiver) {
                energyHandler = (IEnergyHandler)location.getTileEntity();
            }
            if (energyHandler == null) continue;
            int sendEnergy = this.energy;
            if (sendEnergy > this.maxOutput) {
                sendEnergy = this.maxOutput;
            }
            this.energy -= energyHandler.receiveEnergy(direction.getOpposite(), sendEnergy, false);
        }
    }

    @Override
    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    public abstract void sync();

    public void sendConfigurationToSever() {
        PacketHandeler.instance.sendToServer((IMessage)new MessageKEBConfiguration(this));
    }

    public void setOwner(String owner) {
        this.owner = owner;
    }

    public void activateSelfDestruct() {
        if (this.field_145850_b.field_72995_K) {
            PacketHandeler.instance.sendToServer((IMessage)new MessageSelfDestruct(this.field_145851_c, this.field_145848_d, this.field_145849_e));
            return;
        }
        this.selfDestruct = true;
        this.fuse = 100;
        this.destroyer.func_146105_b((IChatComponent)new ChatComponentText("SELF DESTRUCT ACTIVATED"));
        this.destroyer.func_71053_j();
    }

    public void byeBye() {
        Explosion explosion = this.field_145850_b.func_72876_a((Entity)this.destroyer, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (float)(this.energy / 900000 + 5), true);
        explosion.func_77278_a();
        explosion.func_77279_a(true);
    }
}

