/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.multiBlocks;

import buildcraftAdditions.blocks.multiBlocks.MulitBlockBase;
import buildcraftAdditions.multiBlocks.IMultiBlockTile;
import buildcraftAdditions.utils.Location;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;

public class MultiBlockPatern {
    public ForgeDirection[] directions;
    public char[] identifiers;
    public HashMap<String, String> replacements = new HashMap(5);

    public MultiBlockPatern(ForgeDirection[] directions, char identifier) {
        int length = directions.length;
        this.directions = directions;
        this.identifiers = new char[length];
        for (int t = 0; t < length; ++t) {
            this.identifiers[t] = identifier;
        }
    }

    public MultiBlockPatern(ForgeDirection[] directions, char[] identifiers, HashMap<String, String> replacements) {
        this.directions = directions;
        this.identifiers = identifiers;
        this.replacements = replacements;
    }

    public MultiBlockPatern(ForgeDirection[] directions, char identifier, HashMap<String, String> replacements) {
        int length = directions.length;
        this.directions = directions;
        this.identifiers = new char[length];
        for (int t = 0; t < length; ++t) {
            this.identifiers[t] = identifier;
        }
        this.replacements = replacements;
    }

    public void checkPatern(World world, int x, int y, int z) {
        if (this.isPaternValid(world, x, y, z)) {
            Location location = new Location(world, x, y, z);
            for (ForgeDirection direction : this.directions) {
                location.move(direction);
                location.setMetadata(1);
                IMultiBlockTile slave = (IMultiBlockTile)location.getTileEntity();
                slave.formMultiblock(x, y, z);
            }
            this.addMaster(world, x, y, z);
        }
    }

    public boolean isPaternValid(World world, int startX, int startY, int startZ) {
        Location location = new Location(world, startX, startY, startZ);
        int length = this.directions.length;
        for (int t = 0; t < length; ++t) {
            ForgeDirection direction = this.directions[t];
            location.move(direction);
            if (!(location.getBlock() instanceof MulitBlockBase)) {
                return false;
            }
            MulitBlockBase block = (MulitBlockBase)location.getBlock();
            if (block.identifier == this.identifiers[t] && location.getMeatadata() == 0) continue;
            return false;
        }
        return true;
    }

    public void destroyMultiblock(World world, int x, int y, int z) {
        Location location = new Location(world, x, y, z);
        for (ForgeDirection direction : this.directions) {
            location.move(direction);
            if (!(location.getTileEntity() instanceof IMultiBlockTile)) continue;
            ((IMultiBlockTile)location.getTileEntity()).invalidateBlock();
        }
    }

    public ArrayList<Location> getLocations(World world, int masterX, int masterY, int masterZ) {
        ArrayList<Location> list = new ArrayList<Location>(this.directions.length);
        Location location = new Location(world, masterX, masterY, masterZ);
        for (ForgeDirection direction : this.directions) {
            location.move(direction);
            list.add(location.copy());
        }
        return list;
    }

    public void addMaster(World world, int x, int y, int z) {
        TileEntity entity = world.func_147438_o(x, y, z);
        if (entity != null && entity instanceof IMultiBlockTile) {
            IMultiBlockTile master = (IMultiBlockTile)entity;
            master.makeMaster();
            master.sync();
        }
    }
}

