/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.items.Tools;

import buildcraftAdditions.BuildcraftAdditions;
import buildcraftAdditions.items.Tools.ItemPoweredBase;
import buildcraftAdditions.utils.Utils;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.world.World;

public class ItemKineticTool
extends ItemPoweredBase {
    public boolean chainsaw;
    public boolean digger;
    public boolean drill;
    public boolean hoe;
    public boolean goldStick;
    public boolean diamondStick;
    public boolean emeraldStick;
    public int upgradesAllowed;
    public IIcon icon;
    public IIcon iconAlt;
    public IIcon overlayChainsaw;
    public IIcon overlayDigger;
    public IIcon overlayDrill;
    public IIcon overlayHoe;
    public IIcon iconChainsaw;
    public IIcon iconDigger;
    public IIcon iconDrill;
    public IIcon iconHoe;
    String lastMode;

    public ItemKineticTool() {
        this.func_77655_b("kineticMultiTool");
        this.func_77637_a(BuildcraftAdditions.bcadditions);
        this.func_77625_d(1);
        this.func_77664_n();
        this.chainsaw = false;
        this.digger = false;
        this.drill = false;
        this.hoe = false;
        this.upgradesAllowed = 1;
        this.goldStick = false;
        this.diamondStick = false;
        this.emeraldStick = false;
        this.lastMode = "nothing";
    }

    @Override
    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (stack.func_77978_p() == null) {
            stack.func_77982_d(new NBTTagCompound());
        }
        if (player.func_70093_af() && !world.field_72995_K) {
            player.openGui((Object)BuildcraftAdditions.instance, 72, world, this.x, this.y, this.z);
        }
        this.readUpgrades(stack);
        this.readBateries(stack, player);
        this.showDurabilityBar(stack);
        return stack;
    }

    public boolean isStickInstalled(ItemStack stack, String Stick) {
        this.readUpgrades(stack);
        if (Stick.equals("goldStick")) {
            return this.goldStick;
        }
        if (Stick.equals("diamondStick")) {
            return this.diamondStick;
        }
        if (Stick.equals("emeraldStick")) {
            return this.emeraldStick;
        }
        return false;
    }

    public void installStick(ItemStack stack, String Stick) {
        this.readUpgrades(stack);
        if (!this.isStickInstalled(stack, Stick)) {
            if (Stick.equals("goldStick")) {
                this.goldStick = true;
            }
            if (Stick.equals("diamondStick")) {
                this.diamondStick = true;
            }
            if (Stick.equals("emeraldStick")) {
                this.emeraldStick = true;
            }
        }
        ++this.upgradesAllowed;
        this.writeUpgrades(stack);
    }

    public boolean isUpgradeInstalled(ItemStack stack, String upgrade) {
        this.readUpgrades(stack);
        if (upgrade.equals("Chainsaw")) {
            return this.chainsaw;
        }
        if (upgrade.equals("Digger")) {
            return this.digger;
        }
        if (upgrade.equals("Drill")) {
            return this.drill;
        }
        if (upgrade.equals("Hoe")) {
            return this.hoe;
        }
        return false;
    }

    public void readUpgrades(ItemStack stack) {
        if (stack.field_77990_d == null || !stack.field_77990_d.func_74764_b("chainsaw")) {
            stack.field_77990_d = new NBTTagCompound();
            stack.field_77990_d.func_74757_a("chainsaw", false);
            stack.field_77990_d.func_74757_a("digger", false);
            stack.field_77990_d.func_74757_a("drill", false);
            stack.field_77990_d.func_74757_a("hoe", false);
            stack.field_77990_d.func_74768_a("upgradesAllowed", 1);
            stack.field_77990_d.func_74757_a("goldStick", false);
            stack.field_77990_d.func_74757_a("diamondStick", false);
            stack.field_77990_d.func_74757_a("emeraldStick", false);
            stack.field_77990_d.func_74778_a("lastUsedMode", "nothing");
        }
        this.chainsaw = stack.field_77990_d.func_74767_n("chainsaw");
        this.digger = stack.field_77990_d.func_74767_n("digger");
        this.drill = stack.field_77990_d.func_74767_n("drill");
        this.hoe = stack.field_77990_d.func_74767_n("hoe");
        this.upgradesAllowed = stack.field_77990_d.func_74762_e("upgradesAllowed");
        this.goldStick = stack.field_77990_d.func_74767_n("goldStick");
        this.diamondStick = stack.field_77990_d.func_74767_n("diamondStick");
        this.emeraldStick = stack.field_77990_d.func_74767_n("emeraldStick");
        this.lastMode = stack.field_77990_d.func_74779_i("lastUsedMode");
    }

    public void writeUpgrades(ItemStack stack) {
        stack.field_77990_d.func_74757_a("chainsaw", this.chainsaw);
        stack.field_77990_d.func_74757_a("digger", this.digger);
        stack.field_77990_d.func_74757_a("drill", this.drill);
        stack.field_77990_d.func_74757_a("hoe", this.hoe);
        stack.field_77990_d.func_74768_a("upgradesAllowed", this.upgradesAllowed);
        stack.field_77990_d.func_74757_a("goldStick", this.goldStick);
        stack.field_77990_d.func_74757_a("diamondStick", this.diamondStick);
        stack.field_77990_d.func_74757_a("emeraldStick", this.emeraldStick);
    }

    public void setLastUsedMode(ItemStack stack, String string) {
        stack.field_77990_d.func_74778_a("lastUsedMode", string);
        this.lastMode = string;
    }

    public boolean canInstallUpgrade(ItemStack stack) {
        this.readUpgrades(stack);
        return this.upgradesAllowed > 0;
    }

    public void installUpgrade(String upgrade, ItemStack stack) {
        this.readUpgrades(stack);
        if (!this.isUpgradeInstalled(stack, upgrade)) {
            if (upgrade.equals("Drill")) {
                this.drill = true;
            }
            if (upgrade.equals("Chainsaw")) {
                this.chainsaw = true;
            }
            if (upgrade.equals("Digger")) {
                this.digger = true;
            }
            if (upgrade.equals("Hoe")) {
                this.hoe = true;
            }
            --this.upgradesAllowed;
        }
        this.writeUpgrades(stack);
    }

    public float getDigSpeed(ItemStack stack, Block block, int meta) {
        this.readUpgrades(stack);
        String harvestTool = "nothing";
        if (block.getHarvestTool(0) != null) {
            harvestTool = block.getHarvestTool(0);
        }
        if (this.drill && (harvestTool.equals("pickaxe") || block.func_149688_o() == Material.field_151573_f || block.func_149688_o() == Material.field_151576_e)) {
            stack.func_77973_b().setHarvestLevel("pickaxe", 3);
            this.setLastUsedMode(stack, "pickaxe");
            return 40.0f;
        }
        if (this.chainsaw && (harvestTool.equals("axe") || block.func_149688_o() == Material.field_151584_j || block.func_149688_o() == Material.field_151575_d || block.func_149688_o() == Material.field_151582_l)) {
            stack.func_77973_b().setHarvestLevel("axe", 3);
            this.setLastUsedMode(stack, "axe");
            return 30.0f;
        }
        if (this.digger && (harvestTool.equals("shovel") || block.func_149688_o() == Material.field_151571_B || block.func_149688_o() == Material.field_151577_b || block.func_149688_o() == Material.field_151578_c || block.func_149688_o() == Material.field_151597_y || block.func_149688_o() == Material.field_151595_p || block.func_149688_o() == Material.field_151596_z)) {
            stack.func_77973_b().setHarvestLevel("shovel", 3);
            this.setLastUsedMode(stack, "shovel");
            return 10.0f;
        }
        return 1.0f;
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public boolean canHarvestBlock(Block block, ItemStack stack) {
        String harvestTool = "nothing";
        if (block.getHarvestTool(0) != null) {
            harvestTool = block.getHarvestTool(0);
        }
        if (this.drill && (harvestTool.equals("pickaxe") || block.func_149688_o() == Material.field_151573_f || block.func_149688_o() == Material.field_151576_e)) {
            stack.func_77973_b().setHarvestLevel("pickaxe", 3);
            this.setLastUsedMode(stack, "pickaxe");
            return true;
        }
        if (this.chainsaw && (harvestTool.equals("axe") || block.func_149688_o() == Material.field_151584_j || block.func_149688_o() == Material.field_151575_d || block.func_149688_o() == Material.field_151582_l)) {
            stack.func_77973_b().setHarvestLevel("axe", 3);
            this.setLastUsedMode(stack, "axe");
            return true;
        }
        if (this.digger && (harvestTool.equals("shovel") || block.func_149688_o() == Material.field_151571_B || block.func_149688_o() == Material.field_151577_b || block.func_149688_o() == Material.field_151578_c || block.func_149688_o() == Material.field_151597_y || block.func_149688_o() == Material.field_151595_p || block.func_149688_o() == Material.field_151596_z)) {
            stack.func_77973_b().setHarvestLevel("shovel", 3);
            this.setLastUsedMode(stack, "shovel");
            return true;
        }
        return false;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        this.readBateries(stack, this.player);
        return ((double)this.getCapacity() - this.getEnergy()) / (double)this.getCapacity();
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int geenIdee, float hitX, float hitY, float hitZ) {
        this.readUpgrades(stack);
        if (!this.hoe) {
            return false;
        }
        boolean tilted = false;
        for (int i = x - 1; i <= x + 1; ++i) {
            for (int j = z - 1; j <= z + 1; ++j) {
                if (world.func_147439_a(i, y, j) != Blocks.field_150346_d && world.func_147439_a(i, y, j) != Blocks.field_150349_c || !(this.getEnergy() >= 5.0)) continue;
                world.func_147449_b(i, y, j, Blocks.field_150458_ak);
                this.decreaseEnergy(stack, 5.0, player);
                this.setLastUsedMode(stack, "hoe");
                tilted = true;
            }
        }
        return tilted;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean visible) {
        this.readBateries(stack, player);
        this.readUpgrades(stack);
        list.add(Integer.toString((int)this.getEnergy()) + "/" + Integer.toString(this.getCapacity()) + " MJ");
        if (this.chainsaw) {
            list.add(Utils.localize("item.toolUpgradeChainsaw.name") + " " + Utils.localize("tooltip.installed"));
        }
        if (this.digger) {
            list.add(Utils.localize("item.toolUpgradeDigger.name") + " " + Utils.localize("tooltip.installed"));
        }
        if (this.drill) {
            list.add(Utils.localize("item.toolUpgradeDrill.name") + " " + Utils.localize("tooltip.installed"));
        }
        if (this.hoe) {
            list.add(Utils.localize("item.toolUpgradeHoe.name") + " " + Utils.localize("tooltip.installed"));
        }
        list.add(Utils.localize("tooltip.upgradesPossible") + ": " + this.upgradesAllowed);
    }

    public void setPlayer(EntityPlayer player) {
        this.player = player;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.overlayChainsaw = par1IconRegister.func_94245_a("bcadditions:bit_chainsaw");
        this.overlayDigger = par1IconRegister.func_94245_a("bcadditions:bit_digger");
        this.overlayDrill = par1IconRegister.func_94245_a("bcadditions:bit_drill");
        this.overlayHoe = par1IconRegister.func_94245_a("bcadditions:bit_hoe");
        this.icon = par1IconRegister.func_94245_a("bcadditions:base_tool");
        this.iconAlt = par1IconRegister.func_94245_a("bcadditions:base_tool_alt");
        this.iconChainsaw = par1IconRegister.func_94245_a("bcadditions:Chainsaw");
        this.iconDigger = par1IconRegister.func_94245_a("bcadditions:Digger");
        this.iconDrill = par1IconRegister.func_94245_a("bcadditions:Drill");
        this.iconHoe = par1IconRegister.func_94245_a("bcadditions:Hoe");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int damage) {
        if (this.lastMode.equals("pickaxe")) {
            return this.iconDrill;
        }
        if (this.lastMode.equals("axe")) {
            return this.iconChainsaw;
        }
        if (this.lastMode.equals("shovel")) {
            return this.iconDigger;
        }
        if (this.lastMode.equals("hoe")) {
            return this.iconHoe;
        }
        return this.icon;
    }
}

