/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.items;

import buildcraftAdditions.BuildcraftAdditions;
import cofh.api.energy.IEnergyContainerItem;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;

public class BatteryBase
extends Item
implements IEnergyContainerItem {
    protected int maxEnergy;
    protected int maxExtract;
    protected int maxInput;
    protected int tier;
    private String texture;
    public IIcon icon;

    public BatteryBase(int maxEnergy, int maxExtract, int maxInput, int tier, String texture) {
        this.field_77777_bU = 1;
        this.func_77637_a(BuildcraftAdditions.bcadditions);
        this.maxEnergy = maxEnergy;
        this.maxExtract = maxExtract;
        this.maxInput = maxInput;
        this.tier = tier;
        this.texture = texture;
    }

    public void setEnergy(ItemStack stack, int energy) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        stack.field_77990_d.func_74768_a("energy", energy);
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return true;
    }

    public double getDurabilityForDisplay(ItemStack stack) {
        return ((double)this.maxEnergy - (double)this.getEnergyStored(stack)) / (double)this.maxEnergy;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean visible) {
        list.add(Integer.toString(this.getEnergyStored(stack)) + "/" + Integer.toString(this.maxEnergy) + " RF");
    }

    @Override
    public int receiveEnergy(ItemStack stack, int maxReceive, boolean simulate) {
        int recieved = maxReceive;
        int energy = this.getEnergyStored(stack);
        if (recieved > this.maxEnergy - energy) {
            recieved = this.maxEnergy - energy;
        }
        if (recieved > maxReceive) {
            recieved = maxReceive;
        }
        if (!simulate) {
            energy += recieved;
        }
        this.setEnergy(stack, energy);
        return recieved;
    }

    @Override
    public int extractEnergy(ItemStack stack, int maxExtract, boolean simulate) {
        int extracted = maxExtract;
        int energy = this.getEnergyStored(stack);
        if (extracted > energy) {
            extracted = energy;
        }
        if (extracted > maxExtract) {
            extracted = maxExtract;
        }
        if (!simulate) {
            energy -= extracted;
        }
        this.setEnergy(stack, energy);
        return extracted;
    }

    @Override
    public int getEnergyStored(ItemStack stack) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
            stack.field_77990_d.func_74768_a("energy", 0);
        }
        return stack.field_77990_d.func_74762_e("energy");
    }

    @Override
    public int getMaxEnergyStored(ItemStack stack) {
        return this.maxEnergy;
    }

    public String getType() {
        return "(Tier " + this.tier + "): ";
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister par1IconRegister) {
        this.icon = par1IconRegister.func_94245_a("bcadditions:" + this.texture);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int damage) {
        return this.icon;
    }
}

