/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.config;

import buildcraftAdditions.core.VersionCheck;
import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class ConfigurationHandler {
    public static Configuration configFile;
    public static boolean shouldPrintChangelog;
    public static boolean shouldRegisterDusts;
    public static boolean powerloss;
    public static boolean eurekaIntegration;
    public static int[] powerDifficultyModifiers;
    public static int basePowerModifier;
    public static int KEB1powerloss;
    public static int KEB2powerloss;
    public static int KEB3powerloss;
    public static int heatedFurnaceHeatRequired;
    public static int basicCoilHeat;
    public static int lavaCoilHeat;
    public static int kineticCoilHeatModifier;

    public static void init(File file) {
        configFile = new Configuration(file);
        ConfigurationHandler.readConfig();
    }

    public static void readConfig() {
        configFile.addCustomCategoryComment("Updates", "Section about updates");
        if (configFile.get("Updates", "shouldCheckForUpdates", true).getBoolean()) {
            VersionCheck.start();
        }
        shouldPrintChangelog = configFile.get("Updates", "shouldPrintOutChangelog", false).getBoolean();
        configFile.addCustomCategoryComment("Power Usage", "Modify how much energy the tools use");
        ConfigurationHandler.powerDifficultyModifiers[0] = configFile.get("Power Usage", "PeacefullDifficultyModifier", 1).getInt();
        ConfigurationHandler.powerDifficultyModifiers[1] = configFile.get("Power Usage", "EasyDifficultyModifier", 2).getInt();
        ConfigurationHandler.powerDifficultyModifiers[2] = configFile.get("Power Usage", "NormalDifficultyModifier", 3).getInt();
        ConfigurationHandler.powerDifficultyModifiers[3] = configFile.get("Power Usage", "HardDifficultyModifier", 4).getInt();
        basePowerModifier = configFile.get("Power Usage", "BaseModifier", 10).getInt();
        configFile.addCustomCategoryComment("KEB", "Configuration stuff for your Kinetic Energy Buffers");
        powerloss = configFile.get("KEB", "powerloss", false).getBoolean();
        KEB1powerloss = configFile.get("KEB", "KEB1powerloss", 10).getInt();
        KEB2powerloss = configFile.get("KEB", "KEBT2powerloss", 5).getInt();
        KEB3powerloss = configFile.get("KEB", "KEBT3powerloss", 3).getInt();
        configFile.addCustomCategoryComment("Heated Furnace", "Everything you might want to change about your heated furnace");
        heatedFurnaceHeatRequired = configFile.get("Heated Furnace", "heatedFurnaceHeatRequired", 6500, "How much heat the furnace needs to recieve to process one item").getInt();
        basicCoilHeat = configFile.get("Heated Furnace", "basicCoilHeat", 16, "Amount of heat each basic coil can generate each tick").getInt();
        lavaCoilHeat = configFile.get("Heated Furnace", "lavaCoilHeat", 32, "Amount of heat generated by a lava coil each tick").getInt();
        kineticCoilHeatModifier = configFile.get("Heated Furnace", "kineticCoilHeatModifier", 15, "The amount of heat a kinetic coild generates is the amount of rf it recieved during the last tick mulitplied with this number").getInt();
        configFile.addCustomCategoryComment("Misc", "Stuff that didn't fit in any other category");
        shouldRegisterDusts = configFile.get("Misc", "shouldRegisterDusts", true).setRequiresMcRestart(true).getBoolean();
        eurekaIntegration = configFile.get("Misc", "eurekaIntegration", true).setRequiresMcRestart(true).getBoolean();
        if (configFile.hasChanged()) {
            configFile.save();
        }
    }

    static {
        powerDifficultyModifiers = new int[4];
    }
}

