/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.client.gui;

import buildcraftAdditions.client.gui.widgets.WidgetBase;
import eureka.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.texture.TextureManager;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import org.lwjgl.opengl.GL11;

public abstract class GuiBase
extends GuiContainer {
    public static final int TEXT_COLOR = 0x404040;
    public static final ResourceLocation MC_BLOCK_SHEET = TextureMap.field_110575_b;
    public static final ResourceLocation MC_ITEM_SHEET = TextureMap.field_110576_c;
    public static final ResourceLocation PLAYER_INV_TEXTURE = new ResourceLocation("bcadditions:textures/gui/guiPlayerInv.png");
    public final ResourceLocation texture;
    public boolean drawPlayerInv = true;
    public List<WidgetBase> widgets = new ArrayList<WidgetBase>();
    public int xSizePlayerInv = 175;
    public int ySizePlayerInv = 99;

    public GuiBase(Container container) {
        super(container);
        this.texture = this.texture();
        this.field_146999_f = this.getXSize();
        this.field_147000_g = this.getYSize();
    }

    public GuiBase setDrawPlayerInv(boolean draw) {
        this.drawPlayerInv = draw;
        return this;
    }

    public abstract ResourceLocation texture();

    public abstract int getXSize();

    public abstract int getYSize();

    public abstract String getInventoryName();

    public abstract void initialize();

    public TextureManager textureManager() {
        return Minecraft.func_71410_x().func_110434_K();
    }

    public SoundHandler soundHandler() {
        return Minecraft.func_71410_x().func_147118_V();
    }

    public void bindTexture(ResourceLocation texture) {
        this.textureManager().func_110577_a(texture);
    }

    public void drawString(String text, int x, int y) {
        this.field_146289_q.func_78276_b(text, x, y, 0x404040);
    }

    public void widgetActionPerformed(WidgetBase widget) {
    }

    public void addWidget(WidgetBase widget) {
        this.widgets.add(widget);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        if (this.drawPlayerInv) {
            this.field_147009_r = (this.field_146295_m - (this.field_147000_g + this.ySizePlayerInv)) / 2;
        }
        this.initialize();
    }

    protected void func_146976_a(float f, int x, int y) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.bindTexture(this.texture());
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        if (this.drawPlayerInv) {
            this.bindTexture(PLAYER_INV_TEXTURE);
            this.func_73729_b(this.field_147003_i, this.field_147009_r + this.field_147000_g, 0, 0, this.xSizePlayerInv, this.ySizePlayerInv);
        }
        for (WidgetBase widget : this.widgets) {
            widget.render();
        }
    }

    protected void func_146979_b(int x, int y) {
        this.drawString(StatCollector.func_74838_a((String)"container.inventory"), 5, this.field_147000_g + 6);
        this.drawString(Utils.localize((String)String.format("gui.%s.name", this.getInventoryName())), 5, 6);
    }

    public void func_146280_a(Minecraft minecraft, int width, int height) {
        this.widgets.clear();
        super.func_146280_a(minecraft, width, height);
    }

    protected void func_73864_a(int x, int y, int button) {
        super.func_73864_a(x, y, button);
        for (WidgetBase widget : this.widgets) {
            if (!widget.getBounds().contains(x, y) || !widget.enabled) continue;
            widget.onWidgetClicked(x, y, button);
        }
    }

    public void redraw() {
        this.widgets.clear();
        this.field_146292_n.clear();
        this.initialize();
    }
}

