/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.api;

import buildcraftAdditions.api.IStackInfo;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class DusterRecipes {
    private static final DusterRecipes dusting = new DusterRecipes();
    private final HashMap<IStackInfo, ItemStack> dustingList = new HashMap();

    private DusterRecipes() {
    }

    public static DusterRecipes dusting() {
        return dusting;
    }

    public void addDusterRecipe(String oreInput, ItemStack output) {
        ArrayList inputs = OreDictionary.getOres((String)oreInput);
        if (inputs != null && inputs.size() > 0) {
            for (ItemStack stack : inputs) {
                this.addDusterRecipe(stack, output);
            }
        }
    }

    public void addDusterRecipe(IStackInfo par1, ItemStack output) {
        this.dustingList.put(par1, output);
    }

    public void addDusterRecipe(Block input, ItemStack output) {
        this.addDusterRecipe(Item.func_150898_a((Block)input), output);
    }

    public void addDusterRecipe(Item input, ItemStack output) {
        IStackInfo.ItemData data = new IStackInfo.ItemData(input);
        this.dustingList.put(data, output);
    }

    public void addDusterRecipe(Item input, int inputMeta, ItemStack output) {
        IStackInfo.ItemData data = new IStackInfo.ItemData(input, inputMeta);
        this.dustingList.put(data, output);
    }

    public void addDusterRecipe(ItemStack input, ItemStack output) {
        IStackInfo.ItemData data = new IStackInfo.ItemData(input);
        this.dustingList.put(data, output);
    }

    public ItemStack getDustingResult(ItemStack input) {
        ItemStack result = this.dustingList.get(new IStackInfo.ItemData(input));
        if (result == null) {
            return null;
        }
        return result.func_77946_l();
    }

    public boolean hasDustingResult(ItemStack input) {
        return this.getDustingResult(input) != null;
    }

    public HashMap<IStackInfo, ItemStack> getDustingList() {
        return (HashMap)this.dustingList.clone();
    }
}

