/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions.ModIntegration;

import buildcraftAdditions.ModIntegration.Framez.FramezIntegration;
import buildcraftAdditions.api.DusterRecipes;
import buildcraftAdditions.blocks.BlockBasic;
import buildcraftAdditions.config.ConfigurationHandler;
import buildcraftAdditions.items.ItemDust;
import buildcraftAdditions.reference.ItemsAndBlocks;
import buildcraftAdditions.utils.BCItems;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.registry.GameRegistry;
import eureka.api.EurekaInfo;
import eureka.api.EurekaInformation;
import eureka.api.EurekaRegistry;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.oredict.OreDictionary;

public class ModIntegration {
    public static void integrate() {
        if (ConfigurationHandler.eurekaIntegration) {
            ModIntegration.eurekaResearch();
        }
        ModIntegration.railcraftIntegration();
        ModIntegration.metals();
        if (Loader.isModLoaded((String)"framez")) {
            FramezIntegration.Framez();
        }
    }

    private static void railcraftIntegration() {
        ModIntegration.addNuggets("Iron");
        ModIntegration.addNuggets("Gold");
        ModIntegration.addNuggets("Copper");
        ModIntegration.addNuggets("Tin");
    }

    private static void eurekaResearch() {
        EurekaRegistry.registerCategory((String)"BCA", (ItemStack)new ItemStack((Block)ItemsAndBlocks.kineticDusterBlock));
        EurekaRegistry.register((EurekaInformation)new EurekaInfo("dusterTier0", "BCA", 1, new ItemStack((Block)ItemsAndBlocks.basicDusterBlock)));
        EurekaRegistry.registerDrops((String)"dusterTier0", (ItemStack[])new ItemStack[]{new ItemStack(eureka.utils.BCItems.STONE_GEAR, 2), new ItemStack(Items.field_151042_j), new ItemStack(Blocks.field_150348_b, 5), new ItemStack(Items.field_151123_aH)});
        EurekaRegistry.bindToKey((Block)ItemsAndBlocks.basicDusterBlock, (String)"dusterTier0");
        EurekaRegistry.register((EurekaInformation)new EurekaInfo("dusterTier1", "BCA", 20, new ItemStack((Block)ItemsAndBlocks.semiAutomaticDusterBlock), new String[]{"dusterTier0"}));
        EurekaRegistry.registerDrops((String)"dusterTier1", (ItemStack[])new ItemStack[]{new ItemStack(BCItems.PIPE_ITEMS_GOLD, 2), new ItemStack(Items.field_151043_k), new ItemStack(eureka.utils.BCItems.PIPE_ITEMS_GOLD, 2), new ItemStack(Blocks.field_150348_b, 3)});
        EurekaRegistry.bindToKey((Block)ItemsAndBlocks.semiAutomaticDusterBlock, (String)"dusterTier1");
        EurekaRegistry.register((EurekaInformation)new EurekaInfo("dusterTier2-1", "BCA", 40, new ItemStack((Block)ItemsAndBlocks.mechanicalDusterBlock), new String[]{"dusterTier1"}));
        EurekaRegistry.registerDrops((String)"dusterTier2-1", (ItemStack[])new ItemStack[]{new ItemStack(BCItems.IRON_GEAR, 2), new ItemStack(Items.field_151043_k, 1), new ItemStack(ItemsAndBlocks.itemGrindingWheel, 1), new ItemStack(Blocks.field_150348_b, 5)});
        EurekaRegistry.bindToKey((Block)ItemsAndBlocks.mechanicalDusterBlock, (String)"dusterTier2-1");
        EurekaRegistry.register((EurekaInformation)new EurekaInfo("dusterTier2-2", "BCA", 20, new ItemStack((Block)ItemsAndBlocks.kineticDusterBlock), new String[]{"dusterTier2-1"}));
        EurekaRegistry.registerDrops((String)"dusterTier2-2", (ItemStack[])new ItemStack[]{new ItemStack(Blocks.field_150359_w, 3), new ItemStack(BCItems.PIPE_ITEMS_GOLD, 2), new ItemStack(BCItems.GOLD_GEAR, 2), new ItemStack(BCItems.DIAMOND_GEAR)});
        EurekaRegistry.bindToKey((Block)ItemsAndBlocks.kineticDusterBlock, (String)"dusterTier2-2");
        EurekaRegistry.register((EurekaInformation)new EurekaInfo("kineticTool", "BCA", 25, new ItemStack((Item)ItemsAndBlocks.kineticTool)));
        EurekaRegistry.registerDrops((String)"kineticTool", (ItemStack[])new ItemStack[]{new ItemStack(Items.field_151045_i, 3), new ItemStack(ItemsAndBlocks.ironStick), new ItemStack(ItemsAndBlocks.toolCore)});
        EurekaRegistry.bindToKey((Item)ItemsAndBlocks.kineticTool, (String)"kineticTool");
        EurekaRegistry.register((EurekaInformation)new EurekaInfo("heatedFurnace", "BCA", 5, new ItemStack((Block)ItemsAndBlocks.heatedFurnaceBlock)));
        EurekaRegistry.registerDrops((String)"heatedFurnace", (ItemStack[])new ItemStack[]{new ItemStack(Blocks.field_150460_al), new ItemStack(Items.field_151042_j, 8)});
        EurekaRegistry.addPlaceBlockProgress((Block)Blocks.field_150460_al, (String)"heatedFurnace");
        EurekaRegistry.bindToKey((Block)ItemsAndBlocks.heatedFurnaceBlock, (String)"heatedFurnace");
        EurekaRegistry.register((EurekaInformation)new EurekaInfo("basicCoil", "BCA", 1, new ItemStack((Block)ItemsAndBlocks.basicCoilBlock), new String[]{"heatedFurnace"}));
        EurekaRegistry.registerDrops((String)"basicCoil", (ItemStack[])new ItemStack[]{new ItemStack(Items.field_151042_j), new ItemStack(ItemsAndBlocks.itemIronWire, 8)});
        EurekaRegistry.addPlaceBlockProgress((Block)ItemsAndBlocks.heatedFurnaceBlock, (String)"basicCoil");
        EurekaRegistry.bindToKey((Block)ItemsAndBlocks.basicCoilBlock, (String)"basicCoil");
        EurekaRegistry.register((EurekaInformation)new EurekaInfo("lavaCoil", "BCA", 5, new ItemStack((Block)ItemsAndBlocks.lavaCoilBlock), new String[]{"basicCoil"}));
        EurekaRegistry.registerDrops((String)"lavaCoil", (ItemStack[])new ItemStack[]{new ItemStack(Items.field_151042_j), new ItemStack(ItemsAndBlocks.goldWire, 8)});
        EurekaRegistry.addPlaceBlockProgress((Block)ItemsAndBlocks.basicCoilBlock, (String)"lavaCoil");
        EurekaRegistry.bindToKey((Block)ItemsAndBlocks.lavaCoilBlock, (String)"lavaCoil");
        EurekaRegistry.register((EurekaInformation)new EurekaInfo("kineticCoil", "BCA", 4, new ItemStack((Block)ItemsAndBlocks.kineticCoil), new String[]{"lavaCoil"}));
        EurekaRegistry.registerDrops((String)"kineticCoil", (ItemStack[])new ItemStack[]{new ItemStack(Items.field_151042_j), new ItemStack(ItemsAndBlocks.diamondWire, 8)});
        EurekaRegistry.addPlaceBlockProgress((Block)ItemsAndBlocks.lavaCoilBlock, (String)"kineticCoil");
        EurekaRegistry.bindToKey((Block)ItemsAndBlocks.kineticCoil, (String)"kineticCoil");
        EurekaRegistry.register((EurekaInformation)new EurekaInfo("KEBT1", "BCA", 3, new ItemStack((Block)ItemsAndBlocks.kebT1, 1, 8)));
        EurekaRegistry.registerDrops((String)"KEBT1", (ItemStack[])new ItemStack[]{new ItemStack(Items.field_151042_j, 4), new ItemStack(ItemsAndBlocks.powerCapsuleTier1, 3), new ItemStack(BCItems.PIPE_POWER_GOLD, 2)});
        EurekaRegistry.addCrafingProgress((Item)ItemsAndBlocks.powerCapsuleTier1, (String)"KEBT1");
        EurekaRegistry.bindToKey((Block)ItemsAndBlocks.kebT1, (String)"KEBT1");
        BlockBasic temp = new BlockBasic("energyBufferMultiblockSides5");
        GameRegistry.registerBlock((Block)temp, (String)"test");
        EurekaRegistry.register((EurekaInformation)new EurekaInfo("KEBT2", "BCA", 4, new ItemStack((Block)temp), new String[]{"KEBT1"}));
        EurekaRegistry.registerDrops((String)"KEBT2", (ItemStack[])new ItemStack[]{new ItemStack(Items.field_151042_j, 6), new ItemStack(BCItems.PIPE_POWER_GOLD, 2), new ItemStack(ItemsAndBlocks.powerCapsuleTier2)});
        EurekaRegistry.addPlaceBlockProgress((Block)ItemsAndBlocks.kebT1, (String)"KEBT2");
        EurekaRegistry.bindToKey((Block)ItemsAndBlocks.kebT2, (String)"KEBT2");
    }

    private static void metals() {
        ModIntegration.addDusts("Bronze", 11364134);
        ModIntegration.addDusts("Manganese", 15979218);
        ModIntegration.addDusts("Hepatizon", 0x6B566B);
        ModIntegration.addDusts("DamascusSteel", 4008991);
        ModIntegration.addDusts("Angmallen", 16448108);
        ModIntegration.addDusts("Steel", 0x919191);
        ModIntegration.addDusts("Eximite", 10388404);
        ModIntegration.addDusts("Meutoite", 6247017);
        ModIntegration.addDusts("Desichalkos", 7614120);
        ModIntegration.addDusts("Prometheum", 5931350);
        ModIntegration.addDusts("DeepIron", 4807529);
        ModIntegration.addDusts("Infuscolium", 13329043);
        ModIntegration.addDusts("BlackSteel", 3757689);
        ModIntegration.addDusts("Oureclase", 14460974);
        ModIntegration.addDusts("AstralSilver", 13161685);
        ModIntegration.addDusts("Carmot", 11114291);
        ModIntegration.addDusts("Mithril", 570819);
        ModIntegration.addDusts("Rubracium", 9316135);
        ModIntegration.addDusts("Quicksilver", 8180679);
        ModIntegration.addDusts("Haderoth", 13718302);
        ModIntegration.addDusts("Orichalcum", 5536312);
        ModIntegration.addDusts("Celenegil", 9751624);
        ModIntegration.addDusts("Adamantine", 0xF04040);
        ModIntegration.addDusts("Atlarus", 16045571);
        ModIntegration.addDusts("Tartarite", 16741948);
        ModIntegration.addDusts("Ignatius", 15234048);
        ModIntegration.addDusts("ShadowIron", 9270629);
        ModIntegration.addDusts("Lemurite", 0xEFEFEF);
        ModIntegration.addDusts("Midasium", 16754726);
        ModIntegration.addDusts("Vyroxeres", 5627905);
        ModIntegration.addDusts("Ceruclase", 4558763);
        ModIntegration.addDusts("Alduorite", 10739422);
        ModIntegration.addDusts("Kalendrite", 11164605);
        ModIntegration.addDusts("Vulcanite", 0xFF8448);
        ModIntegration.addDusts("Sanguinite", 0xB90000);
        ModIntegration.addDusts("ShadowSteel", 8942434);
        ModIntegration.addDusts("Inolashite", 4237949);
        ModIntegration.addDusts("Amordrine", 11111857);
        ModIntegration.addDusts("Zinc", 14475172);
        ModIntegration.addDusts("Brass", 14194228);
        ModIntegration.addDusts("Electrum", 14667946);
        ModIntegration.addDusts("Aluminum", 0xEDEDED);
        ModIntegration.addDusts("Ardite", 15894784);
        ModIntegration.addDusts("Manyullyn", 11239139);
        ModIntegration.addDusts("Cobalt", 25855);
        ModIntegration.addDusts("Copper", 12541471);
        ModIntegration.addDusts("Lead", 8421526);
        ModIntegration.addDusts("Nickel", 12234916);
        ModIntegration.addDusts("Platinum", 11259375);
        ModIntegration.addDusts("Silver", 0xB3B3B3);
        ModIntegration.addDusts("Tin", 0xF2F2F2);
    }

    private static void addNuggets(String metal) {
        ArrayList oreList = OreDictionary.getOres((String)("orePoor" + metal));
        ArrayList nuggetList = OreDictionary.getOres((String)("nugget" + metal));
        if (oreList.isEmpty() || nuggetList.isEmpty()) {
            return;
        }
        for (ItemStack poorOre : oreList) {
            DusterRecipes.dusting().addDusterRecipe(poorOre, new ItemStack(((ItemStack)nuggetList.get(0)).func_77973_b(), 4, ((ItemStack)nuggetList.get(0)).func_77960_j()));
        }
    }

    private static void addDusts(String metalName, int color) {
        Item itemDust;
        ArrayList list = OreDictionary.getOres((String)("ingot" + metalName));
        if (list.isEmpty()) {
            return;
        }
        if (ConfigurationHandler.shouldRegisterDusts) {
            itemDust = new ItemDust(color).func_77655_b("dust" + metalName);
            list = OreDictionary.getOres((String)("dust" + metalName));
            if (!list.isEmpty()) {
                String name = ((ItemStack)list.get(0)).func_77977_a();
                name = name.replace("item.", "");
                itemDust.func_77655_b(name);
            }
            GameRegistry.registerItem((Item)itemDust, (String)("dust" + metalName));
            OreDictionary.registerOre((String)("dust" + metalName), (Item)itemDust);
            GameRegistry.addSmelting((Item)itemDust, (ItemStack)((ItemStack)OreDictionary.getOres((String)("ingot" + metalName)).get(0)).func_77946_l(), (float)0.0f);
        } else {
            ArrayList tempList = OreDictionary.getOres((String)("dust" + metalName));
            if (tempList.isEmpty()) {
                return;
            }
            ItemStack stack = (ItemStack)tempList.get(0);
            if (stack == null) {
                return;
            }
            itemDust = stack.func_77973_b();
        }
        list = OreDictionary.getOres((String)("ore" + metalName));
        for (ItemStack stack : list) {
            DusterRecipes.dusting().addDusterRecipe(stack.func_77946_l(), new ItemStack(itemDust, 2));
        }
        list = OreDictionary.getOres((String)("ingot" + metalName));
        for (ItemStack stack : list) {
            DusterRecipes.dusting().addDusterRecipe(stack.func_77946_l(), new ItemStack(itemDust, 1));
        }
    }
}

