/*
 * Decompiled with CFR 0.152.
 */
package buildcraftAdditions;

import buildcraftAdditions.ModIntegration.ModIntegration;
import buildcraftAdditions.api.DusterRecipes;
import buildcraftAdditions.client.gui.GuiHandler;
import buildcraftAdditions.config.ConfigurationHandler;
import buildcraftAdditions.core.EventListener;
import buildcraftAdditions.core.Logger;
import buildcraftAdditions.items.ItemDust;
import buildcraftAdditions.networking.PacketHandeler;
import buildcraftAdditions.proxy.CommonProxy;
import buildcraftAdditions.reference.ItemsAndBlocks;
import buildcraftAdditions.reference.TrigersAndActions;
import buildcraftAdditions.utils.SpecialListMananger;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLLoadCompleteEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.oredict.OreDictionary;

@Mod(modid="bcadditions", name="Buildcraft Additions", version="1.8.4", guiFactory="buildcraftAdditions.config.GuiFactory", dependencies="after:BuildCraft|Energy;required-after:eureka;required-after:Forge@[10.13.2.1230,)", acceptedMinecraftVersions="1.7.10")
public class BuildcraftAdditions {
    @Mod.Instance(value="bcadditions")
    public static BuildcraftAdditions instance;
    @SidedProxy(clientSide="buildcraftAdditions.proxy.ClientProxy", serverSide="buildcraftAdditions.proxy.CommonProxy")
    public static CommonProxy proxy;
    public static CreativeTabs bcadditions;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        Logger.initiallize();
        ConfigurationHandler.init(event.getSuggestedConfigurationFile());
        PacketHandeler.init();
        ItemsAndBlocks.init();
        TrigersAndActions.register();
        SpecialListMananger.init();
        DusterRecipes.dusting().addDusterRecipe(new ItemStack(Blocks.field_150450_ax), new ItemStack(Items.field_151137_ax, 6));
        DusterRecipes.dusting().addDusterRecipe(new ItemStack(Blocks.field_150365_q), new ItemStack(Items.field_151044_h, 2));
        DusterRecipes.dusting().addDusterRecipe(new ItemStack(Blocks.field_150369_x), new ItemStack(Items.field_151100_aR, 6, 4));
        DusterRecipes.dusting().addDusterRecipe(new ItemStack(Blocks.field_150449_bY), new ItemStack(Items.field_151128_bU, 2));
        DusterRecipes.dusting().addDusterRecipe(new ItemStack(Blocks.field_150348_b), new ItemStack(Blocks.field_150351_n));
        DusterRecipes.dusting().addDusterRecipe(new ItemStack(Blocks.field_150347_e), new ItemStack((Block)Blocks.field_150354_m));
    }

    @Mod.EventHandler
    public void doneLoading(FMLLoadCompleteEvent event) {
        ItemsAndBlocks.addRecepies();
        Item itemDust = new ItemDust(Integer.parseInt("13ECFC", 16)).func_77655_b("dustDiamond");
        GameRegistry.registerItem((Item)itemDust, (String)"dustDiamond");
        OreDictionary.registerOre((String)"dustDiamond", (Item)itemDust);
        DusterRecipes.dusting().addDusterRecipe(new ItemStack(Blocks.field_150482_ag), new ItemStack(itemDust, 2));
        DusterRecipes.dusting().addDusterRecipe(new ItemStack(Items.field_151045_i), new ItemStack(itemDust, 1));
        DusterRecipes.dusting().addDusterRecipe(Items.field_151072_bj, new ItemStack(Items.field_151065_br, 4));
        this.addDusts("Iron", 13815497);
        this.addDusts("Gold", 16310039);
        ModIntegration.integrate();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent evt) {
        FMLCommonHandler.instance().bus().register((Object)new EventListener.FML());
        MinecraftForge.EVENT_BUS.register((Object)new EventListener.Forge());
    }

    @Mod.EventHandler
    public void load(FMLInitializationEvent event) {
        proxy.registerRenderers();
        NetworkRegistry.INSTANCE.registerGuiHandler((Object)instance, (IGuiHandler)new GuiHandler());
    }

    public void addDusts(String metalName, int color) {
        Item itemDust;
        ArrayList list = OreDictionary.getOres((String)("ingot" + metalName));
        if (list.isEmpty()) {
            return;
        }
        list = OreDictionary.getOres((String)("ore" + metalName));
        if (list.isEmpty()) {
            return;
        }
        if (ConfigurationHandler.shouldRegisterDusts) {
            itemDust = new ItemDust(color).func_77655_b("dust" + metalName);
            GameRegistry.registerItem((Item)itemDust, (String)("dust" + metalName));
            OreDictionary.registerOre((String)("dust" + metalName), (Item)itemDust);
            GameRegistry.addSmelting((Item)itemDust, (ItemStack)((ItemStack)OreDictionary.getOres((String)("ingot" + metalName)).get(0)).func_77946_l(), (float)0.0f);
        } else {
            ArrayList tempList = OreDictionary.getOres((String)("dust" + metalName));
            if (tempList.isEmpty()) {
                return;
            }
            ItemStack stack = (ItemStack)tempList.get(0);
            if (stack == null) {
                return;
            }
            itemDust = stack.func_77973_b();
        }
        for (ItemStack stack : list) {
            DusterRecipes.dusting().addDusterRecipe(stack.func_77946_l(), new ItemStack(itemDust, 2));
        }
        list = OreDictionary.getOres((String)("ingot" + metalName));
        for (ItemStack stack : list) {
            DusterRecipes.dusting().addDusterRecipe(stack.func_77946_l(), new ItemStack(itemDust, 1));
        }
    }

    static {
        bcadditions = new CreativeTabs("BuildcraftAdditions"){

            public Item func_78016_d() {
                return new ItemStack((Block)ItemsAndBlocks.fluidicCompressorBlock, 1).func_77973_b();
            }
        };
    }
}

