/*
 * Decompiled with CFR 0.152.
 */
package com.rwtema.extrautils.tileentity.transfernodes.pipes;

import com.rwtema.extrautils.tileentity.transfernodes.BlockTransferPipe;
import com.rwtema.extrautils.tileentity.transfernodes.TNHelper;
import com.rwtema.extrautils.tileentity.transfernodes.nodebuffer.INodeBuffer;
import com.rwtema.extrautils.tileentity.transfernodes.pipes.IPipe;
import com.rwtema.extrautils.tileentity.transfernodes.pipes.PipeBase;
import java.util.ArrayList;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.util.ForgeDirection;

public class PipeCrossOver
extends PipeBase {
    public PipeCrossOver() {
        super("Crossover");
    }

    @Override
    public IIcon baseTexture() {
        return BlockTransferPipe.pipes_xover;
    }

    @Override
    public float baseSize() {
        return 0.1875f;
    }

    @Override
    public ArrayList<ForgeDirection> getOutputDirections(IBlockAccess world, int x, int y, int z, ForgeDirection dir, INodeBuffer buffer) {
        ArrayList<ForgeDirection> dirs = new ArrayList<ForgeDirection>();
        if (TNHelper.canOutput(world, x, y, z, dir) && TNHelper.canInput(world, x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ, dir.getOpposite())) {
            dirs.add(dir);
        }
        return dirs;
    }

    @Override
    public boolean transferItems(IBlockAccess world, int x, int y, int z, ForgeDirection dir, INodeBuffer buffer) {
        boolean advance = true;
        IPipe pipe = TNHelper.getPipe(world, x, y, z);
        if (pipe == null) {
            return true;
        }
        if (pipe.shouldConnectToTile(world, x, y, z, dir) && !buffer.transfer(world.func_147438_o(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ), dir.getOpposite(), pipe, x, y, z, dir)) {
            advance = false;
        }
        return advance;
    }

    @Override
    public boolean canOutput(IBlockAccess world, int x, int y, int z, ForgeDirection dir) {
        if (dir == ForgeDirection.UNKNOWN) {
            return false;
        }
        IPipe pipe = TNHelper.getPipe(world, x + dir.getOpposite().offsetX, y + dir.getOpposite().offsetY, z + dir.getOpposite().offsetZ);
        if (pipe == null) {
            return false;
        }
        if (pipe.getPipeType().equals(this.getPipeType())) {
            return true;
        }
        return pipe.canOutput(world, x + dir.getOpposite().offsetX, y + dir.getOpposite().offsetY, z + dir.getOpposite().offsetZ, dir);
    }

    @Override
    public boolean canInput(IBlockAccess world, int x, int y, int z, ForgeDirection dir) {
        if (dir == ForgeDirection.UNKNOWN) {
            return false;
        }
        IPipe pipe = TNHelper.getPipe(world, x + dir.getOpposite().offsetX, y + dir.getOpposite().offsetY, z + dir.getOpposite().offsetZ);
        if (pipe == null) {
            return super.shouldConnectToTile(world, x, y, z, dir.getOpposite());
        }
        return pipe.canInput(world, x + dir.getOpposite().offsetX, y + dir.getOpposite().offsetY, z + dir.getOpposite().offsetZ, dir);
    }

    @Override
    public boolean shouldConnectToTile(IBlockAccess world, int x, int y, int z, ForgeDirection dir) {
        return TNHelper.canOutput(world, x + dir.getOpposite().offsetX, y + dir.getOpposite().offsetY, z + dir.getOpposite().offsetZ, dir) && TNHelper.isValidTileEntity(world, x, y, z, dir);
    }
}

