/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.type.natives;

import org.objectweb.asm.Label;
import stanhebben.zenscript.compiler.IEnvironmentGlobal;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.type.natives.IJavaMethod;
import stanhebben.zenscript.util.MethodOutput;

public class ZenNativeCaster {
    private final IJavaMethod method;

    public ZenNativeCaster(IJavaMethod method) {
        this.method = method;
    }

    public ZenType getReturnType() {
        return this.method.getReturnType();
    }

    public void compile(MethodOutput output) {
        if (this.method.isStatic()) {
            this.method.invokeStatic(output);
        } else {
            this.method.invokeVirtual(output);
        }
    }

    public void compileAnyCanCastImplicit(ZenType type, MethodOutput output, IEnvironmentGlobal environment, int localClass) {
        String casterAny = this.method.getReturnType().getAnyClassName(environment);
        if (casterAny == null) {
            return;
        }
        Label skip = new Label();
        output.loadObject(localClass);
        output.invokeStatic(casterAny, "rtCanCastImplicit", "(Ljava/lang/Class;)Z");
        output.ifEQ(skip);
        output.iConst1();
        output.returnInt();
        output.label(skip);
    }

    public void compileAnyCast(ZenType type, MethodOutput output, IEnvironmentGlobal environment, int localValue, int localClass) {
        Label skip = new Label();
        output.loadObject(localClass);
        output.constant(this.method.getReturnType().toASMType());
        output.ifACmpNe(skip);
        output.load(type.toASMType(), localValue);
        this.compile(output);
        output.returnType(this.method.getReturnType().toASMType());
        output.label(skip);
        String casterAny = this.method.getReturnType().getAnyClassName(environment);
        if (casterAny == null) {
            return;
        }
        Label skip2 = new Label();
        output.loadObject(localClass);
        output.invokeStatic(casterAny, "rtCanCastImplicit", "(Ljava/lang/Class;)Z");
        output.ifEQ(skip2);
        output.load(type.toASMType(), localValue);
        this.compile(output);
        output.returnType(this.method.getReturnType().toASMType());
        output.label(skip2);
    }
}

