/*
 * Decompiled with CFR 0.152.
 */
package stanhebben.zenscript.expression;

import stanhebben.zenscript.annotations.OperatorType;
import stanhebben.zenscript.compiler.IEnvironmentMethod;
import stanhebben.zenscript.expression.Expression;
import stanhebben.zenscript.type.ZenType;
import stanhebben.zenscript.type.ZenTypeByte;
import stanhebben.zenscript.type.ZenTypeDouble;
import stanhebben.zenscript.type.ZenTypeFloat;
import stanhebben.zenscript.type.ZenTypeInt;
import stanhebben.zenscript.type.ZenTypeLong;
import stanhebben.zenscript.type.ZenTypeShort;
import stanhebben.zenscript.util.MethodOutput;
import stanhebben.zenscript.util.ZenPosition;

public class ExpressionArithmeticBinary
extends Expression {
    private final OperatorType operator;
    private final Expression a;
    private final Expression b;

    public ExpressionArithmeticBinary(ZenPosition position, OperatorType operator, Expression a, Expression b) {
        super(position);
        this.operator = operator;
        this.a = a;
        this.b = b;
    }

    @Override
    public ZenType getType() {
        return this.a.getType();
    }

    @Override
    public void compile(boolean result, IEnvironmentMethod environment) {
        block41: {
            block39: {
                ZenType type;
                block45: {
                    MethodOutput output;
                    block44: {
                        block43: {
                            block42: {
                                block40: {
                                    if (!result) break block39;
                                    this.a.compile(result, environment);
                                    this.b.compile(result, environment);
                                    type = this.a.getType();
                                    output = environment.getOutput();
                                    if (type != ZenType.BOOL) break block40;
                                    switch (this.operator) {
                                        case AND: {
                                            output.iAnd();
                                            break block41;
                                        }
                                        case OR: {
                                            output.iOr();
                                            break block41;
                                        }
                                        case XOR: {
                                            output.iXor();
                                            break block41;
                                        }
                                        default: {
                                            throw new RuntimeException("Unsupported operator on " + type + ": " + (Object)((Object)this.operator));
                                        }
                                    }
                                }
                                if (type != ZenTypeByte.INSTANCE && type != ZenTypeShort.INSTANCE && type != ZenTypeInt.INSTANCE) break block42;
                                switch (this.operator) {
                                    case ADD: {
                                        output.iAdd();
                                        break block41;
                                    }
                                    case SUB: {
                                        output.iSub();
                                        break block41;
                                    }
                                    case MUL: {
                                        output.iMul();
                                        break block41;
                                    }
                                    case DIV: {
                                        output.iDiv();
                                        break block41;
                                    }
                                    case MOD: {
                                        output.iRem();
                                        break block41;
                                    }
                                    case AND: {
                                        output.iAnd();
                                        break block41;
                                    }
                                    case OR: {
                                        output.iOr();
                                        break block41;
                                    }
                                    case XOR: {
                                        output.iXor();
                                        break block41;
                                    }
                                    default: {
                                        throw new RuntimeException("Unsupported operator on " + type + ": " + (Object)((Object)this.operator));
                                    }
                                }
                            }
                            if (type != ZenTypeLong.INSTANCE) break block43;
                            switch (this.operator) {
                                case ADD: {
                                    output.lAdd();
                                    break block41;
                                }
                                case SUB: {
                                    output.lSub();
                                    break block41;
                                }
                                case MUL: {
                                    output.lMul();
                                    break block41;
                                }
                                case DIV: {
                                    output.lDiv();
                                    break block41;
                                }
                                case MOD: {
                                    output.lRem();
                                    break block41;
                                }
                                case AND: {
                                    output.lAnd();
                                    break block41;
                                }
                                case OR: {
                                    output.lOr();
                                    break block41;
                                }
                                case XOR: {
                                    output.lXor();
                                    break block41;
                                }
                                default: {
                                    throw new RuntimeException("Unsupported operator on " + type + ": " + (Object)((Object)this.operator));
                                }
                            }
                        }
                        if (type != ZenTypeFloat.INSTANCE) break block44;
                        switch (this.operator) {
                            case ADD: {
                                output.fAdd();
                                break block41;
                            }
                            case SUB: {
                                output.fSub();
                                break block41;
                            }
                            case MUL: {
                                output.fMul();
                                break block41;
                            }
                            case DIV: {
                                output.fDiv();
                                break block41;
                            }
                            case MOD: {
                                output.fRem();
                                break block41;
                            }
                            default: {
                                throw new RuntimeException("Unsupported operator on " + type + ": " + (Object)((Object)this.operator));
                            }
                        }
                    }
                    if (type != ZenTypeDouble.INSTANCE) break block45;
                    switch (this.operator) {
                        case ADD: {
                            output.dAdd();
                            break block41;
                        }
                        case SUB: {
                            output.dSub();
                            break block41;
                        }
                        case MUL: {
                            output.dMul();
                            break block41;
                        }
                        case DIV: {
                            output.dDiv();
                            break block41;
                        }
                        case MOD: {
                            output.dRem();
                            break block41;
                        }
                        default: {
                            throw new RuntimeException("Unsupported operator on " + type + ": " + (Object)((Object)this.operator));
                        }
                    }
                }
                throw new RuntimeException("Internal compilation error: " + type + " is not a supported arithmetic type");
            }
            this.a.compile(result, environment);
            this.b.compile(result, environment);
        }
    }
}

