/*
 * Decompiled with CFR 0.152.
 */
package ExAstris.Block.TileEntity;

import ExAstris.Data.ModData;
import ExAstris.ExAstrisItem;
import ExAstris.ItemInfo;
import cofh.api.energy.EnergyStorage;
import cofh.api.energy.IEnergyHandler;
import cofh.lib.util.helpers.ItemHelper;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import exnihilo.particles.ParticleSieve;
import exnihilo.registries.SieveRegistry;
import exnihilo.registries.helpers.SiftReward;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S35PacketUpdateTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntitySieveAutomatic
extends TileEntity
implements IEnergyHandler,
ISidedInventory {
    public EnergyStorage storage = new EnergyStorage(64000);
    private int energyPerCycle = ModData.sieveAutomaticBaseEnergy;
    private static final float MIN_RENDER_CAPACITY = 0.7f;
    private static final float MAX_RENDER_CAPACITY = 0.9f;
    private float PROCESSING_INTERVAL = 0.005f;
    private static final int UPDATE_INTERVAL = 20;
    private int speedLevel = 0;
    private static Random rand = new Random();
    protected ItemStack[] inventory;
    public Block content;
    public int contentMeta = 0;
    private float volume = 0.0f;
    public SieveMode mode = SieveMode.EMPTY;
    private int timer = 0;
    private boolean update = false;
    private boolean particleMode = false;
    private HashMap<ItemInfo, Boolean> registryCache = new HashMap();

    public TileEntitySieveAutomatic() {
        this.mode = SieveMode.EMPTY;
        this.inventory = new ItemStack[this.func_70302_i_()];
    }

    public void changeSpeedLevel(float change) {
        this.speedLevel = (int)((float)this.speedLevel + change);
        this.PROCESSING_INTERVAL += change;
        if (this.speedLevel < 0) {
            this.speedLevel = 0;
        }
    }

    public void addSievable(Block block, int blockMeta) {
        this.content = block;
        this.contentMeta = blockMeta;
        this.mode = SieveMode.FILLED;
        this.volume = 1.0f;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K && this.particleMode) {
            this.spawnFX(this.content, this.contentMeta);
        }
        ++this.timer;
        if (this.timer >= 20) {
            this.timer = 0;
            this.disableParticles();
            if (this.update) {
                this.update();
            }
        }
        if (this.storage.getEnergyStored() > this.getEffectiveEnergy()) {
            if (this.mode == SieveMode.EMPTY && this.inventory[0] != null) {
                ItemStack held = this.inventory[0];
                if (SieveRegistry.Contains((Block)Block.func_149634_a((Item)held.func_77973_b()), (int)held.func_77960_j())) {
                    this.addSievable(Block.func_149634_a((Item)held.func_77973_b()), held.func_77960_j());
                    this.func_70298_a(0, 1);
                    this.storage.extractEnergy(this.getEffectiveEnergy(), false);
                }
            } else if (this.mode != SieveMode.EMPTY) {
                this.ProcessContents();
            }
        }
    }

    public void ProcessContents() {
        this.volume -= this.getEffectiveSpeed();
        this.storage.extractEnergy(this.getEffectiveEnergy(), false);
        if (this.volume <= 0.0f) {
            ArrayList rewards;
            this.mode = SieveMode.EMPTY;
            if (!this.field_145850_b.field_72995_K && (rewards = SieveRegistry.getRewards((Block)this.content, (int)this.contentMeta)).size() > 0) {
                for (SiftReward reward : rewards) {
                    int fortuneAmount = ModData.sieveFortuneExtraRolls ? this.getFortuneModifier() : 1;
                    for (int fortuneCounter = 0; fortuneCounter < fortuneAmount; ++fortuneCounter) {
                        int size = this.func_70302_i_() - 2;
                        int inventoryIndex = 0;
                        if (this.field_145850_b.field_73012_v.nextInt(reward.rarity) != 0) continue;
                        int fortuneAmount2 = ModData.sieveFortuneExtraDrops ? this.getFortuneModifier() : 1;
                        for (int fortuneCounter2 = 0; fortuneCounter2 < fortuneAmount2; ++fortuneCounter2) {
                            for (int i = 1; i < size; ++i) {
                                if (this.inventory[i] == null) {
                                    inventoryIndex = i;
                                    break;
                                }
                                if (!ItemHelper.itemsEqualWithMetadata((ItemStack)this.inventory[i], (ItemStack)new ItemStack(reward.item, 1, reward.meta)) || this.inventory[i].field_77994_a >= this.inventory[i].func_77976_d()) continue;
                                inventoryIndex = i;
                                break;
                            }
                            if (inventoryIndex != 0) {
                                if (this.inventory[inventoryIndex] != null) {
                                    this.inventory[inventoryIndex] = new ItemStack(reward.item, this.inventory[inventoryIndex].field_77994_a + 1, reward.meta);
                                    continue;
                                }
                                this.inventory[inventoryIndex] = new ItemStack(reward.item, 1, reward.meta);
                                continue;
                            }
                            EntityItem entityitem = new EntityItem(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 1.5, (double)this.field_145849_e + 0.5, new ItemStack(reward.item, 1, reward.meta));
                            double f3 = 0.05f;
                            entityitem.field_70159_w = this.field_145850_b.field_73012_v.nextGaussian() * f3;
                            entityitem.field_70181_x = 0.2;
                            entityitem.field_70179_y = this.field_145850_b.field_73012_v.nextGaussian() * f3;
                            this.field_145850_b.func_72838_d((Entity)entityitem);
                        }
                    }
                }
            }
        } else {
            this.particleMode = true;
        }
        this.update = true;
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnFX(Block block, int blockMeta) {
        if (block != null) {
            IIcon icon = block.func_149691_a(0, blockMeta);
            for (int x = 0; x < 4; ++x) {
                ParticleSieve dust = new ParticleSieve(this.field_145850_b, (double)this.field_145851_c + 0.8 * (double)this.field_145850_b.field_73012_v.nextFloat() + 0.15, (double)this.field_145848_d + 0.69, (double)this.field_145849_e + 0.8 * (double)this.field_145850_b.field_73012_v.nextFloat() + 0.15, 0.0, 0.0, 0.0, icon);
                Minecraft.func_71410_x().field_71452_i.func_78873_a((EntityFX)dust);
            }
        }
    }

    public float getVolume() {
        return this.volume;
    }

    public float getAdjustedVolume() {
        float capacity = 0.19999999f;
        float adjusted = this.volume * capacity;
        return adjusted += 0.7f;
    }

    private void update() {
        this.update = false;
        this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    private void disableParticles() {
        this.particleMode = false;
    }

    public void func_145839_a(NBTTagCompound compound) {
        super.func_145839_a(compound);
        switch (compound.func_74762_e("mode")) {
            case 0: {
                this.mode = SieveMode.EMPTY;
                break;
            }
            case 1: {
                this.mode = SieveMode.FILLED;
            }
        }
        this.content = !compound.func_74779_i("content").equals("") ? (Block)Block.field_149771_c.func_82594_a(compound.func_74779_i("content")) : null;
        this.contentMeta = compound.func_74762_e("contentMeta");
        this.volume = compound.func_74760_g("volume");
        this.particleMode = compound.func_74767_n("particles");
        this.PROCESSING_INTERVAL = compound.func_74760_g("speed");
        this.storage.readFromNBT(compound);
        NBTTagList nbttaglist = compound.func_150295_c("Items", 10);
        this.inventory = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound1 = nbttaglist.func_150305_b(i);
            byte b0 = nbttagcompound1.func_74771_c("Slot");
            if (b0 < 0 || b0 >= this.inventory.length) continue;
            this.inventory[b0] = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound1);
        }
    }

    public void func_145841_b(NBTTagCompound compound) {
        super.func_145841_b(compound);
        compound.func_74768_a("mode", this.mode.value);
        if (this.content == null) {
            compound.func_74778_a("content", "");
        } else {
            compound.func_74778_a("content", Block.field_149771_c.func_148750_c((Object)this.content));
        }
        compound.func_74768_a("contentMeta", this.contentMeta);
        compound.func_74776_a("volume", this.volume);
        compound.func_74757_a("particles", this.particleMode);
        compound.func_74776_a("speed", this.PROCESSING_INTERVAL);
        this.storage.writeToNBT(compound);
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.inventory.length; ++i) {
            if (this.inventory[i] == null) continue;
            NBTTagCompound nbttagcompound1 = new NBTTagCompound();
            nbttagcompound1.func_74774_a("Slot", (byte)i);
            this.inventory[i].func_77955_b(nbttagcompound1);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound1);
        }
        compound.func_74782_a("Items", (NBTBase)nbttaglist);
    }

    public Packet func_145844_m() {
        NBTTagCompound tag = new NBTTagCompound();
        this.func_145841_b(tag);
        return new S35PacketUpdateTileEntity(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145847_g, tag);
    }

    public void onDataPacket(NetworkManager net, S35PacketUpdateTileEntity pkt) {
        NBTTagCompound tag = pkt.func_148857_g();
        this.func_145839_a(tag);
    }

    public boolean canConnectEnergy(ForgeDirection from) {
        return true;
    }

    public int receiveEnergy(ForgeDirection from, int maxReceive, boolean simulate) {
        return this.storage.receiveEnergy(maxReceive, simulate);
    }

    public int extractEnergy(ForgeDirection from, int maxExtract, boolean simulate) {
        return this.storage.extractEnergy(maxExtract, simulate);
    }

    public int getEnergyStored(ForgeDirection from) {
        return this.storage.getEnergyStored();
    }

    public int getMaxEnergyStored(ForgeDirection from) {
        return this.storage.getMaxEnergyStored();
    }

    public int func_70302_i_() {
        return 23;
    }

    public ItemStack func_70301_a(int slot) {
        return this.inventory[slot];
    }

    public ItemStack func_70298_a(int slot, int amount) {
        if (this.inventory[slot] != null) {
            if (this.inventory[slot].field_77994_a <= amount) {
                ItemStack itemstack = this.inventory[slot];
                this.inventory[slot] = null;
                return itemstack;
            }
            ItemStack itemstack1 = this.inventory[slot].func_77979_a(amount);
            if (this.inventory[slot].field_77994_a == 0) {
                this.inventory[slot] = null;
            }
            return itemstack1;
        }
        return null;
    }

    public ItemStack func_70304_b(int i) {
        return null;
    }

    public void func_70299_a(int slot, ItemStack stack) {
        this.inventory[slot] = stack;
        if (stack != null && stack.field_77994_a > this.func_70297_j_()) {
            stack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return null;
    }

    public boolean func_145818_k_() {
        return false;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer par1EntityPlayer) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this ? false : par1EntityPlayer.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int slot, ItemStack item) {
        return SieveRegistry.Contains((Block)Block.func_149634_a((Item)item.func_77973_b()), (int)item.func_77960_j()) && slot == 0;
    }

    public int[] func_94128_d(int side) {
        int size = this.func_70302_i_() - 2;
        int[] slots = new int[size];
        for (int i = 0; i < size; ++i) {
            slots[i] = i;
        }
        return slots;
    }

    public boolean func_102007_a(int slot, ItemStack item, int side) {
        if (slot == 0) {
            Boolean allowed = this.registryCache.get(new ItemInfo(item));
            if (allowed == null) {
                if (SieveRegistry.Contains((Block)Block.func_149634_a((Item)item.func_77973_b()), (int)item.func_77960_j())) {
                    this.registryCache.put(new ItemInfo(item), true);
                    return true;
                }
                this.registryCache.put(new ItemInfo(item), false);
                return false;
            }
            return allowed != false;
        }
        if (slot == 21) {
            return item.func_77973_b() == ExAstrisItem.sieveUpgradeItem && item.func_77960_j() == 0;
        }
        if (slot == 22) {
            return item.func_77973_b() == ExAstrisItem.sieveUpgradeItem && item.func_77960_j() == 1;
        }
        return false;
    }

    public boolean func_102008_b(int slot, ItemStack item, int side) {
        return slot >= 1 && slot < 21;
    }

    public float getEffectiveSpeed() {
        float time = this.PROCESSING_INTERVAL;
        if (this.inventory[21] != null) {
            time += (float)this.inventory[21].field_77994_a / 1024.0f;
        }
        return time;
    }

    public int getEffectiveEnergy() {
        int energy = this.energyPerCycle;
        if (this.inventory[21] != null) {
            energy = (int)((float)energy * (((float)this.inventory[21].field_77994_a / 1024.0f + this.PROCESSING_INTERVAL) / this.PROCESSING_INTERVAL));
        }
        if (this.inventory[22] != null) {
            energy += this.inventory[22].field_77994_a * ModData.sieveFortuneRFIncrease;
        }
        return energy;
    }

    public int getFortuneModifier() {
        if (this.inventory[22] == null || ModData.sieveFortuneChance == 0) {
            return 1;
        }
        int multiplier = 1;
        for (int i = 0; i < this.inventory[22].field_77994_a; ++i) {
            if (rand.nextInt(101 - ModData.sieveFortuneChance) != 0) continue;
            ++multiplier;
        }
        return multiplier;
    }

    public void setEnergyStored(int energy) {
        this.storage.setEnergyStored(energy);
    }

    public static enum SieveMode {
        EMPTY(0),
        FILLED(1);

        public int value;

        private SieveMode(int v) {
            this.value = v;
        }
    }
}

