/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.util.teleport;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.FMLLog;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.gameevent.PlayerEvent;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import fi.dy.masa.enderutilities.network.PacketHandler;
import fi.dy.masa.enderutilities.network.message.MessageAddEffects;
import fi.dy.masa.enderutilities.util.EntityUtils;
import fi.dy.masa.enderutilities.util.ItemNBTHelper;
import fi.dy.masa.enderutilities.util.PositionHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityMinecartContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.network.Packet;
import net.minecraft.network.play.server.S07PacketRespawn;
import net.minecraft.network.play.server.S1DPacketEntityEffect;
import net.minecraft.potion.PotionEffect;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.ServerConfigurationManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.event.entity.living.EnderTeleportEvent;

public class TeleportEntity {
    public static void addTeleportSoundsAndParticles(World world, double x, double y, double z) {
        if (world.field_72995_K) {
            return;
        }
        world.func_72908_a(x, y, z, "mob.endermen.portal", 0.8f, 1.0f + (world.field_73012_v.nextFloat() * 0.5f - world.field_73012_v.nextFloat() * 0.5f) * 0.5f);
        PacketHandler.INSTANCE.sendToAllAround((IMessage)new MessageAddEffects(1, 3, x, y, z), new NetworkRegistry.TargetPoint(world.field_73011_w.field_76574_g, x, y, z, 24.0));
    }

    public static boolean canTeleportEntity(Entity entity) {
        return !EntityUtils.doesEntityStackHaveBlacklistedEntities(entity);
    }

    public static void teleportEntityRandomly(EntityLivingBase entity, double maxDist) {
        if (entity == null || !TeleportEntity.canTeleportEntity((Entity)entity) || entity.field_70170_p.field_72995_K) {
            return;
        }
        TeleportEntity.addTeleportSoundsAndParticles(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        double deltaYaw = 0.0;
        double deltaPitch = 0.0;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        maxDist -= Math.random() * maxDist / 2.0;
        for (int i = 0; i < 10; ++i) {
            deltaYaw = Math.random() * 360.0 / 180.0 * Math.PI;
            deltaPitch = Math.random() * 90.0 / 180.0 * Math.PI;
            x = entity.field_70165_t;
            y = entity.field_70163_u;
            z = entity.field_70161_v;
            if (entity.field_70170_p.func_147439_a((int)(x += Math.cos(deltaPitch) * Math.cos(deltaYaw) * maxDist), (int)(y += Math.sin(deltaPitch) * maxDist), (int)(z += Math.cos(deltaPitch) * Math.sin(deltaYaw) * maxDist)) != Blocks.field_150350_a || entity.field_70170_p.func_147439_a((int)x, (int)y + 1, (int)z) != Blocks.field_150350_a) continue;
            entity.func_70634_a(x, y, z);
            TeleportEntity.addTeleportSoundsAndParticles(entity.field_70170_p, x, y, z);
            return;
        }
    }

    public static boolean entityTeleportWithProjectile(Entity entity, Entity projectile, MovingObjectPosition mop, float teleportDamage, boolean allowMounts, boolean allowRiders) {
        Entity entNew;
        if (!TeleportEntity.canTeleportEntity(entity)) {
            return false;
        }
        PositionHelper pos = new PositionHelper(mop, projectile);
        if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && mop.field_72307_f != null) {
            ForgeDirection dir = ForgeDirection.getOrientation((int)mop.field_72310_e);
            pos.posX += (double)dir.offsetX * 0.5 * (double)entity.field_70130_N;
            pos.posZ += (double)dir.offsetZ * 0.5 * (double)entity.field_70130_N;
            if (mop.field_72310_e == 0) {
                pos.posY -= (double)entity.field_70131_O;
            }
            for (int y = (int)pos.posY; y < 254 && (entity.field_70170_p.func_147439_a((int)pos.posX, y, (int)pos.posZ).func_149688_o().func_76218_k() || entity.field_70170_p.func_147439_a((int)pos.posX, y + 1, (int)pos.posZ).func_149688_o().func_76218_k()); ++y) {
                pos.posY += 1.0;
            }
        }
        if ((entNew = TeleportEntity.teleportEntity(entity, pos.posX, pos.posY, pos.posZ, projectile.field_71093_bK, allowMounts, allowRiders)) != null) {
            Entity bottom = EntityUtils.getBottomEntity(entNew);
            if (bottom instanceof EntityLivingBase) {
                bottom.func_70097_a(DamageSource.field_76379_h, teleportDamage);
            }
            return true;
        }
        return false;
    }

    public static Entity teleportEntityUsingItem(Entity entity, ItemStack stack) {
        return TeleportEntity.teleportEntityUsingItem(entity, stack, true, true);
    }

    public static Entity teleportEntityUsingItem(Entity entity, ItemStack stack, boolean allowMounts, boolean allowRiders) {
        if (entity.field_70170_p.field_72995_K || stack == null) {
            return null;
        }
        ItemNBTHelper target = new ItemNBTHelper();
        if (target.readTargetTagFromNBT(stack.func_77978_p()) != null) {
            return TeleportEntity.teleportEntity(entity, (double)target.posX + 0.5, target.posY, (double)target.posZ + 0.5, target.dimension, allowMounts, allowRiders);
        }
        return null;
    }

    public static Entity teleportEntity(Entity entity, double x, double y, double z, int dimDst, boolean allowMounts, boolean allowRiders) {
        if (entity == null || entity.field_70170_p.field_72995_K) {
            return null;
        }
        if (!allowMounts && entity.field_70154_o != null) {
            return null;
        }
        if (!allowRiders && entity.field_70153_n != null) {
            return null;
        }
        if (!TeleportEntity.canTeleportEntity(entity)) {
            return null;
        }
        Entity ret = null;
        boolean reCreate = EntityUtils.doesEntityStackHavePlayers(entity);
        Entity previous = null;
        Entity current = EntityUtils.getBottomEntity(entity);
        while (current != null) {
            Entity teleported;
            Entity riddenBy = current.field_70153_n;
            if (current.field_70153_n != null) {
                current.field_70153_n.func_70078_a((Entity)null);
            }
            if (current == entity) {
                ret = teleported = TeleportEntity.teleportEntity(current, x, y, z, dimDst, reCreate);
            } else {
                teleported = TeleportEntity.teleportEntity(current, x, y, z, dimDst, reCreate);
            }
            if (teleported == null) break;
            if (previous != null) {
                teleported.func_70078_a(previous);
            }
            teleported.field_70143_R = 0.0f;
            current = riddenBy;
            previous = teleported;
        }
        return ret;
    }

    private static Entity teleportEntity(Entity entity, double x, double y, double z, int dimDst, boolean forceRecreate) {
        EnderTeleportEvent etpEvent;
        if (entity == null || entity.field_70128_L || !TeleportEntity.canTeleportEntity(entity) || entity.field_70170_p.field_72995_K) {
            return null;
        }
        if (entity instanceof EntityLivingBase && MinecraftForge.EVENT_BUS.post((Event)(etpEvent = new EnderTeleportEvent((EntityLivingBase)entity, x, y, z, 0.0f)))) {
            return null;
        }
        TeleportEntity.addTeleportSoundsAndParticles(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        if (!entity.field_70170_p.field_72995_K && entity.field_70170_p instanceof WorldServer) {
            MinecraftServer minecraftserver = MinecraftServer.func_71276_C();
            WorldServer worldServerDst = minecraftserver.func_71218_a(dimDst);
            if (worldServerDst == null) {
                FMLLog.warning((String)"[Ender Utilities] teleportEntity(): worldServerDst == null", (Object[])new Object[0]);
                return null;
            }
            IChunkProvider chunkProvider = worldServerDst.func_72863_F();
            if (chunkProvider == null) {
                return null;
            }
            if (!chunkProvider.func_73149_a((int)x >> 4, (int)z >> 4)) {
                chunkProvider.func_73158_c((int)x >> 4, (int)z >> 4);
            }
            if (entity instanceof EntityLiving) {
                ((EntityLiving)entity).func_70657_f(0.0f);
                ((EntityLiving)entity).func_70661_as().func_75499_g();
            }
            if (entity.field_71093_bK != dimDst || entity.field_70170_p instanceof WorldServer && entity.field_70170_p != worldServerDst) {
                entity = TeleportEntity.transferEntityToDimension(entity, dimDst, x, y, z);
            } else if (entity instanceof EntityPlayerMP) {
                ((EntityPlayerMP)entity).field_71135_a.func_147364_a(x, y, z, entity.field_70177_z, entity.field_70125_A);
            } else if (entity instanceof EntityPlayer) {
                ((EntityPlayer)entity).func_70634_a(x, y, z);
            } else if (forceRecreate) {
                entity = TeleportEntity.reCreateEntity(entity, x, y, z);
            } else if (entity instanceof EntityLivingBase) {
                ((EntityLivingBase)entity).func_70634_a(x, y, z);
            } else {
                entity.func_70012_b(x, y, z, entity.field_70177_z, entity.field_70125_A);
            }
        }
        if (entity != null) {
            TeleportEntity.addTeleportSoundsAndParticles(entity.field_70170_p, x, y, z);
        }
        return entity;
    }

    public static Entity reCreateEntity(Entity entitySrc, double x, double y, double z) {
        Entity entityDst;
        if (entitySrc.field_70170_p.field_72995_K) {
            return null;
        }
        WorldServer worldServerDst = MinecraftServer.func_71276_C().func_71218_a(entitySrc.field_71093_bK);
        if (worldServerDst == null) {
            FMLLog.warning((String)"[Ender Utilities] reCreateEntity(): worldServerDst == null", (Object[])new Object[0]);
            return null;
        }
        entitySrc.field_70170_p.func_72900_e(entitySrc);
        entitySrc.field_70128_L = false;
        entitySrc.func_70078_a((Entity)null);
        if (entitySrc.field_70153_n != null) {
            entitySrc.field_70153_n.func_70078_a((Entity)null);
        }
        if ((entityDst = EntityList.func_75620_a((String)EntityList.func_75621_b((Entity)entitySrc), (World)worldServerDst)) == null) {
            return null;
        }
        entityDst.func_82141_a(entitySrc, true);
        entityDst.func_70012_b(x, y, z, entitySrc.field_70177_z, entitySrc.field_70125_A);
        worldServerDst.func_72838_d(entityDst);
        worldServerDst.func_82742_i();
        entitySrc.field_70128_L = true;
        return entityDst;
    }

    public static Entity transferEntityToDimension(Entity entitySrc, int dimDst, double x, double y, double z) {
        if (entitySrc == null || entitySrc.field_70128_L || entitySrc.field_71093_bK == dimDst || entitySrc.field_70170_p.field_72995_K) {
            return null;
        }
        if (entitySrc instanceof EntityPlayerMP) {
            return TeleportEntity.transferPlayerToDimension((EntityPlayerMP)entitySrc, dimDst, x, y, z);
        }
        WorldServer worldServerSrc = MinecraftServer.func_71276_C().func_71218_a(entitySrc.field_71093_bK);
        WorldServer worldServerDst = MinecraftServer.func_71276_C().func_71218_a(dimDst);
        if (worldServerSrc == null || worldServerDst == null) {
            FMLLog.warning((String)"[Ender Utilities] transferEntityToDimension(): worldServer[Src|Dst] == null", (Object[])new Object[0]);
            return null;
        }
        entitySrc.func_70078_a((Entity)null);
        if (entitySrc.field_70153_n != null) {
            entitySrc.field_70153_n.func_70078_a((Entity)null);
        }
        entitySrc.field_71093_bK = dimDst;
        Entity entityDst = EntityList.func_75620_a((String)EntityList.func_75621_b((Entity)entitySrc), (World)worldServerDst);
        if (entityDst == null) {
            return null;
        }
        entityDst.func_82141_a(entitySrc, true);
        if (entitySrc instanceof EntityMinecartContainer) {
            entitySrc.field_70128_L = true;
        } else {
            entitySrc.field_70170_p.func_72900_e(entitySrc);
        }
        x = MathHelper.func_151237_a((double)x, (double)-3.0E7, (double)3.0E7);
        z = MathHelper.func_151237_a((double)z, (double)-3.0E7, (double)3.0E7);
        entityDst.func_70012_b(x, y, z, entitySrc.field_70177_z, entitySrc.field_70125_A);
        worldServerDst.func_72838_d(entityDst);
        worldServerDst.func_72866_a(entityDst, false);
        entityDst.func_70029_a((World)worldServerDst);
        entitySrc.field_70128_L = true;
        worldServerSrc.func_82742_i();
        worldServerDst.func_82742_i();
        return entityDst;
    }

    public static EntityPlayerMP transferPlayerToDimension(EntityPlayerMP player, int dimDst, double x, double y, double z) {
        if (player == null || player.field_70128_L || player.field_71093_bK == dimDst || player.field_70170_p.field_72995_K) {
            return null;
        }
        PlayerEvent.PlayerChangedDimensionEvent pcdEvent = new PlayerEvent.PlayerChangedDimensionEvent((EntityPlayer)player, player.field_71093_bK, dimDst);
        if (FMLCommonHandler.instance().bus().post((Event)pcdEvent)) {
            return null;
        }
        int dimSrc = player.field_71093_bK;
        x = MathHelper.func_151237_a((double)x, (double)-3.0E7, (double)3.0E7);
        z = MathHelper.func_151237_a((double)z, (double)-3.0E7, (double)3.0E7);
        player.func_70012_b(x, y, z, player.field_70177_z, player.field_70125_A);
        ServerConfigurationManager serverCM = player.field_71133_b.func_71203_ab();
        WorldServer worldServerSrc = MinecraftServer.func_71276_C().func_71218_a(dimSrc);
        WorldServer worldServerDst = MinecraftServer.func_71276_C().func_71218_a(dimDst);
        if (worldServerSrc == null || worldServerDst == null) {
            FMLLog.warning((String)"[Ender Utilities] transferPlayerToDimension(): worldServer[Src|Dst] == null", (Object[])new Object[0]);
            return null;
        }
        player.field_71093_bK = dimDst;
        player.field_71135_a.func_147359_a((Packet)new S07PacketRespawn(player.field_71093_bK, player.field_70170_p.field_73013_u, player.field_70170_p.func_72912_H().func_76067_t(), player.field_71134_c.func_73081_b()));
        worldServerSrc.func_72900_e((Entity)player);
        player.field_70128_L = false;
        player.func_70078_a((Entity)null);
        if (player.field_70153_n != null) {
            player.field_70153_n.func_70078_a((Entity)null);
        }
        worldServerDst.func_72838_d((Entity)player);
        worldServerDst.func_72866_a((Entity)player, false);
        player.func_70029_a((World)worldServerDst);
        serverCM.func_72375_a(player, worldServerSrc);
        player.field_71135_a.func_147364_a(x, y, z, player.field_70177_z, player.field_70125_A);
        player.field_71134_c.func_73080_a(worldServerDst);
        player.field_71133_b.func_71203_ab().func_72354_b(player, worldServerDst);
        player.field_71133_b.func_71203_ab().func_72385_f(player);
        player.func_71023_q(0);
        player.func_71118_n();
        for (PotionEffect potioneffect : player.func_70651_bq()) {
            player.field_71135_a.func_147359_a((Packet)new S1DPacketEntityEffect(player.func_145782_y(), potioneffect));
        }
        FMLCommonHandler.instance().firePlayerChangedDimensionEvent((EntityPlayer)player, dimSrc, dimDst);
        return player;
    }
}

