/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.util;

import com.google.common.collect.ImmutableSet;
import fi.dy.masa.enderutilities.EnderUtilities;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.ChunkCoordIntPair;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.ForgeChunkManager;

public class ChunkLoading
implements ForgeChunkManager.LoadingCallback {
    private static ChunkLoading instance;
    private HashMap<String, DimChunkCoordTimeout> timeOuts;
    private HashMap<String, ForgeChunkManager.Ticket> playerTickets;

    public ChunkLoading() {
        instance = this;
        this.timeOuts = new HashMap();
        this.playerTickets = new HashMap();
    }

    public static ChunkLoading getInstance() {
        return instance;
    }

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        if (world.field_72995_K) {
            return;
        }
        for (int i = 0; i < tickets.size(); ++i) {
            NBTTagCompound nbt;
            ForgeChunkManager.Ticket ticket = tickets.get(i);
            if (ticket == null || !ticket.isPlayerTicket() || (nbt = ticket.getModData()) != null && nbt.func_74764_b("PersistentTicket") && nbt.func_74767_n("PersistentTicket")) continue;
            ImmutableSet chunks = ticket.getChunkList();
            for (ChunkCoordIntPair chunk : chunks) {
                ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)chunk);
                if (ticket == null || ticket.world == null || ticket.world.field_73011_w == null) continue;
                this.timeOuts.remove(ChunkLoading.dimChunkCoordsToString(ticket.world.field_73011_w.field_76574_g, chunk.field_77276_a, chunk.field_77275_b));
            }
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
            if (nbt == null || !nbt.func_150297_b("PlayerUUIDMost", 4) || !nbt.func_150297_b("PlayerUUIDLeast", 4)) continue;
            this.removePlayerTicket(ticket);
        }
    }

    public ForgeChunkManager.Ticket requestPlayerTicket(EntityPlayer player, int dimension, boolean isTemporary) {
        ForgeChunkManager.Ticket ticket = this.getPlayerTicket(player, dimension);
        if (ticket != null) {
            return ticket;
        }
        WorldServer world = MinecraftServer.func_71276_C().func_71218_a(dimension);
        if (world == null) {
            EnderUtilities.logger.warn("requestTemporaryPlayerTicket(): Couldn't get world for dimension (" + dimension + ")");
            return null;
        }
        ticket = ForgeChunkManager.requestPlayerTicket((Object)EnderUtilities.instance, (String)player.func_70005_c_(), (World)world, (ForgeChunkManager.Type)ForgeChunkManager.Type.NORMAL);
        if (ticket == null) {
            EnderUtilities.logger.warn("requestTemporaryPlayerTicket(): Couldn't get a chunk loading ticket for player '" + player.func_70005_c_() + "'");
            return null;
        }
        ticket.getModData().func_74778_a("PlayerName", player.func_70005_c_());
        ticket.getModData().func_74772_a("PlayerUUIDMost", player.func_110124_au().getMostSignificantBits());
        ticket.getModData().func_74772_a("PlayerUUIDLeast", player.func_110124_au().getLeastSignificantBits());
        if (isTemporary) {
            ticket.getModData().func_74757_a("TemporaryPlayerTicket", true);
        }
        this.addPlayerTicket(player, dimension, ticket);
        return ticket;
    }

    public UUID getPlayerUUIDFromTicket(ForgeChunkManager.Ticket ticket) {
        NBTTagCompound nbt = ticket.getModData();
        if (nbt == null || !nbt.func_150297_b("PlayerUUIDMost", 4) || !nbt.func_150297_b("PlayerUUIDLeast", 4)) {
            return null;
        }
        return new UUID(nbt.func_74763_f("PlayerUUIDMost"), nbt.func_74763_f("PlayerUUIDLeast"));
    }

    public void addPlayerTicket(EntityPlayer player, int dimension, ForgeChunkManager.Ticket ticket) {
        this.addPlayerTicket(player.func_110124_au().toString(), dimension, ticket);
    }

    public void addPlayerTicket(String uuidStr, int dimension, ForgeChunkManager.Ticket ticket) {
        this.playerTickets.put(uuidStr + "-" + dimension, ticket);
    }

    public ForgeChunkManager.Ticket getPlayerTicket(EntityPlayer player, int dimension) {
        return this.getPlayerTicket(player.func_110124_au().toString(), dimension);
    }

    public ForgeChunkManager.Ticket getPlayerTicket(String uuidStr, int dimension) {
        return this.playerTickets.get(uuidStr + "-" + dimension);
    }

    public void removePlayerTicket(EntityPlayer player, int dimension) {
        this.removePlayerTicket(player.func_110124_au().toString(), dimension);
    }

    public void removePlayerTicket(ForgeChunkManager.Ticket ticket) {
        if (ticket == null || ticket.world == null || ticket.world.field_73011_w == null) {
            return;
        }
        this.removePlayerTicket(this.getPlayerUUIDFromTicket(ticket).toString(), ticket.world.field_73011_w.field_76574_g);
    }

    public void removePlayerTicket(String uuidStr, int dimension) {
        this.playerTickets.remove(uuidStr + "-" + dimension);
    }

    public static String dimChunkCoordsToString(int dim, ChunkCoordIntPair cc) {
        return dim + "_" + cc.field_77276_a + "_" + cc.field_77275_b;
    }

    public static String dimChunkCoordsToString(int dim, int x, int z) {
        return dim + "_" + x + "_" + z;
    }

    public boolean loadChunkWithoutForce(int dimension, int chunkX, int chunkZ) {
        return this.loadChunkWithoutForce((World)MinecraftServer.func_71276_C().func_71218_a(dimension), chunkX, chunkZ);
    }

    public boolean loadChunkWithoutForce(World world, int chunkX, int chunkZ) {
        if (world == null) {
            return false;
        }
        IChunkProvider chunkProvider = world.func_72863_F();
        if (chunkProvider == null) {
            return false;
        }
        if (!chunkProvider.func_73149_a(chunkX, chunkZ)) {
            chunkProvider.func_73158_c(chunkX, chunkZ);
        }
        return true;
    }

    public boolean loadChunkForcedWithPlayerTicket(EntityPlayer player, int dimension, int chunkX, int chunkZ, int unloadDelay) {
        ForgeChunkManager.Ticket ticket = this.requestPlayerTicket(player, dimension, unloadDelay != 0);
        return this.loadChunkForcedWithPlayerTicket(ticket, dimension, chunkX, chunkZ, unloadDelay);
    }

    public boolean loadChunkForcedWithPlayerTicket(ForgeChunkManager.Ticket ticket, int dimension, int chunkX, int chunkZ, int unloadDelay) {
        if (ticket == null) {
            return false;
        }
        ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkCoordIntPair)new ChunkCoordIntPair(chunkX, chunkZ));
        if (unloadDelay > 0) {
            this.addChunkTimeout(ticket, dimension, chunkX, chunkZ, unloadDelay);
        }
        return this.loadChunkWithoutForce(dimension, chunkX, chunkZ);
    }

    public void addChunkTimeout(ForgeChunkManager.Ticket ticket, int dimension, int chunkX, int chunkZ, int timeout) {
        String s = ChunkLoading.dimChunkCoordsToString(dimension, chunkX, chunkZ);
        if (this.timeOuts.containsKey(s)) {
            this.timeOuts.get(s).setTimeout(timeout);
        } else {
            this.timeOuts.put(s, new DimChunkCoordTimeout(ticket, dimension, new ChunkCoordIntPair(chunkX, chunkZ), timeout));
        }
    }

    public boolean refreshChunkTimeout(int dimension, int chunkX, int chunkZ) {
        String s = ChunkLoading.dimChunkCoordsToString(dimension, chunkX, chunkZ);
        if (this.timeOuts.containsKey(s)) {
            this.timeOuts.get(s).refreshTimeout();
            return true;
        }
        return false;
    }

    public void tickChunkTimeouts() {
        ArrayList<String> toRemove = new ArrayList<String>();
        for (Map.Entry<String, DimChunkCoordTimeout> entry : this.timeOuts.entrySet()) {
            DimChunkCoordTimeout dcct = entry.getValue();
            if (dcct != null && !this.playerTickets.containsValue(dcct.ticket)) {
                toRemove.add(entry.getKey());
                continue;
            }
            if (dcct.tick() != 0) continue;
            ForgeChunkManager.unforceChunk((ForgeChunkManager.Ticket)dcct.ticket, (ChunkCoordIntPair)dcct.chunkCoords);
            if (dcct.ticket.getChunkList().size() == 0) {
                this.removePlayerTicket(this.getPlayerUUIDFromTicket(dcct.ticket).toString(), dcct.dimension);
                ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)dcct.ticket);
            }
            toRemove.add(entry.getKey());
        }
        for (int i = 0; i < toRemove.size(); ++i) {
            this.timeOuts.remove(toRemove.get(i));
        }
    }

    public class DimChunkCoordTimeout {
        public int dimension;
        public ChunkCoordIntPair chunkCoords;
        public int timeout;
        public int timeoutFresh;
        public ForgeChunkManager.Ticket ticket;

        public DimChunkCoordTimeout(ForgeChunkManager.Ticket ticket, int dimension, ChunkCoordIntPair cc, int timeout) {
            this.ticket = ticket;
            this.dimension = dimension;
            this.chunkCoords = cc;
            this.timeout = timeout;
            this.timeoutFresh = timeout;
        }

        public void setTimeout(int timeout) {
            this.timeout = timeout;
            this.timeoutFresh = timeout;
        }

        public void refreshTimeout() {
            this.timeout = this.timeoutFresh;
        }

        public int tick() {
            if (this.timeout > 0) {
                --this.timeout;
            }
            return this.timeout;
        }

        public String toString() {
            return this.dimension + "-" + this.chunkCoords.field_77276_a + "-" + this.chunkCoords.field_77275_b;
        }

        public boolean equals(DimChunkCoordTimeout d) {
            return this.dimension == d.dimension && this.chunkCoords.equals((Object)d.chunkCoords);
        }

        public boolean equals(int dim, ChunkCoordIntPair cc) {
            return this.dimension == dim && this.chunkCoords.equals((Object)cc);
        }
    }
}

