/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.tileentity;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fi.dy.masa.enderutilities.gui.client.GuiEnderUtilitiesInventory;
import fi.dy.masa.enderutilities.gui.client.GuiToolWorkstation;
import fi.dy.masa.enderutilities.inventory.ContainerToolWorkstation;
import fi.dy.masa.enderutilities.item.base.IModular;
import fi.dy.masa.enderutilities.tileentity.TileEntityEnderUtilitiesSided;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class TileEntityToolWorkstation
extends TileEntityEnderUtilitiesSided {
    private static final int[] SLOTS = new int[0];

    public TileEntityToolWorkstation() {
        super("toolworkstation");
        this.itemStacks = new ItemStack[20];
    }

    private void writeModulesToItem(int toolSlotNum, int slotStart, int numModuleSlots) {
        if (toolSlotNum >= this.itemStacks.length) {
            return;
        }
        if (this.itemStacks[toolSlotNum] != null && this.itemStacks[toolSlotNum].func_77973_b() instanceof IModular) {
            NBTTagList nbtTagList = new NBTTagList();
            int invSlots = this.func_70302_i_();
            for (int slotNum = slotStart; slotNum < invSlots && slotNum < slotStart + numModuleSlots; ++slotNum) {
                if (this.itemStacks[slotNum] == null) continue;
                NBTTagCompound nbtTagCompound = new NBTTagCompound();
                nbtTagCompound.func_74774_a("Slot", (byte)slotNum);
                this.itemStacks[slotNum].func_77955_b(nbtTagCompound);
                nbtTagList.func_74742_a((NBTBase)nbtTagCompound);
            }
            NBTTagCompound nbt = this.itemStacks[toolSlotNum].func_77978_p();
            if (nbt == null) {
                nbt = new NBTTagCompound();
            }
            nbt.func_74782_a("Items", (NBTBase)nbtTagList);
            this.itemStacks[toolSlotNum].func_77982_d(nbt);
        }
    }

    private void clearModuleSlots(int slotStart, int numModuleSlots) {
        int invSlots = this.func_70302_i_();
        for (int slotNum = slotStart; slotNum < invSlots && slotNum < slotStart + numModuleSlots; ++slotNum) {
            this.itemStacks[slotNum] = null;
        }
    }

    private void readModulesFromItem(int toolSlotNum, int slotStart, int numModuleSlots) {
        if (toolSlotNum >= this.itemStacks.length) {
            return;
        }
        if (this.itemStacks[toolSlotNum] != null && this.itemStacks[toolSlotNum].func_77973_b() instanceof IModular) {
            NBTTagCompound nbt = this.itemStacks[toolSlotNum].func_77978_p();
            if (nbt == null || !nbt.func_150297_b("Items", 9)) {
                return;
            }
            NBTTagList nbtTagList = nbt.func_150295_c("Items", 10);
            int listNumStacks = nbtTagList.func_74745_c();
            for (int i = 0; i < listNumStacks; ++i) {
                NBTTagCompound nbtTagCompound = nbtTagList.func_150305_b(i);
                byte slotNum = nbtTagCompound.func_74771_c("Slot");
                if (slotNum >= this.itemStacks.length || slotNum < slotStart || slotNum >= slotStart + numModuleSlots) continue;
                this.itemStacks[slotNum] = ItemStack.func_77949_a((NBTTagCompound)nbtTagCompound);
            }
        }
    }

    @Override
    public void func_70299_a(int slotNum, ItemStack itemStack) {
        if (slotNum == 0 && this.itemStacks[0] != null) {
            this.writeModulesToItem(0, 1, 10);
            this.clearModuleSlots(1, 10);
        }
        super.func_70299_a(slotNum, itemStack);
        if (slotNum == 0 && this.itemStacks[0] != null) {
            this.clearModuleSlots(1, 10);
            this.readModulesFromItem(0, 1, 10);
        }
    }

    @Override
    public ItemStack func_70301_a(int slotNum) {
        if (slotNum == 0 && this.itemStacks[0] != null && !this.field_145850_b.field_72995_K) {
            this.writeModulesToItem(0, 1, 10);
        }
        return super.func_70301_a(slotNum);
    }

    @Override
    public ItemStack func_70298_a(int slotNum, int maxAmount) {
        if (this.itemStacks[slotNum] != null) {
            if (this.itemStacks[slotNum].field_77994_a <= maxAmount) {
                ItemStack itemstack = this.func_70301_a(slotNum);
                this.func_70299_a(slotNum, null);
                return itemstack;
            }
            ItemStack newStack = this.func_70301_a(slotNum).func_77946_l();
            ItemStack itemstack = newStack.func_77979_a(maxAmount);
            this.func_70299_a(slotNum, newStack);
            if (this.itemStacks[slotNum].field_77994_a == 0) {
                this.func_70299_a(slotNum, null);
            }
            return itemstack;
        }
        return null;
    }

    @Override
    public ItemStack func_70304_b(int slotNum) {
        if (this.itemStacks[slotNum] != null) {
            ItemStack itemstack = this.func_70301_a(slotNum);
            this.func_70299_a(slotNum, null);
            return itemstack;
        }
        return null;
    }

    public boolean canUpdate() {
        return false;
    }

    @Override
    public int[] func_94128_d(int side) {
        return SLOTS;
    }

    @Override
    public boolean func_102007_a(int slotNum, ItemStack itemStack, int side) {
        return false;
    }

    @Override
    public boolean func_102008_b(int slotNum, ItemStack itemStack, int side) {
        return false;
    }

    @Override
    public ContainerToolWorkstation getContainer(InventoryPlayer inventory) {
        return new ContainerToolWorkstation(this, inventory);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiEnderUtilitiesInventory getGui(InventoryPlayer inventoryPlayer) {
        return new GuiToolWorkstation(this.getContainer(inventoryPlayer), this);
    }
}

