/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item.part;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fi.dy.masa.enderutilities.item.base.IChargeable;
import fi.dy.masa.enderutilities.item.base.ItemEnderUtilities;
import fi.dy.masa.enderutilities.reference.ReferenceTextures;
import fi.dy.masa.enderutilities.util.nbt.NBTHelperEnderCharge;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;

public class ItemEnderCapacitor
extends ItemEnderUtilities
implements IChargeable {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;

    public ItemEnderCapacitor() {
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77656_e(0);
        this.func_77655_b("endercapacitor");
        this.func_111206_d(ReferenceTextures.getTextureName((String)this.func_77658_a()));
    }

    public String func_77667_c(ItemStack stack) {
        if (stack.func_77960_j() >= 0 && stack.func_77960_j() <= 2) {
            return super.func_77658_a() + "." + stack.func_77960_j();
        }
        return super.func_77658_a();
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs creativeTab, List list) {
        for (int i = 0; i <= 2; ++i) {
            list.add(new ItemStack((Item)this, 1, i));
        }
    }

    @Override
    public int getCapacity(ItemStack stack) {
        if (stack.func_77960_j() == 1) {
            return 1024;
        }
        if (stack.func_77960_j() == 2) {
            return 4096;
        }
        return 256;
    }

    @Override
    public int getCharge(ItemStack stack) {
        NBTHelperEnderCharge charge = new NBTHelperEnderCharge();
        if (charge.readChargeTagFromNBT(stack.func_77978_p()) == null) {
            return 0;
        }
        return charge.enderChargeAmount;
    }

    @Override
    public int addCharge(ItemStack stack, int amount, boolean simulate) {
        int charge = this.getCharge(stack);
        int capacity = this.getCapacity(stack);
        if (capacity - charge < amount) {
            amount = capacity - charge;
        }
        if (!simulate) {
            stack.func_77982_d(NBTHelperEnderCharge.writeChargeTagToNBT((NBTTagCompound)stack.func_77978_p(), (int)capacity, (int)(charge + amount)));
        }
        return amount;
    }

    @Override
    public int useCharge(ItemStack stack, int amount, boolean simulate) {
        int charge = this.getCharge(stack);
        if (charge < amount) {
            return 0;
        }
        if (!simulate) {
            stack.func_77982_d(NBTHelperEnderCharge.writeChargeTagToNBT((NBTTagCompound)stack.func_77978_p(), (int)this.getCapacity(stack), (int)(charge - amount)));
        }
        return amount;
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int damage) {
        if (damage >= 0 && damage <= 2) {
            return this.iconArray[damage];
        }
        return this.field_77791_bV;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a(this.func_111208_A() + ".0");
        this.iconArray = new IIcon[3];
        for (int i = 0; i < 3; ++i) {
            this.iconArray[i] = iconRegister.func_94245_a(this.func_111208_A() + "." + i);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        int charge = 0;
        int capacity = this.getCapacity(stack);
        NBTHelperEnderCharge chargeData = new NBTHelperEnderCharge();
        if (chargeData.readChargeTagFromNBT(stack.func_77978_p()) != null) {
            charge = chargeData.enderChargeAmount;
        }
        list.add(StatCollector.func_74838_a((String)"gui.tooltip.charge") + ": " + charge + " / " + capacity);
    }
}

