/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fi.dy.masa.enderutilities.item.ItemEU;
import fi.dy.masa.enderutilities.reference.Textures;
import fi.dy.masa.enderutilities.util.EntityUtils;
import java.util.List;
import java.util.UUID;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemMobHarness
extends ItemEU {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;

    public ItemMobHarness() {
        this.func_77625_d(1);
        this.func_77655_b("mobharness");
        this.func_111206_d(Textures.getTextureName(this.func_77658_a()));
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        MovingObjectPosition movingobjectposition;
        if (world.field_72995_K) {
            return stack;
        }
        if (player.func_70093_af() && (movingobjectposition = this.func_77621_a(world, player, true)) != null && movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && player.field_70125_A > 80.0f) {
            this.clearData(stack);
        }
        return stack;
    }

    public boolean handleInteraction(ItemStack stack, EntityPlayer player, Entity entity) {
        if (player == null || entity == null) {
            return false;
        }
        boolean hasTarget = this.hasTarget(stack);
        if (!player.func_70093_af()) {
            EntityUtils.unmountRider(entity);
            player.func_70078_a(entity);
            return true;
        }
        if (!hasTarget) {
            if (player.field_70125_A < -80.0f && player.field_70153_n != null) {
                player.field_70153_n.func_70078_a(null);
            } else if (entity.field_70154_o != null) {
                entity.func_70078_a(null);
            } else {
                this.storeTarget(stack, entity);
            }
        } else {
            this.mountTarget(stack, player.field_70170_p, player, entity);
        }
        return true;
    }

    public boolean hasTarget(ItemStack stack) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null || !nbt.func_150297_b("Mode", 1)) {
            return false;
        }
        byte mode = nbt.func_74771_c("Mode");
        return (mode == 1 || mode == 2) && nbt.func_150297_b("TargetUUIDMost", 4) && nbt.func_150297_b("TargetUUIDLeast", 4) && nbt.func_150297_b("TargetName", 8);
    }

    public ItemStack storeTarget(ItemStack stack, Entity entity) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (entity == null) {
            return stack;
        }
        if (nbt == null) {
            nbt = new NBTTagCompound();
        }
        byte mode = 1;
        if (entity instanceof EntityPlayer) {
            mode = 2;
            nbt.func_74778_a("TargetName", ((EntityPlayer)entity).func_70005_c_());
        } else {
            nbt.func_74778_a("TargetName", EntityList.func_75621_b((Entity)entity));
        }
        nbt.func_74772_a("TargetUUIDMost", entity.func_110124_au().getMostSignificantBits());
        nbt.func_74772_a("TargetUUIDLeast", entity.func_110124_au().getLeastSignificantBits());
        nbt.func_74774_a("Mode", mode);
        stack.func_77982_d(nbt);
        return stack;
    }

    public boolean mountTarget(ItemStack stack, World world, EntityPlayer player, Entity entity) {
        if (stack == null || player == null || entity == null || stack.func_77978_p() == null) {
            return false;
        }
        NBTTagCompound nbt = stack.func_77978_p();
        byte mode = nbt.func_74771_c("Mode");
        double radius = 4.0;
        if (!this.hasTarget(stack)) {
            return false;
        }
        long most = nbt.func_74763_f("TargetUUIDMost");
        long least = nbt.func_74763_f("TargetUUIDLeast");
        if (mode == 1) {
            List list = world.func_72839_b((Entity)player, AxisAlignedBB.func_72330_a((double)(player.field_70165_t - radius), (double)(player.field_70163_u - radius), (double)(player.field_70161_v - radius), (double)(player.field_70165_t + radius), (double)(player.field_70163_u + radius), (double)(player.field_70161_v + radius)));
            for (Entity ent : list) {
                if (ent.func_110124_au().getMostSignificantBits() != most || ent.func_110124_au().getLeastSignificantBits() != least) continue;
                if (entity.func_110124_au().getMostSignificantBits() == most && entity.func_110124_au().getLeastSignificantBits() == least) {
                    EntityUtils.unmountRider((Entity)player);
                    entity.func_70078_a((Entity)player);
                    this.clearData(stack);
                } else {
                    EntityUtils.unmountRidden(ent);
                    EntityUtils.unmountRider(entity);
                    ent.func_70078_a(entity);
                    this.clearData(stack);
                }
                break;
            }
        } else if (mode == 2) {
            EntityPlayerMP targetPlayer = EntityUtils.findPlayerFromUUID(new UUID(most, least));
            if (targetPlayer == null) {
                return false;
            }
            if (entity == targetPlayer) {
                EntityUtils.unmountRidden((Entity)player);
                targetPlayer.func_70078_a((Entity)player);
                this.clearData(stack);
            } else if ((double)entity.func_70032_d((Entity)player) <= radius && (double)targetPlayer.func_70032_d((Entity)player) <= radius) {
                EntityUtils.unmountRidden(entity);
                targetPlayer.func_70078_a(entity);
                this.clearData(stack);
            }
        }
        return false;
    }

    public boolean clearData(ItemStack stack) {
        stack.func_77982_d(null);
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null || !this.hasTarget(stack)) {
            list.add(StatCollector.func_74838_a((String)"gui.tooltip.notlinked"));
            return;
        }
        String pre = "" + EnumChatFormatting.BLUE;
        String rst = "" + EnumChatFormatting.RESET + EnumChatFormatting.GRAY;
        String target = nbt.func_74779_i("TargetName");
        list.add(StatCollector.func_74838_a((String)"gui.tooltip.linked") + ": " + pre + target + rst);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderPasses(int metadata) {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a(this.func_111208_A());
        this.iconArray = new IIcon[2];
        this.iconArray[0] = iconRegister.func_94245_a(this.func_111208_A());
        this.iconArray[1] = iconRegister.func_94245_a(this.func_111208_A() + ".active");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int renderPass) {
        if (this.hasTarget(stack)) {
            return this.iconArray[1];
        }
        return this.iconArray[0];
    }
}

