/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fi.dy.masa.enderutilities.client.effects.Sounds;
import fi.dy.masa.enderutilities.item.ItemEUTeleport;
import fi.dy.masa.enderutilities.reference.Textures;
import fi.dy.masa.enderutilities.setup.EUConfigs;
import fi.dy.masa.enderutilities.util.EntityUtils;
import fi.dy.masa.enderutilities.util.ItemNBTHelper;
import fi.dy.masa.enderutilities.util.TooltipHelper;
import fi.dy.masa.enderutilities.util.teleport.TeleportEntity;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemEnderPorter
extends ItemEUTeleport {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;
    private static final int USE_TIME = 60;

    public ItemEnderPorter() {
        this.func_77625_d(1);
        this.func_77627_a(true);
        this.func_77655_b("enderporter");
        this.func_111206_d(Textures.getTextureName(this.func_77658_a()));
    }

    public String func_77667_c(ItemStack stack) {
        if (stack.func_77960_j() == 1) {
            return super.func_77658_a() + ".advanced";
        }
        return super.func_77658_a();
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        MovingObjectPosition movingobjectposition;
        if (stack == null) {
            return false;
        }
        if (player.func_70093_af() && (movingobjectposition = this.func_77621_a(world, player, true)) != null && movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            NBTTagCompound nbt = stack.func_77978_p();
            nbt = ItemNBTHelper.writeTargetTagToNBT(nbt, x, y, z, player.field_71093_bK, side, true);
            stack.func_77982_d(nbt);
            return true;
        }
        return false;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        MovingObjectPosition movingobjectposition;
        if (player.func_70093_af() && (movingobjectposition = this.func_77621_a(world, player, true)) != null && movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            return stack;
        }
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null && ItemNBTHelper.hasTargetTag(nbt) && !EntityUtils.doesEntityStackHaveBlacklistedEntities((Entity)player)) {
            player.func_71008_a(stack, this.func_77626_a(stack));
            if (!player.field_70170_p.field_72995_K) {
                Sounds.playSound(world, player.field_70165_t, player.field_70163_u, player.field_70161_v, "portal.travel", 0.08f, 1.2f);
            }
        }
        return stack;
    }

    public void func_77615_a(ItemStack stack, World world, EntityPlayer player, int inUseCount) {
        NBTTagCompound nbt = stack.func_77978_p();
        ItemNBTHelper target = new ItemNBTHelper();
        int useTime = 60;
        if (player.field_71075_bZ.field_75098_d) {
            useTime >>= 3;
        }
        if (this.func_77626_a(stack) - inUseCount >= useTime && target.readTargetTagFromNBT(nbt) != null && TeleportEntity.teleportEntityUsingItem((Entity)player, stack, true, true) != null && !player.field_71075_bZ.field_75098_d && stack.func_77960_j() == 0 && --stack.field_77994_a <= 0) {
            player.func_71028_bD();
        }
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_150895_a(Item item, CreativeTabs creativeTab, List list) {
        if (!EUConfigs.disableItemEnderPorterBasic.getBoolean(false)) {
            list.add(new ItemStack((Item)this, 1, 0));
        }
        if (!EUConfigs.disableItemEnderPorterAdvanced.getBoolean(false)) {
            list.add(new ItemStack((Item)this, 1, 1));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderPasses(int metadata) {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        int i;
        this.field_77791_bV = iconRegister.func_94245_a(this.func_111208_A() + ".stage.1");
        this.iconArray = new IIcon[14];
        for (i = 0; i < 7; ++i) {
            this.iconArray[i] = iconRegister.func_94245_a(this.func_111208_A() + ".stage." + (i + 1));
        }
        for (i = 0; i < 7; ++i) {
            this.iconArray[7 + i] = iconRegister.func_94245_a(this.func_111208_A() + ".advanced.stage." + (i + 1));
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getItemIconForUseDuration(int index) {
        if (index >= this.iconArray.length) {
            index = this.iconArray.length - 1;
        }
        if (index < 0) {
            index = 0;
        }
        return this.iconArray[index];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int renderPass) {
        return this.getIcon(stack, renderPass, null, null, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        int index = 0;
        if (player != null && player.func_71011_bu() != null && stack != null) {
            int inUse = stack.func_77988_m() - useRemaining;
            int useTime = 60;
            if (player.field_71075_bZ.field_75098_d) {
                useTime >>= 3;
            }
            if ((index += 7 * inUse / useTime) > 6) {
                index = 6;
            }
        }
        if (stack.func_77960_j() == 1) {
            index += 7;
        }
        return this.getItemIconForUseDuration(index);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        ItemNBTHelper target = new ItemNBTHelper();
        NBTTagCompound nbt = stack.func_77978_p();
        if (target.readTargetTagFromNBT(nbt) == null) {
            list.add(StatCollector.func_74838_a((String)"gui.tooltip.notargetset"));
            return;
        }
        String dimPre = "" + EnumChatFormatting.GREEN;
        String coordPre = "" + EnumChatFormatting.BLUE;
        String rst = "" + EnumChatFormatting.RESET + EnumChatFormatting.GRAY;
        list.add(StatCollector.func_74838_a((String)"gui.tooltip.dimension") + ": " + coordPre + target.dimension + " " + dimPre + TooltipHelper.getLocalizedDimensionName(target.dimension) + rst);
        list.add(String.format("x: %s%d%s, y: %s%d%s, z: %s%d%s", coordPre, target.posX, rst, coordPre, target.posY, rst, coordPre, target.posZ, rst));
    }
}

