/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item;

import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fi.dy.masa.enderutilities.entity.EntityEnderArrow;
import fi.dy.masa.enderutilities.init.EnderUtilitiesItems;
import fi.dy.masa.enderutilities.item.IKeyBound;
import fi.dy.masa.enderutilities.item.ItemEUTeleport;
import fi.dy.masa.enderutilities.reference.Textures;
import fi.dy.masa.enderutilities.setup.EUConfigs;
import fi.dy.masa.enderutilities.util.ItemNBTHelper;
import fi.dy.masa.enderutilities.util.TooltipHelper;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.ArrowLooseEvent;
import net.minecraftforge.event.entity.player.ArrowNockEvent;

public class ItemEnderBow
extends ItemEUTeleport
implements IKeyBound {
    public static final byte BOW_MODE_TP_TARGET = 0;
    public static final byte BOW_MODE_TP_SELF = 1;
    public static final String[] bowPullIconNameArray = new String[]{"standby", "pulling.0", "pulling.1", "pulling.2", "mode2.standby", "mode2.pulling.0", "mode2.pulling.1", "mode2.pulling.2"};
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;

    public ItemEnderBow() {
        this.func_77625_d(1);
        this.func_77656_e(384);
        this.func_77655_b("enderbow");
        this.func_111206_d(Textures.getTextureName(this.func_77658_a()));
    }

    public void func_77615_a(ItemStack bowStack, World world, EntityPlayer player, int itemInUseCount) {
        if (world.field_72995_K) {
            return;
        }
        int j = this.func_77626_a(bowStack) - itemInUseCount;
        ArrowLooseEvent event = new ArrowLooseEvent(player, bowStack, j);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return;
        }
        j = event.charge;
        if (player.field_71075_bZ.field_75098_d || player.field_71071_by.func_146028_b((Item)EnderUtilitiesItems.enderArrow)) {
            int x = (int)player.field_70165_t;
            int y = (int)player.field_70163_u;
            int z = (int)player.field_70161_v;
            int dim = player.field_71093_bK;
            byte mode = 0;
            NBTTagCompound nbt = bowStack.func_77978_p();
            if (nbt != null && nbt.func_74764_b("Mode")) {
                mode = nbt.func_74771_c("Mode");
            }
            if (mode == 1 && !EUConfigs.enderBowAllowSelfTP.getBoolean(true)) {
                return;
            }
            if (mode == 0) {
                ItemNBTHelper target = new ItemNBTHelper();
                if (target.readTargetTagFromNBT(nbt) == null) {
                    return;
                }
                x = target.posX;
                y = target.posY;
                z = target.posZ;
                dim = target.dimension;
            }
            float f = (float)j / 20.0f;
            if ((double)(f = (f * f + f * 2.0f) / 3.0f) < 0.1) {
                return;
            }
            if (f > 1.0f) {
                f = 1.0f;
            }
            EntityEnderArrow entityenderarrow = new EntityEnderArrow(world, (EntityLivingBase)player, f * 2.0f);
            entityenderarrow.setTpTarget(x, y, z, dim);
            entityenderarrow.setTpMode(mode);
            if (f == 1.0f) {
                entityenderarrow.func_70243_d(true);
            }
            if (!player.field_71075_bZ.field_75098_d) {
                player.field_71071_by.func_146026_a((Item)EnderUtilitiesItems.enderArrow);
                bowStack.func_77972_a(1, (EntityLivingBase)player);
            }
            world.func_72956_a((Entity)player, "random.bow", 1.0f, 1.0f / (field_77697_d.nextFloat() * 0.4f + 1.2f) + f * 0.5f);
            world.func_72838_d((Entity)entityenderarrow);
        }
    }

    public ItemStack func_77654_b(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        return par1ItemStack;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 72000;
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.bow;
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        MovingObjectPosition movingobjectposition;
        ArrowNockEvent event = new ArrowNockEvent(player, stack);
        MinecraftForge.EVENT_BUS.post((Event)event);
        if (event.isCanceled()) {
            return event.result;
        }
        if (player.func_70093_af() && (movingobjectposition = this.func_77621_a(world, player, true)) != null && movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            return stack;
        }
        if (player.field_71075_bZ.field_75098_d || player.field_71071_by.func_146028_b((Item)EnderUtilitiesItems.enderArrow)) {
            NBTTagCompound nbt = stack.func_77978_p();
            if (nbt == null || !nbt.func_150297_b("Mode", 1)) {
                return stack;
            }
            if (nbt.func_74771_c("Mode") == 0 && !ItemNBTHelper.hasTargetTag(nbt)) {
                return stack;
            }
            player.func_71008_a(stack, this.func_77626_a(stack));
        }
        return stack;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        MovingObjectPosition movingobjectposition;
        if (stack == null) {
            return false;
        }
        if (player.func_70093_af() && (movingobjectposition = this.func_77621_a(world, player, true)) != null && movingobjectposition.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK) {
            NBTTagCompound nbt = stack.func_77978_p();
            if (nbt == null) {
                nbt = new NBTTagCompound();
                nbt.func_74774_a("Mode", (byte)0);
            }
            nbt = ItemNBTHelper.writeTargetTagToNBT(nbt, x, y, z, player.field_71093_bK, side, true);
            stack.func_77982_d(nbt);
            return true;
        }
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            list.add(StatCollector.func_74838_a((String)"gui.tooltip.notargetset"));
            return;
        }
        byte mode = 0;
        if (nbt.func_150297_b("Mode", 1)) {
            mode = nbt.func_74771_c("Mode");
        }
        String dimPre = "" + EnumChatFormatting.GREEN;
        String coordPre = "" + EnumChatFormatting.BLUE;
        String rst = "" + EnumChatFormatting.RESET + EnumChatFormatting.GRAY;
        if (mode == 1) {
            list.add(StatCollector.func_74838_a((String)"gui.tooltip.mode") + ": " + EnumChatFormatting.RED + StatCollector.func_74838_a((String)"gui.tooltip.tpself") + rst);
            return;
        }
        ItemNBTHelper target = new ItemNBTHelper();
        if (target.readTargetTagFromNBT(nbt) == null) {
            list.add(StatCollector.func_74838_a((String)"gui.tooltip.notargetset"));
            return;
        }
        list.add(StatCollector.func_74838_a((String)"gui.tooltip.mode") + ": " + coordPre + StatCollector.func_74838_a((String)"gui.tooltip.tptarget") + rst);
        list.add(StatCollector.func_74838_a((String)"gui.tooltip.dimension") + ": " + coordPre + target.dimension + " " + dimPre + TooltipHelper.getLocalizedDimensionName(target.dimension) + rst);
        list.add(String.format("x: %s%d%s, y: %s%d%s, z: %s%d%s", coordPre, target.posX, rst, coordPre, target.posY, rst, coordPre, target.posZ, rst));
    }

    public int func_77619_b() {
        return 0;
    }

    public boolean func_82789_a(ItemStack stack1, ItemStack stack2) {
        return stack1 != null && stack1.func_77973_b() == EnderUtilitiesItems.enderBow && stack2 != null && stack2.func_77973_b() == Items.field_151045_i;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderPasses(int metadata) {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a(this.func_111208_A() + ".standby");
        this.iconArray = new IIcon[bowPullIconNameArray.length];
        for (int i = 0; i < this.iconArray.length; ++i) {
            this.iconArray[i] = iconRegister.func_94245_a(this.func_111208_A() + "." + bowPullIconNameArray[i]);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getItemIconForUseDuration(int par1) {
        return this.iconArray[par1];
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int renderPass) {
        return this.getIcon(stack, renderPass, null, null, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        int index = 0;
        byte mode = 0;
        if (stack.func_77978_p() != null) {
            mode = stack.func_77978_p().func_74771_c("Mode");
            if (mode > 1 || mode < 0) {
                mode = 0;
            }
            index = mode * 4;
        }
        if (player != null && player.func_71011_bu() != null) {
            int inUse = 0;
            if (stack != null) {
                inUse = stack.func_77988_m() - useRemaining;
            }
            if (inUse >= 18) {
                index += 3;
            } else if (inUse >= 13) {
                index += 2;
            } else if (inUse > 0) {
                ++index;
            }
        }
        return this.getItemIconForUseDuration(index);
    }

    @Override
    public void doKeyBindingAction(EntityPlayer player, ItemStack stack, int key) {
        if (key == 0) {
            byte val = 0;
            NBTTagCompound nbt = stack.func_77978_p();
            if (nbt != null) {
                val = nbt.func_74771_c("Mode");
            } else {
                nbt = new NBTTagCompound();
            }
            val = (byte)(val + 1);
            if (val > 1) {
                val = 0;
            }
            if (!EUConfigs.enderBowAllowSelfTP.getBoolean(true)) {
                val = 0;
            }
            nbt.func_74774_a("Mode", val);
            stack.func_77982_d(nbt);
        }
    }
}

