/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.item;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import fi.dy.masa.enderutilities.item.IChunkLoadingItem;
import fi.dy.masa.enderutilities.item.IKeyBound;
import fi.dy.masa.enderutilities.item.ItemEU;
import fi.dy.masa.enderutilities.reference.Textures;
import fi.dy.masa.enderutilities.setup.EUConfigs;
import fi.dy.masa.enderutilities.setup.EURegistry;
import fi.dy.masa.enderutilities.util.ChunkLoading;
import fi.dy.masa.enderutilities.util.ItemNBTHelper;
import fi.dy.masa.enderutilities.util.TooltipHelper;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityEnderChest;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class ItemEnderBag
extends ItemEU
implements IChunkLoadingItem,
IKeyBound {
    @SideOnly(value=Side.CLIENT)
    private IIcon[] iconArray;

    public ItemEnderBag() {
        this.func_77625_d(1);
        this.func_77655_b("enderbag");
        this.func_111206_d(Textures.getTextureName(this.func_77658_a()));
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        NBTTagCompound nbt = stack.func_77978_p();
        if (world.field_72995_K || nbt == null) {
            return stack;
        }
        if (nbt.func_150297_b("Type", 1) && nbt.func_74771_c("Type") == 1) {
            nbt.func_74757_a("IsOpen", true);
            player.func_71007_a((IInventory)player.func_71005_bN());
            return stack;
        }
        ItemNBTHelper itemData = new ItemNBTHelper();
        if (nbt.func_74771_c("Mode") != 1 && itemData.readPlayerTagFromNBT(nbt) != null && (itemData.playerUUIDMost != player.func_110124_au().getMostSignificantBits() || itemData.playerUUIDLeast != player.func_110124_au().getLeastSignificantBits())) {
            return stack;
        }
        if (itemData.readTargetTagFromNBT(nbt) == null) {
            return stack;
        }
        if (!this.isTargetBlockWhitelisted(nbt.func_74779_i("BlockName")) && (itemData.dimension != player.field_71093_bK || player.func_70092_e((double)itemData.posX, (double)itemData.posY, (double)itemData.posZ) >= 10000.0)) {
            return stack;
        }
        if (ChunkLoading.getInstance().loadChunkForcedWithPlayerTicket(player, itemData.dimension, itemData.posX >> 4, itemData.posZ >> 4, 1200)) {
            WorldServer tgtWorld = MinecraftServer.func_71276_C().func_71218_a(itemData.dimension);
            if (tgtWorld == null) {
                return stack;
            }
            Block block = tgtWorld.func_147439_a(itemData.posX, itemData.posY, itemData.posZ);
            if (block == null) {
                return stack;
            }
            if (!Block.field_149771_c.func_148750_c((Object)block).equals(nbt.func_74779_i("BlockName"))) {
                nbt.func_82580_o("BlockName");
                nbt.func_82580_o("Slots");
                nbt = ItemNBTHelper.removeTargetTagFromNBT(nbt);
                nbt.func_82580_o("ChunkLoadingRequired");
                nbt.func_74757_a("IsOpen", false);
                stack.func_77982_d(nbt);
                player.func_145747_a((IChatComponent)new ChatComponentTranslation("chat.message.enderbag.blockchanged", new Object[0]));
                return stack;
            }
            nbt.func_74757_a("ChunkLoadingRequired", true);
            nbt.func_74757_a("IsOpen", true);
            stack.func_77982_d(nbt);
            block.func_149727_a((World)tgtWorld, itemData.posX, itemData.posY, itemData.posZ, player, itemData.blockFace, 0.5f, 0.5f, 0.5f);
        }
        return stack;
    }

    public boolean func_77648_a(ItemStack stack, EntityPlayer player, World world, int x, int y, int z, int side, float hitX, float hitY, float hitZ) {
        ItemNBTHelper itemData;
        if (!player.func_70093_af()) {
            return false;
        }
        if (world.field_72995_K) {
            return true;
        }
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt == null) {
            nbt = new NBTTagCompound();
            nbt.func_74774_a("Mode", (byte)0);
        }
        if ((itemData = new ItemNBTHelper()).readPlayerTagFromNBT(nbt) != null && (itemData.playerUUIDMost != player.func_110124_au().getMostSignificantBits() || itemData.playerUUIDLeast != player.func_110124_au().getLeastSignificantBits())) {
            return true;
        }
        Block block = world.func_147439_a(x, y, z);
        TileEntity te = world.func_147438_o(x, y, z);
        if (block == null || block == Blocks.field_150350_a || te == null) {
            return true;
        }
        if (te instanceof TileEntityEnderChest || te instanceof IInventory) {
            if (!this.isTargetBlockWhitelisted(Block.field_149771_c.func_148750_c((Object)block))) {
                player.func_145747_a((IChatComponent)new ChatComponentText(StatCollector.func_74838_a((String)"chat.message.enderbag.blocknotwhitelisted") + " '" + Block.field_149771_c.func_148750_c((Object)block) + "'"));
                return true;
            }
            nbt.func_74778_a("BlockName", Block.field_149771_c.func_148750_c((Object)block));
            nbt = ItemNBTHelper.writeTargetTagToNBT(nbt, x, y, z, player.field_71093_bK, side, false);
            nbt = ItemNBTHelper.writePlayerTagToNBT(nbt, player);
            if (te instanceof IInventory) {
                nbt.func_74768_a("Slots", ((IInventory)te).func_70302_i_());
                nbt.func_74774_a("Type", (byte)0);
            } else {
                nbt.func_74768_a("Slots", player.func_71005_bN().func_70302_i_());
                nbt.func_74774_a("Type", (byte)1);
            }
            stack.func_77982_d(nbt);
        }
        return true;
    }

    private boolean isTargetBlockWhitelisted(String name) {
        if (EUConfigs.enderBagListType.getString().equalsIgnoreCase("blacklist")) {
            List<String> list = EURegistry.getEnderbagBlacklist();
            return !list.contains(name);
        }
        List<String> list = EURegistry.getEnderbagWhitelist();
        return list.contains(name);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean par4) {
        ItemNBTHelper itemData = new ItemNBTHelper();
        NBTTagCompound nbt = stack.func_77978_p();
        if (itemData.readTargetTagFromNBT(nbt) == null) {
            list.add(StatCollector.func_74838_a((String)"gui.tooltip.notargetset"));
            return;
        }
        String locName = Block.func_149684_b((String)nbt.func_74779_i("BlockName")).func_149732_F();
        int numSlots = nbt.func_74762_e("Slots");
        String dimPre = "" + EnumChatFormatting.GREEN;
        String coordPre = "" + EnumChatFormatting.BLUE;
        String rst = "" + EnumChatFormatting.RESET + EnumChatFormatting.GRAY;
        list.add(StatCollector.func_74838_a((String)"gui.tooltip.type") + ": " + coordPre + locName + rst);
        list.add(StatCollector.func_74838_a((String)"gui.tooltip.slots") + ": " + coordPre + numSlots + rst);
        if (nbt.func_74771_c("Type") == 0 && itemData.readPlayerTagFromNBT(nbt) != null && itemData.playerUUIDMost == player.func_110124_au().getMostSignificantBits() && itemData.playerUUIDLeast == player.func_110124_au().getLeastSignificantBits()) {
            list.add(StatCollector.func_74838_a((String)"gui.tooltip.dimension") + ": " + coordPre + itemData.dimension + " " + dimPre + TooltipHelper.getLocalizedDimensionName(itemData.dimension) + rst);
            list.add(String.format("x: %s%d%s y: %s%d%s z: %s%d%s", coordPre, itemData.posX, rst, coordPre, itemData.posY, rst, coordPre, itemData.posZ, rst));
        }
        if (nbt.func_74771_c("Type") == 0) {
            String mode = nbt.func_74771_c("Mode") == 1 ? StatCollector.func_74838_a((String)"gui.tooltip.public") : StatCollector.func_74838_a((String)"gui.tooltip.private");
            list.add(StatCollector.func_74838_a((String)"gui.tooltip.mode") + ": " + mode);
            list.add(StatCollector.func_74838_a((String)"gui.tooltip.owner") + ": " + itemData.playerName);
        }
    }

    public boolean doesSneakBypassUse(World world, int x, int y, int z, EntityPlayer player) {
        return false;
    }

    @Override
    public void doKeyBindingAction(EntityPlayer player, ItemStack stack, int key) {
        if (key == 0) {
            byte val = 0;
            NBTTagCompound nbt = stack.func_77978_p();
            if (nbt != null) {
                ItemNBTHelper itemData = new ItemNBTHelper();
                if (itemData.readPlayerTagFromNBT(nbt) != null && (itemData.playerUUIDMost != player.func_110124_au().getMostSignificantBits() || itemData.playerUUIDLeast != player.func_110124_au().getLeastSignificantBits())) {
                    return;
                }
                val = nbt.func_74771_c("Mode");
            } else {
                nbt = new NBTTagCompound();
            }
            val = (byte)(val + 1);
            if (val > 1) {
                val = 0;
            }
            nbt.func_74774_a("Mode", val);
            stack.func_77982_d(nbt);
        }
    }

    public void func_77663_a(ItemStack stack, World world, Entity player, int slot, boolean isCurrent) {
        NBTTagCompound nbt;
        if (stack != null && stack.func_77978_p() != null && (nbt = stack.func_77978_p()).func_74764_b("IsOpenDummy")) {
            nbt.func_82580_o("IsOpenDummy");
            nbt.func_74757_a("IsOpen", false);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public int getRenderPasses(int metadata) {
        return 1;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        this.field_77791_bV = iconRegister.func_94245_a(this.func_111208_A() + ".regular.closed");
        this.iconArray = new IIcon[4];
        this.iconArray[0] = iconRegister.func_94245_a(this.func_111208_A() + ".regular.closed");
        this.iconArray[1] = iconRegister.func_94245_a(this.func_111208_A() + ".regular.open");
        this.iconArray[2] = iconRegister.func_94245_a(this.func_111208_A() + ".enderchest.closed");
        this.iconArray[3] = iconRegister.func_94245_a(this.func_111208_A() + ".enderchest.open");
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int renderPass) {
        return this.getIcon(stack, renderPass, null, null, 0);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon(ItemStack stack, int renderPass, EntityPlayer player, ItemStack usingItem, int useRemaining) {
        int index = 0;
        NBTTagCompound nbt = stack.func_77978_p();
        if (nbt != null) {
            if (nbt.func_74771_c("Type") == 1) {
                index += 2;
            }
            if (nbt.func_74764_b("IsOpen") && nbt.func_74767_n("IsOpen")) {
                ++index;
            }
        }
        return this.iconArray[index < this.iconArray.length ? index : 0];
    }
}

