/*
 * Decompiled with CFR 0.152.
 */
package fi.dy.masa.enderutilities.client.renderer.item;

import cpw.mods.fml.client.FMLClientHandler;
import fi.dy.masa.enderutilities.client.renderer.item.ItemRenderer;
import fi.dy.masa.enderutilities.item.ItemEnderBucket;
import fi.dy.masa.enderutilities.setup.EUConfigs;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraftforge.client.IItemRenderer;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class ItemRendererEnderBucket
implements IItemRenderer {
    public boolean handleRenderType(ItemStack itemStack, IItemRenderer.ItemRenderType type) {
        ItemEnderBucket item;
        FluidStack fluidStack;
        return itemStack != null && itemStack.func_77973_b() instanceof ItemEnderBucket && (fluidStack = (item = (ItemEnderBucket)itemStack.func_77973_b()).getFluid(itemStack)) != null && fluidStack.amount > 0;
    }

    public boolean shouldUseRenderHelper(IItemRenderer.ItemRenderType type, ItemStack item, IItemRenderer.ItemRendererHelper helper) {
        return helper == IItemRenderer.ItemRendererHelper.ENTITY_BOBBING || helper == IItemRenderer.ItemRendererHelper.ENTITY_ROTATION;
    }

    public void renderItem(IItemRenderer.ItemRenderType type, ItemStack itemStack, Object ... data) {
        if (itemStack == null) {
            return;
        }
        IIcon iicon = null;
        int amount = 0;
        ItemEnderBucket item = (ItemEnderBucket)itemStack.func_77973_b();
        FluidStack fluidStack = item.getFluid(itemStack);
        if (fluidStack == null || fluidStack.amount == 0 || fluidStack.getFluid() == null) {
            return;
        }
        amount = fluidStack.amount;
        iicon = fluidStack.getFluid().getStillIcon();
        GL11.glPushMatrix();
        switch (type) {
            case INVENTORY: {
                break;
            }
            default: {
                GL11.glEnable((int)32826);
            }
        }
        GL11.glDisable((int)2896);
        GL11.glDisable((int)3042);
        if (fluidStack.getFluid().isGaseous()) {
            switch (type) {
                case EQUIPPED_FIRST_PERSON: {
                    GL11.glTranslatef((float)0.0f, (float)0.25f, (float)0.0f);
                    GL11.glRotatef((float)60.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                }
                case EQUIPPED: {
                    GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glTranslatef((float)0.0f, (float)-0.95f, (float)0.0f);
                    break;
                }
                case ENTITY: {
                    GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glTranslatef((float)0.0f, (float)-0.5f, (float)0.0f);
                    break;
                }
                case INVENTORY: {
                    GL11.glRotatef((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
                    GL11.glTranslatef((float)0.0f, (float)-16.0f, (float)0.0f);
                    break;
                }
            }
        }
        Tessellator t = Tessellator.field_78398_a;
        if (iicon != null) {
            FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(TextureMap.field_110575_b);
            this.renderQuad(type, t, iicon, 0.375f, 0.1875f, 0.25f, 0.625f, -2.5E-5, -2.5E-5, 1.0E-4);
            this.renderQuad(type, t, iicon, 0.25f, 0.25f, 0.125f, 0.125f, -2.5E-5, -2.5E-5, 1.0E-4);
            this.renderQuad(type, t, iicon, 0.625f, 0.25f, 0.125f, 0.125f, -2.5E-5, -2.5E-5, 1.0E-4);
        }
        FMLClientHandler.instance().getClient().field_71446_o.func_110577_a(TextureMap.field_110576_c);
        GL11.glEnable((int)3042);
        iicon = ((ItemEnderBucket)itemStack.func_77973_b()).getIconPart(0);
        this.renderQuad(type, t, iicon, 0.0f, 0.0f, 1.0f, 1.0f, 0.0, 0.0, 0.0);
        iicon = ((ItemEnderBucket)itemStack.func_77973_b()).getIconPart(1);
        float scale = 1.0f - (float)amount / (float)EUConfigs.enderBucketCapacity.getInt(16000);
        this.renderQuad(type, t, iicon, 0.375f, 0.5625f, 0.25f, scale * 0.25f, 0.0, 0.0, 5.0E-5);
        iicon = ((ItemEnderBucket)itemStack.func_77973_b()).getIconPart(2);
        this.renderQuad(type, t, iicon, 0.25f, 0.1875f, 0.5f, scale * 0.25f, 0.0, 0.0, 5.0E-5);
        GL11.glDisable((int)3042);
        GL11.glEnable((int)2896);
        switch (type) {
            case INVENTORY: {
                break;
            }
            default: {
                GL11.glDisable((int)32826);
            }
        }
        GL11.glPopMatrix();
    }

    private void renderQuad(IItemRenderer.ItemRenderType type, Tessellator t, IIcon iicon, float minX, float minY, float relWidth, float relHeight, double layerShrinkX, double layerShrinkY, double layerShrinkZ) {
        int width = (int)(relWidth * (float)iicon.func_94211_a());
        int height = (int)(relHeight * (float)iicon.func_94216_b());
        float minU = iicon.func_94209_e();
        float maxU = iicon.func_94212_f();
        float minV = iicon.func_94206_g();
        float maxV = iicon.func_94210_h();
        float lenU = maxU - minU;
        float lenV = maxV - minV;
        float startU = minX * lenU + minU;
        float endU = relWidth * lenU + startU;
        float startV = minY * lenV + minV;
        float endV = relHeight * lenV + startV;
        GL11.glPushMatrix();
        switch (type) {
            case EQUIPPED_FIRST_PERSON: {
                GL11.glTranslatef((float)0.0f, (float)0.25f, (float)0.0f);
                GL11.glRotatef((float)30.0f, (float)0.0f, (float)1.0f, (float)0.0f);
                GL11.glScalef((float)0.7f, (float)0.7f, (float)0.7f);
                GL11.glTranslatef((float)0.0f, (float)0.02f, (float)0.0f);
            }
            case EQUIPPED: {
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)-1.0f, (float)-1.0f, (float)0.0f);
                break;
            }
            case ENTITY: {
                GL11.glTranslatef((float)-0.5f, (float)-0.25f, (float)0.0f);
                GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
                GL11.glTranslatef((float)-1.0f, (float)-1.0f, (float)0.0f);
                GL11.glDisable((int)3042);
                GL11.glEnable((int)2896);
                break;
            }
            case INVENTORY: {
                layerShrinkZ = -layerShrinkZ;
                GL11.glScalef((float)16.0f, (float)16.0f, (float)1.0f);
                break;
            }
        }
        ItemRenderer.renderItemLayerIn2D(t, width, height, 0.0625f, minX, minY, minX + relWidth, minY + relHeight, startU, startV, endU, endV, layerShrinkX, layerShrinkY, layerShrinkZ);
        GL11.glPopMatrix();
    }
}

