/*
 * Decompiled with CFR 0.152.
 */
package kihira.foxlib.client.toast;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kihira.foxlib.client.toast.Toast;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.profiler.Profiler;
import net.minecraftforge.client.event.GuiScreenEvent;
import net.minecraftforge.client.event.MouseEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.MinecraftForge;

public class ToastManager {
    public static final ToastManager INSTANCE = new ToastManager();
    private final ArrayList<Toast> toasts = new ArrayList();

    private ToastManager() {
        FMLCommonHandler.instance().bus().register((Object)this);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    public void createToast(int x, int y, String text) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int stringWidth = fontRenderer.func_78256_a(text);
        this.toasts.add(new Toast(x, y, stringWidth + 10, stringWidth * 3, text));
    }

    public void createCenteredToast(int x, int y, int maxWidth, String text) {
        FontRenderer fontRenderer = Minecraft.func_71410_x().field_71466_p;
        int stringWidth = fontRenderer.func_78256_a(text);
        if (stringWidth > maxWidth) {
            List strings = fontRenderer.func_78271_c(text, maxWidth);
            this.toasts.add(new Toast(x - maxWidth / 2 - 5, y, maxWidth + 10, maxWidth * 2, strings.toArray(new String[strings.size()])));
        } else {
            this.toasts.add(new Toast(x - stringWidth / 2 - 5, y, stringWidth + 10, stringWidth * 4, text));
        }
    }

    @SubscribeEvent
    public void onMouseEvent(MouseEvent event) {
        for (Toast toast : this.toasts) {
            if (!toast.mouseOver) continue;
            toast.onMouseEvent(event);
        }
    }

    @SubscribeEvent
    public void onClientTickPost(TickEvent.ClientTickEvent event) {
        Iterator<Toast> toasts = this.toasts.iterator();
        while (toasts.hasNext()) {
            Toast toast = toasts.next();
            --toast.time;
            if (toast.time > 0) continue;
            toasts.remove();
        }
    }

    @SubscribeEvent
    public void onDrawScreenPost(GuiScreenEvent.DrawScreenEvent.Post event) {
        Profiler profiler = Minecraft.func_71410_x().field_71424_I;
        profiler.func_76320_a("toastNotification");
        for (Toast toast : this.toasts) {
            toast.drawToast(event.mouseX, event.mouseY);
        }
        profiler.func_76319_b();
    }

    @SubscribeEvent
    public void onRenderGameOverlay(RenderGameOverlayEvent.Post event) {
        if (event.type == RenderGameOverlayEvent.ElementType.HOTBAR) {
            Profiler profiler = Minecraft.func_71410_x().field_71424_I;
            profiler.func_76320_a("toastNotification");
            for (Toast toast : this.toasts) {
                toast.drawToast(event.mouseX, event.mouseY);
            }
            profiler.func_76319_b();
        }
    }
}

