/*
 * Decompiled with CFR 0.152.
 */
package com.foodplus.blocks.microwave;

import com.foodplus.core.FoodPlusItems;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class MicrowaveRecipeManager {
    private static final MicrowaveRecipeManager smeltingBase = new MicrowaveRecipeManager();
    private Map smeltingList = new HashMap();
    private Map experienceList = new HashMap();
    private HashMap<List<Integer>, ItemStack> metaSmeltingList = new HashMap();
    private HashMap<List<Integer>, Float> metaExperience = new HashMap();

    public static final MicrowaveRecipeManager smelting() {
        return smeltingBase;
    }

    private MicrowaveRecipeManager() {
        this.addRecipie(FoodPlusItems.HotChocolate, new ItemStack(FoodPlusItems.HotChocolateFinal, 1), 0.1f);
        this.addRecipie(FoodPlusItems.Sugar, new ItemStack(FoodPlusItems.Caramel, 1), 0.1f);
        this.addRecipie(Items.field_151078_bh, new ItemStack(FoodPlusItems.CookedFlesh, 1), 0.1f);
    }

    public void addRecipie(Item item, ItemStack itemstack, float experience) {
        this.addLists(item, itemstack, experience);
    }

    public void addLists(Item item, ItemStack itemstack, float experience) {
        this.putLists(new ItemStack(item, 1, Short.MAX_VALUE), itemstack, experience);
    }

    public void putLists(ItemStack itemstack, ItemStack itemstack2, float experience) {
        this.smeltingList.put(itemstack, itemstack2);
        this.experienceList.put(itemstack2, Float.valueOf(experience));
    }

    @Deprecated
    public ItemStack getSmeltingResult(int par1) {
        return (ItemStack)this.smeltingList.get(par1);
    }

    public Map getSmeltingList() {
        return this.smeltingList;
    }

    @Deprecated
    public float getExperience(int par1) {
        return this.experienceList.containsKey(par1) ? ((Float)this.experienceList.get(par1)).floatValue() : 0.0f;
    }

    public void addSmelting(int itemID, int metadata, ItemStack itemstack, float experience) {
        this.metaSmeltingList.put(Arrays.asList(itemID, metadata), itemstack);
        this.metaExperience.put(Arrays.asList(itemID, metadata), Float.valueOf(experience));
    }

    public ItemStack getSmeltingResult(ItemStack itemstack) {
        Map.Entry entry;
        Iterator iterator = this.smeltingList.entrySet().iterator();
        do {
            if (iterator.hasNext()) continue;
            return null;
        } while (!this.canBeSmelted(itemstack, (ItemStack)(entry = iterator.next()).getKey()));
        return (ItemStack)entry.getValue();
    }

    private boolean canBeSmelted(ItemStack itemstack, ItemStack itemstack2) {
        return itemstack2.func_77973_b() == itemstack.func_77973_b() && (itemstack2.func_77960_j() == Short.MAX_VALUE || itemstack2.func_77960_j() == itemstack.func_77960_j());
    }

    public float giveExperience(ItemStack itemstack) {
        Map.Entry entry;
        Iterator iterator = this.experienceList.entrySet().iterator();
        do {
            if (iterator.hasNext()) continue;
            return 0.0f;
        } while (!this.canBeSmelted(itemstack, (ItemStack)(entry = iterator.next()).getKey()));
        if (itemstack.func_77973_b().getSmeltingExperience(itemstack) != -1.0f) {
            return itemstack.func_77973_b().getSmeltingExperience(itemstack);
        }
        return ((Float)entry.getValue()).floatValue();
    }

    public Map<List<Integer>, ItemStack> getMetaSmeltingList() {
        return this.metaSmeltingList;
    }
}

