/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine;

import binnie.botany.Botany;
import binnie.core.BinnieCore;
import binnie.core.machines.IMachine;
import binnie.core.machines.IMachineType;
import binnie.core.machines.Machine;
import binnie.core.machines.MachineComponent;
import binnie.core.machines.MachinePackage;
import binnie.core.machines.component.IInteraction;
import binnie.core.machines.network.INetwork;
import binnie.extrabees.ExtraBees;
import binnie.extratrees.ExtraTrees;
import binnie.genetics.Genetics;
import binnie.genetics.core.GeneticsTexture;
import binnie.genetics.machine.Acclimatiser;
import binnie.genetics.machine.Analyser;
import binnie.genetics.machine.Genepool;
import binnie.genetics.machine.GeneticMachine;
import binnie.genetics.machine.Incubator;
import binnie.genetics.machine.MachineRendererLab;
import buildcraft.api.tools.IToolWrench;
import java.util.ArrayList;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public enum LaboratoryMachine implements IMachineType
{
    LabMachine(PackageLabMachine.class),
    Analyser(Analyser.PackageAnalyser.class),
    Incubator(Incubator.PackageIncubator.class),
    Genepool(Genepool.PackageGenepool.class),
    Acclimatiser(Acclimatiser.PackageAcclimatiser.class);

    Class<? extends MachinePackage> clss;

    private LaboratoryMachine(Class<? extends MachinePackage> clss) {
        this.clss = clss;
    }

    @Override
    public Class<? extends MachinePackage> getPackageClass() {
        return this.clss;
    }

    @Override
    public boolean isActive() {
        return true;
    }

    public ItemStack get(int i) {
        return new ItemStack((Block)Genetics.packageLabMachine.getBlock(), i, this.ordinal());
    }

    public static class ComponentGUIHolder
    extends MachineComponent
    implements INetwork.TilePacketSync,
    IInteraction.RightClick {
        private ItemStack stack;

        public ComponentGUIHolder(IMachine machine) {
            super(machine);
        }

        public ItemStack getStack() {
            return this.stack;
        }

        @Override
        public void readFromNBT(NBTTagCompound nbttagcompound) {
            super.readFromNBT(nbttagcompound);
            if (nbttagcompound == null) {
                return;
            }
            this.stack = ItemStack.func_77949_a((NBTTagCompound)nbttagcompound.func_74775_l("Item"));
        }

        @Override
        public void writeToNBT(NBTTagCompound nbttagcompound) {
            super.writeToNBT(nbttagcompound);
            NBTTagCompound nbt = new NBTTagCompound();
            if (this.stack != null) {
                this.stack.func_77955_b(nbt);
            }
            nbttagcompound.func_74782_a("Item", (NBTBase)nbt);
        }

        @Override
        public void syncToNBT(NBTTagCompound nbt) {
            this.writeToNBT(nbt);
        }

        @Override
        public void syncFromNBT(NBTTagCompound nbt) {
            this.readFromNBT(nbt);
        }

        @Override
        public void onDestruction() {
            super.onDestruction();
            if (this.stack != null) {
                float f = this.getMachine().getWorld().field_73012_v.nextFloat() * 0.8f + 0.1f;
                float f1 = this.getMachine().getWorld().field_73012_v.nextFloat() * 0.8f + 0.1f;
                float f2 = this.getMachine().getWorld().field_73012_v.nextFloat() * 0.8f + 0.1f;
                if (this.stack.field_77994_a == 0) {
                    this.stack.field_77994_a = 1;
                }
                EntityItem entityitem = new EntityItem(this.getMachine().getWorld(), (double)((float)this.getMachine().getTileEntity().field_145851_c + f), (double)((float)this.getMachine().getTileEntity().field_145848_d + f1), (double)((float)this.getMachine().getTileEntity().field_145849_e + f2), this.stack.func_77946_l());
                float accel = 0.05f;
                entityitem.field_70159_w = (float)this.getMachine().getWorld().field_73012_v.nextGaussian() * accel;
                entityitem.field_70181_x = (float)this.getMachine().getWorld().field_73012_v.nextGaussian() * accel + 0.2f;
                entityitem.field_70179_y = (float)this.getMachine().getWorld().field_73012_v.nextGaussian() * accel;
                this.getMachine().getWorld().func_72838_d((Entity)entityitem);
            }
        }

        @Override
        public void onRightClick(World world, EntityPlayer player, int x, int y, int z) {
            if (BinnieCore.proxy.isSimulating(world) && player.func_70694_bm() != null) {
                if (this.stack != null && player.func_70694_bm().func_77973_b() instanceof IToolWrench) {
                    float f = 0.7f;
                    double d0 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    double d1 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    double d2 = (double)(world.field_73012_v.nextFloat() * f) + (double)(1.0f - f) * 0.5;
                    EntityItem entityitem = new EntityItem(world, (double)x + d0, (double)y + d1, (double)z + d2, this.stack);
                    entityitem.field_145804_b = 10;
                    world.func_72838_d((Entity)entityitem);
                    this.stack = null;
                    ((IToolWrench)player.func_70694_bm().func_77973_b()).wrenchUsed(player, x, y, z);
                    this.getUtil().refreshBlock();
                    return;
                }
                ArrayList<Item> validSelections = new ArrayList<Item>();
                if (BinnieCore.isBotanyActive()) {
                    validSelections.add(Botany.database);
                }
                if (BinnieCore.isExtraBeesActive()) {
                    validSelections.add(ExtraBees.dictionary);
                }
                if (BinnieCore.isExtraTreesActive()) {
                    validSelections.add(ExtraTrees.itemDictionary);
                }
                if (BinnieCore.isLepidopteryActive()) {
                    validSelections.add(ExtraTrees.itemDictionaryLepi);
                }
                validSelections.add(Genetics.database);
                if (this.stack == null && validSelections.contains(player.func_70694_bm().func_77973_b())) {
                    this.stack = player.func_70694_bm().func_77946_l();
                    --player.func_70694_bm().field_77994_a;
                    world.func_147471_g(x, y, z);
                    return;
                }
                if (this.stack != null && player.func_70694_bm().func_77973_b() instanceof IToolWrench) {
                    this.stack.func_77973_b().func_77659_a(this.stack, world, player);
                }
            }
            if (this.stack != null) {
                this.stack.func_77973_b().func_77659_a(this.stack, world, player);
            }
        }
    }

    public static class PackageLabMachine
    extends GeneticMachine.PackageGeneticBase {
        public PackageLabMachine() {
            super("labMachine", GeneticsTexture.LabMachine, 0xFFFFFF, false);
        }

        @Override
        public void createMachine(Machine machine) {
            new ComponentGUIHolder(machine);
        }

        @Override
        public void renderMachine(Machine machine, double x, double y, double z, float var8, RenderBlocks renderer) {
            MachineRendererLab.instance.renderMachine(machine, this.colour, this.renderTexture, x, y, z, var8);
        }
    }
}

