/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine;

import binnie.core.BinnieCore;
import binnie.core.machines.IMachine;
import binnie.core.machines.Machine;
import binnie.core.machines.MachineComponent;
import binnie.core.machines.TileEntityMachine;
import binnie.core.machines.component.IRender;
import binnie.core.machines.inventory.ComponentChargedSlots;
import binnie.core.machines.inventory.ComponentInventorySlots;
import binnie.core.machines.inventory.ComponentInventoryTransfer;
import binnie.core.machines.inventory.ComponentTankContainer;
import binnie.core.machines.inventory.IChargedSlots;
import binnie.core.machines.inventory.InventorySlot;
import binnie.core.machines.inventory.SlotValidator;
import binnie.core.machines.inventory.TankValidator;
import binnie.core.machines.power.ComponentPowerReceptor;
import binnie.core.machines.power.ComponentProcess;
import binnie.core.machines.power.ErrorState;
import binnie.core.machines.power.IProcess;
import binnie.craftgui.minecraft.IMachineInformation;
import binnie.genetics.core.GeneticsGUI;
import binnie.genetics.core.GeneticsTexture;
import binnie.genetics.genetics.Gene;
import binnie.genetics.item.GeneticsItems;
import binnie.genetics.item.ItemSequence;
import binnie.genetics.machine.ComponentGeneticGUI;
import binnie.genetics.machine.GeneticMachine;
import binnie.genetics.machine.ModuleMachine;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import java.util.Random;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;

public class Isolator {
    public static final int slotEnzyme = 0;
    public static final int slotSequencerVial = 1;
    public static final int[] slotReserve = new int[]{2, 3, 4};
    public static final int slotTarget = 5;
    public static final int slotResult = 6;
    public static final int[] slotFinished = new int[]{7, 8, 9, 10, 11, 12};
    public static final int tankEthanol = 0;

    public static class ComponentIsolaterFX
    extends MachineComponent
    implements IRender.RandomDisplayTick,
    IRender.DisplayTick {
        public ComponentIsolaterFX(IMachine machine) {
            super(machine);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void onRandomDisplayTick(World world, int x, int y, int z, Random rand) {
            if (!this.getUtil().getProcess().isInProgress()) {
                return;
            }
            BinnieCore.proxy.getMinecraftInstance().field_71452_i.func_78873_a(new EntityFX(world, (double)x + 0.4 + 0.2 * rand.nextDouble(), (double)y + 1.6, (double)z + 0.4 + rand.nextDouble() * 0.2, 0.0, 0.0, 0.0){
                double axisX;
                double axisZ;
                double angle;
                {
                    this.axisX = 0.0;
                    this.axisZ = 0.0;
                    this.angle = 0.0;
                    this.field_70159_w = 0.0;
                    this.field_70179_y = 0.0;
                    this.field_70181_x = -0.012;
                    this.field_70547_e = 100;
                    this.field_70545_g = 0.0f;
                    this.field_70145_X = true;
                    this.func_70538_b(0.8f, 0.4f, 0.0f);
                }

                public void func_70071_h_() {
                    super.func_70071_h_();
                    this.angle += 0.06;
                    this.func_82338_g((float)Math.sin(3.14 * (double)this.field_70546_d / (double)this.field_70547_e));
                }

                public int func_70537_b() {
                    return 0;
                }
            });
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void onDisplayTick(World world, int x, int y, int z, Random rand) {
            int tick = (int)(world.func_82737_E() % 6L);
            if ((tick == 0 || tick == 5) && this.getUtil().getProcess().isInProgress()) {
                BinnieCore.proxy.getMinecraftInstance().field_71452_i.func_78873_a(new EntityFX(world, (double)x + 0.5, y + 1, (double)z + 0.5, 0.0, 0.0, 0.0){
                    double axisX;
                    double axisZ;
                    double angle;
                    {
                        this.axisX = 0.0;
                        this.axisZ = 0.0;
                        this.angle = 0.0;
                        this.field_70159_w = 0.0;
                        this.field_70179_y = 0.0;
                        this.field_70181_x = 0.012;
                        this.field_70547_e = 100;
                        this.axisX = this.field_70165_t;
                        this.axisZ = this.field_70161_v;
                        this.field_70545_g = 0.0f;
                        this.angle = 0.7 + (double)((int)(this.field_70170_p.func_82737_E() % 2L)) * 3.1415;
                        this.field_70145_X = true;
                        this.func_70538_b(0.8f, 0.0f, 1.0f);
                    }

                    public void func_70071_h_() {
                        super.func_70071_h_();
                        this.angle += 0.06;
                        this.func_70107_b(this.axisX + 0.26 * Math.sin(this.angle), this.field_70163_u, this.axisZ + 0.26 * Math.cos(this.angle));
                        this.func_82338_g((float)Math.cos(1.57 * (double)this.field_70546_d / (double)this.field_70547_e));
                    }

                    public int func_70537_b() {
                        return 0;
                    }
                });
            }
        }
    }

    public static class ComponentExtractorLogic
    extends ComponentProcess
    implements IProcess {
        float enzymePerProcess = 0.5f;
        float ethanolPerProcess = 10.0f;

        public ComponentExtractorLogic(Machine machine) {
            super(machine, 19200, 4800);
        }

        @Override
        public ErrorState canWork() {
            if (this.getUtil().isSlotEmpty(5)) {
                return new ErrorState.NoItem("No individual to isolate", 5);
            }
            if (!this.getUtil().isSlotEmpty(6)) {
                return new ErrorState.NoSpace("No room for DNA sequences", slotFinished);
            }
            if (this.getUtil().isSlotEmpty(1)) {
                return new ErrorState.NoItem("No empty sequencer vials", 1);
            }
            return super.canWork();
        }

        @Override
        public ErrorState canProgress() {
            if (!this.getUtil().liquidInTank(0, (int)this.ethanolPerProcess)) {
                return new ErrorState.InsufficientLiquid("Insufficient ethanol", 0);
            }
            if (this.getUtil().getSlotCharge(0) == 0.0f) {
                return new ErrorState.NoItem("No enzyme", 0);
            }
            return super.canProgress();
        }

        @Override
        protected void onFinishTask() {
            super.onFinishTask();
            Random rand = this.getMachine().getWorld().field_73012_v;
            ISpeciesRoot root = AlleleManager.alleleRegistry.getSpeciesRoot(this.getUtil().getStack(5));
            if (root == null) {
                return;
            }
            IIndividual individual = root.getMember(this.getUtil().getStack(5));
            if (individual == null) {
                return;
            }
            IAllele allele = null;
            IChromosomeType chromosome = null;
            int chromosomeID = 0;
            Gene gene = null;
            if (this.getMachine().getWorld().field_73012_v.nextFloat() < 2.0f) {
                while (gene == null) {
                    try {
                        chromosomeID = root.getKaryotype()[rand.nextInt(root.getKaryotype().length)].ordinal();
                        allele = rand.nextBoolean() ? individual.getGenome().getActiveAllele(chromosomeID) : individual.getGenome().getInactiveAllele(chromosomeID);
                        chromosome = root.getKaryotype()[chromosomeID];
                        gene = Gene.create(allele, chromosome, root);
                    }
                    catch (Exception e) {}
                }
            }
            ItemStack serum = ItemSequence.create(gene);
            this.getUtil().setStack(6, serum);
            this.getUtil().decreaseStack(1, 1);
            if (rand.nextFloat() < 0.05f) {
                this.getUtil().decreaseStack(5, 1);
            }
            this.getUtil().drainTank(0, (int)this.ethanolPerProcess);
        }

        @Override
        protected void onTickTask() {
            this.getMachine().getInterface(IChargedSlots.class).alterCharge(0, -this.enzymePerProcess * this.getProgressPerTick() / 100.0f);
        }
    }

    public static class PackageIsolator
    extends GeneticMachine.PackageGeneticBase
    implements IMachineInformation {
        public PackageIsolator() {
            super("isolator", GeneticsTexture.Isolator, 0xFF6F0F, true);
        }

        @Override
        public void createMachine(Machine machine) {
            new ComponentGeneticGUI(machine, GeneticsGUI.Isolator);
            ComponentInventorySlots inventory = new ComponentInventorySlots(machine);
            inventory.addSlot(0, "Enzyme Slot");
            inventory.getSlot(0).setValidator(new SlotValidator.Item(GeneticsItems.Enzyme.get(1), ModuleMachine.IconEnzyme));
            inventory.getSlot(0).forbidExtraction();
            inventory.addSlot(1, "Sequencer Vial Slot");
            inventory.getSlot(1).setValidator(new SlotValidator.Item(GeneticsItems.EmptySequencer.get(1), ModuleMachine.IconSequencer));
            inventory.getSlot(1).forbidExtraction();
            inventory.addSlotArray(slotReserve, InventorySlot.NameInput);
            for (InventorySlot slot : inventory.getSlots(slotReserve)) {
                slot.setValidator(new SlotValidator.Individual());
                slot.forbidExtraction();
            }
            inventory.addSlot(5, InventorySlot.NameProcess);
            inventory.getSlot(5).setValidator(new SlotValidator.Individual());
            inventory.getSlot(5).setReadOnly();
            inventory.getSlot(5).forbidInteraction();
            inventory.addSlot(6, InventorySlot.NameOutput);
            inventory.getSlot(6).setReadOnly();
            inventory.getSlot(6).forbidInteraction();
            inventory.addSlotArray(slotFinished, InventorySlot.NameOutput);
            for (InventorySlot slot : inventory.getSlots(slotFinished)) {
                slot.setReadOnly();
                slot.forbidInsertion();
            }
            ComponentTankContainer tanks = new ComponentTankContainer(machine);
            tanks.addTank(0, "Ethanol Tank", 1000);
            tanks.getTankSlot(0).setValidator(new TankValidator(){

                @Override
                public String getTooltip() {
                    return "Ethanol";
                }

                @Override
                public boolean isValid(FluidStack stack) {
                    return stack.getFluid().getName() == "bioethanol";
                }
            });
            ComponentChargedSlots chargedSlots = new ComponentChargedSlots(machine);
            chargedSlots.addCharge(0);
            ComponentInventoryTransfer transfer = new ComponentInventoryTransfer(machine);
            transfer.addRestock(slotReserve, 5, 1);
            transfer.addStorage(6, slotFinished);
            new ComponentPowerReceptor(machine, 20000);
            new ComponentExtractorLogic(machine);
            new ComponentIsolaterFX(machine);
        }

        @Override
        public TileEntity createTileEntity() {
            return new TileEntityMachine(this);
        }

        @Override
        public void register() {
        }
    }
}

