/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine;

import binnie.Binnie;
import binnie.core.BinnieCore;
import binnie.core.machines.IMachine;
import binnie.core.machines.Machine;
import binnie.core.machines.MachineComponent;
import binnie.core.machines.TileEntityMachine;
import binnie.core.machines.component.IRender;
import binnie.core.machines.inventory.ComponentInventorySlots;
import binnie.core.machines.inventory.ComponentInventoryTransfer;
import binnie.core.machines.inventory.ComponentTankContainer;
import binnie.core.machines.inventory.InventorySlot;
import binnie.core.machines.inventory.SlotValidator;
import binnie.core.machines.inventory.Validator;
import binnie.core.machines.network.INetwork;
import binnie.core.machines.power.ComponentPowerReceptor;
import binnie.core.machines.power.ComponentProcess;
import binnie.core.machines.power.ErrorState;
import binnie.core.machines.power.IProcess;
import binnie.craftgui.minecraft.IMachineInformation;
import binnie.genetics.api.IGene;
import binnie.genetics.api.IItemSerum;
import binnie.genetics.core.GeneticsGUI;
import binnie.genetics.core.GeneticsTexture;
import binnie.genetics.genetics.Engineering;
import binnie.genetics.item.GeneticLiquid;
import binnie.genetics.machine.ComponentGeneticGUI;
import binnie.genetics.machine.GeneticMachine;
import binnie.genetics.machine.ModuleMachine;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IBeeRoot;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import java.util.Random;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class Inoculator {
    public static final int slotSerumVial = 0;
    public static final int[] slotSerumReserve = new int[]{1, 2};
    public static final int[] slotSerumExpended = new int[]{3, 4};
    public static final int[] slotReserve = new int[]{5, 6, 7, 8};
    public static final int slotTarget = 9;
    public static final int[] slotFinished = new int[]{10, 11, 12, 13};
    public static final int tankVector = 0;

    public static void setGene(IGene gene, ItemStack target, int chromoN) {
        Class cls;
        int chromosome = gene.getChromosome().ordinal();
        int chromosomeID = chromosome;
        if (chromosomeID >= EnumBeeChromosome.HUMIDITY.ordinal() && gene.getSpeciesRoot() instanceof IBeeRoot) {
            --chromosomeID;
        }
        if (!(cls = gene.getChromosome().getAlleleClass()).isInstance(gene.getAllele())) {
            return;
        }
        NBTTagCompound beeNBT = target.func_77978_p();
        NBTTagCompound genomeNBT = beeNBT.func_74775_l("Genome");
        NBTTagList chromosomes = genomeNBT.func_150295_c("Chromosomes", 10);
        NBTTagCompound chromosomeNBT = chromosomes.func_150305_b(chromosomeID);
        chromosomeNBT.func_74778_a("UID" + chromoN, gene.getAllele().getUID());
        target.func_77982_d(beeNBT);
    }

    public static class ValidatorIndividualInoculate
    extends SlotValidator {
        public ValidatorIndividualInoculate() {
            super(null);
        }

        @Override
        public boolean isValid(ItemStack object) {
            ISpeciesRoot root = AlleleManager.alleleRegistry.getSpeciesRoot(object);
            if (root == null) {
                return false;
            }
            return Binnie.Genetics.getSystem(root).isDNAManipulable(object);
        }

        @Override
        public String getTooltip() {
            return "Inoculable Individual";
        }
    }

    public static class ComponentInoculatorFX
    extends MachineComponent
    implements IRender.RandomDisplayTick,
    IRender.DisplayTick,
    IRender.Render,
    INetwork.TilePacketSync {
        private final EntityItem dummyEntityItem = new EntityItem(null);

        public ComponentInoculatorFX(IMachine machine) {
            super(machine);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void onRandomDisplayTick(World world, int x, int y, int z, Random rand) {
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void onDisplayTick(World world, int x, int y, int z, Random rand) {
            int tick = (int)(world.func_82737_E() % 3L);
            if (tick == 0 && this.getUtil().getProcess().isInProgress()) {
                BinnieCore.proxy.getMinecraftInstance().field_71452_i.func_78873_a(new EntityFX(world, (double)x + 0.5, (double)y + 0.92, (double)z + 0.5, 0.0, 0.0, 0.0){
                    double axisX;
                    double axisZ;
                    double angle;
                    {
                        this.axisX = 0.0;
                        this.axisZ = 0.0;
                        this.angle = 0.0;
                        this.field_70159_w = 0.0;
                        this.field_70179_y = 0.0;
                        this.field_70181_x = 0.007 + this.field_70146_Z.nextDouble() * 0.002;
                        this.field_70547_e = 240;
                        this.axisX = this.field_70165_t;
                        this.axisZ = this.field_70161_v;
                        this.field_70545_g = 0.0f;
                        this.angle = (double)((int)(this.field_70170_p.func_82737_E() % 4L)) * 0.5 * 3.1415;
                        this.field_70145_X = true;
                        this.func_70538_b(0.8f, 0.0f, 1.0f);
                    }

                    public void func_70071_h_() {
                        super.func_70071_h_();
                        double speed = 5.0E-4;
                        if (this.field_70546_d > 60) {
                            speed += (double)((float)(this.field_70546_d - 60) / 4000.0f);
                        }
                        this.angle += speed;
                        double dist = 0.27;
                        this.func_70107_b(this.axisX + dist * Math.sin(this.angle), this.field_70163_u, this.axisZ + dist * Math.cos(this.angle));
                        this.func_82338_g((float)Math.cos(1.57 * (double)this.field_70546_d / (double)this.field_70547_e));
                        if (this.field_70546_d > 40) {
                            this.func_70538_b(this.field_70552_h + (1.0f - this.field_70552_h) / 10.0f, this.field_70553_i + (0.0f - this.field_70553_i) / 10.0f, this.field_70551_j + (0.0f - this.field_70551_j) / 10.0f);
                        }
                    }

                    public int func_70537_b() {
                        return 0;
                    }
                });
            }
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void renderInWorld(RenderItem customRenderItem, double x, double y, double z) {
            if (!this.getUtil().getProcess().isInProgress()) {
                return;
            }
            ItemStack stack = this.getUtil().getStack(9);
            this.dummyEntityItem.field_70170_p = this.getMachine().getWorld();
            this.dummyEntityItem.func_92058_a(stack);
            ++this.dummyEntityItem.field_70292_b;
            this.dummyEntityItem.field_70290_d = 0.0f;
            if (stack == null) {
                return;
            }
            EntityPlayer player = BinnieCore.proxy.getPlayer();
            double dx = x + 0.5 - player.field_70142_S;
            double dz = z + 0.5 - player.field_70136_U;
            double t = Math.atan2(dz, dx) * 180.0 / 3.1415;
            GL11.glPushMatrix();
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)0.0f, (float)-0.25f, (float)0.0f);
            customRenderItem.func_76986_a(this.dummyEntityItem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
            GL11.glPopMatrix();
        }

        @Override
        public void syncToNBT(NBTTagCompound nbt) {
            NBTTagCompound item = new NBTTagCompound();
            ItemStack stack = this.getUtil().getStack(9);
            if (stack != null) {
                stack.func_77955_b(item);
                nbt.func_74782_a("item", (NBTBase)item);
            }
        }

        @Override
        public void syncFromNBT(NBTTagCompound nbt) {
            if (nbt.func_74764_b("item")) {
                this.getUtil().setStack(9, ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("item")));
            } else {
                this.getUtil().setStack(9, null);
            }
        }

        @Override
        public void onInventoryUpdate() {
            this.getUtil().refreshBlock();
        }
    }

    public static class ComponentInoculatorLogic
    extends ComponentProcess
    implements IProcess {
        private float bacteriaDrain = 0.0f;

        @Override
        public int getProcessLength() {
            return super.getProcessLength() * this.getNumberOfGenes();
        }

        @Override
        public int getProcessEnergy() {
            return super.getProcessEnergy() * this.getNumberOfGenes();
        }

        private int getNumberOfGenes() {
            ItemStack serum = this.getUtil().getStack(0);
            if (serum == null) {
                return 1;
            }
            return Engineering.getGenes(serum).length;
        }

        @Override
        public String getTooltip() {
            int n = this.getNumberOfGenes();
            return "Inoculating with " + n + " gene" + (n > 1 ? "s" : "");
        }

        public ComponentInoculatorLogic(Machine machine) {
            super(machine, 30000, 12000);
        }

        @Override
        public ErrorState canWork() {
            if (this.getUtil().isSlotEmpty(9)) {
                return new ErrorState.NoItem("No Individual to Inoculate", 9);
            }
            if (this.getUtil().isSlotEmpty(0)) {
                return new ErrorState.NoItem("No Serum", 0);
            }
            ErrorState state = this.isValidSerum();
            if (state != null) {
                return state;
            }
            if (this.getUtil().getStack(0) != null && Engineering.getCharges(this.getUtil().getStack(0)) == 0) {
                return new ErrorState("Empty Serum", "Serum is empty");
            }
            return super.canWork();
        }

        public ErrorState isValidSerum() {
            ItemStack serum = this.getUtil().getStack(0);
            ItemStack target = this.getUtil().getStack(9);
            IGene[] genes = Engineering.getGenes(serum);
            if (genes.length == 0) {
                return new ErrorState("Invalid Serum", "Serum does not hold any genes");
            }
            if (!genes[0].getSpeciesRoot().isMember(target)) {
                return new ErrorState("Invalid Serum", "Mismatch of Serum Type and Target");
            }
            IIndividual individual = genes[0].getSpeciesRoot().getMember(target);
            boolean hasAll = true;
            for (IGene gene : genes) {
                if (!hasAll) continue;
                IAllele a = individual.getGenome().getActiveAllele(gene.getChromosome().ordinal());
                IAllele b = individual.getGenome().getInactiveAllele(gene.getChromosome().ordinal());
                hasAll = hasAll && a.getUID().equals(gene.getAllele().getUID()) && b.getUID().equals(gene.getAllele().getUID());
            }
            if (hasAll) {
                return new ErrorState("Defunct Serum", "Individual already possesses this allele");
            }
            return null;
        }

        @Override
        public ErrorState canProgress() {
            return super.canProgress();
        }

        @Override
        protected void onFinishTask() {
            IGene[] genes;
            super.onFinishTask();
            ItemStack serum = this.getUtil().getStack(0);
            ItemStack target = this.getUtil().getStack(9);
            IIndividual ind = AlleleManager.alleleRegistry.getIndividual(target);
            if (!ind.isAnalyzed()) {
                ind.analyze();
                NBTTagCompound nbttagcompound = new NBTTagCompound();
                ind.writeToNBT(nbttagcompound);
                target.func_77982_d(nbttagcompound);
            }
            for (IGene gene : genes = ((IItemSerum)serum.func_77973_b()).getGenes(serum)) {
                Inoculator.setGene(gene, target, 0);
                Inoculator.setGene(gene, target, 1);
            }
            this.getUtil().damageItem(0, 1);
        }

        @Override
        protected void onTickTask() {
            this.bacteriaDrain += 15.0f * this.getProgressPerTick() / 100.0f;
            if (this.bacteriaDrain >= 1.0f) {
                this.getUtil().drainTank(0, 1);
                this.bacteriaDrain -= 1.0f;
            }
        }
    }

    public static class PackageInoculator
    extends GeneticMachine.PackageGeneticBase
    implements IMachineInformation {
        public PackageInoculator() {
            super("inoculator", GeneticsTexture.Inoculator, 14819893, true);
        }

        @Override
        public void createMachine(Machine machine) {
            new ComponentGeneticGUI(machine, GeneticsGUI.Inoculator);
            ComponentInventorySlots inventory = new ComponentInventorySlots(machine);
            inventory.addSlot(0, "Serum Slot");
            inventory.getSlot(0).forbidInteraction();
            inventory.getSlot(0).setReadOnly();
            SlotValidator serumValid = new SlotValidator(ModuleMachine.IconSerum){

                @Override
                public boolean isValid(ItemStack itemStack) {
                    return itemStack.func_77973_b() instanceof IItemSerum;
                }

                @Override
                public String getTooltip() {
                    return "Serum Vials & Arrays";
                }
            };
            inventory.getSlot(0).setValidator(serumValid);
            inventory.addSlotArray(slotSerumReserve, "Serum Quene");
            for (InventorySlot slot : inventory.getSlots(slotSerumReserve)) {
                slot.setValidator(serumValid);
                slot.forbidExtraction();
            }
            inventory.addSlotArray(slotSerumExpended, "Expended Serum Slot");
            for (InventorySlot slot : inventory.getSlots(slotSerumExpended)) {
                slot.setValidator(serumValid);
                slot.setReadOnly();
            }
            inventory.addSlotArray(slotReserve, InventorySlot.NameInput);
            for (InventorySlot slot : inventory.getSlots(slotReserve)) {
                slot.forbidExtraction();
                slot.setValidator(new ValidatorIndividualInoculate());
            }
            inventory.addSlot(9, InventorySlot.NameProcess);
            inventory.getSlot(9).setValidator(new ValidatorIndividualInoculate());
            inventory.getSlot(9).setReadOnly();
            inventory.getSlot(9).forbidInteraction();
            inventory.addSlotArray(slotFinished, InventorySlot.NameOutput);
            for (InventorySlot slot : inventory.getSlots(slotFinished)) {
                slot.setReadOnly();
                slot.forbidInsertion();
                slot.setValidator(new ValidatorIndividualInoculate());
            }
            ComponentInventoryTransfer transfer = new ComponentInventoryTransfer(machine);
            transfer.addRestock(slotReserve, 9, 1);
            transfer.addRestock(slotSerumReserve, 0);
            transfer.addStorage(0, slotSerumExpended, new ComponentInventoryTransfer.Condition(){

                @Override
                public boolean fufilled(ItemStack stack) {
                    return Engineering.getCharges(stack) == 0;
                }
            });
            transfer.addStorage(9, slotFinished, new ComponentInventoryTransfer.Condition(){

                @Override
                public boolean fufilled(ItemStack stack) {
                    return stack != null && this.transfer.getMachine().getMachineUtil().getStack(0) != null && this.transfer.getMachine().getInterface(ComponentInoculatorLogic.class).isValidSerum() != null;
                }
            });
            new ComponentPowerReceptor(machine, 15000);
            new ComponentInoculatorLogic(machine);
            new ComponentInoculatorFX(machine);
            new ComponentTankContainer(machine).addTank(0, "Bacteria Tank", 1000).setValidator(new Validator<FluidStack>(){

                @Override
                public boolean isValid(FluidStack object) {
                    return GeneticLiquid.BacteriaVector.get(1).isFluidEqual(object);
                }

                @Override
                public String getTooltip() {
                    return GeneticLiquid.BacteriaVector.getName();
                }
            });
        }

        @Override
        public TileEntity createTileEntity() {
            return new TileEntityMachine(this);
        }

        @Override
        public void register() {
        }
    }
}

