/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine;

import binnie.core.BinnieCore;
import binnie.core.machines.IMachine;
import binnie.core.machines.Machine;
import binnie.core.machines.MachineComponent;
import binnie.core.machines.TileEntityMachine;
import binnie.core.machines.component.IRender;
import binnie.core.machines.inventory.ComponentChargedSlots;
import binnie.core.machines.inventory.ComponentInventorySlots;
import binnie.core.machines.inventory.ComponentInventoryTransfer;
import binnie.core.machines.inventory.InventorySlot;
import binnie.core.machines.inventory.SlotValidator;
import binnie.core.machines.network.INetwork;
import binnie.core.machines.power.ComponentPowerReceptor;
import binnie.core.machines.power.ComponentProcess;
import binnie.core.machines.power.ErrorState;
import binnie.core.machines.power.IProcess;
import binnie.craftgui.minecraft.IMachineInformation;
import binnie.genetics.api.IItemAnalysable;
import binnie.genetics.core.GeneticsGUI;
import binnie.genetics.core.GeneticsTexture;
import binnie.genetics.item.GeneticsItems;
import binnie.genetics.machine.ComponentGeneticGUI;
import binnie.genetics.machine.GeneticMachine;
import binnie.genetics.machine.ModuleMachine;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import java.util.Random;
import net.minecraft.client.particle.EntityFX;
import net.minecraft.client.renderer.entity.RenderItem;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL11;

public class Analyser {
    public static final int[] slotReserve = new int[]{0, 1, 2, 3, 4, 5};
    public static final int slotTarget = 6;
    public static final int[] slotFinished = new int[]{7, 8, 9, 10, 11, 12};
    public static final int slotDye = 13;

    public static boolean isAnalysable(ItemStack stack) {
        IIndividual ind = AlleleManager.alleleRegistry.getIndividual(stack);
        if (ind != null) {
            return true;
        }
        return stack.func_77973_b() instanceof IItemAnalysable;
    }

    public static boolean isAnalysed(ItemStack stack) {
        IIndividual ind = AlleleManager.alleleRegistry.getIndividual(stack);
        if (ind != null) {
            return ind.isAnalyzed();
        }
        if (stack.func_77973_b() instanceof IItemAnalysable) {
            return ((IItemAnalysable)stack.func_77973_b()).isAnalysed(stack);
        }
        return false;
    }

    public static ItemStack analyse(ItemStack stack) {
        ISpeciesRoot root = AlleleManager.alleleRegistry.getSpeciesRoot(stack);
        if (root != null) {
            IIndividual ind = root.getMember(stack);
            ind.analyze();
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            ind.writeToNBT(nbttagcompound);
            stack.func_77982_d(nbttagcompound);
            return stack;
        }
        if (stack.func_77973_b() instanceof IItemAnalysable) {
            return ((IItemAnalysable)stack.func_77973_b()).analyse(stack);
        }
        return stack;
    }

    public static class ComponentAnalyserFX
    extends MachineComponent
    implements IRender.RandomDisplayTick,
    IRender.DisplayTick,
    IRender.Render,
    INetwork.TilePacketSync {
        private final EntityItem dummyEntityItem = new EntityItem(null);

        public ComponentAnalyserFX(IMachine machine) {
            super(machine);
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void onRandomDisplayTick(World world, int x, int y, int z, Random rand) {
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void onDisplayTick(World world, int x, int y, int z, Random rand) {
            if (rand.nextFloat() < 1.0f && this.getUtil().getProcess().isInProgress()) {
                BinnieCore.proxy.getMinecraftInstance().field_71452_i.func_78873_a(new EntityFX(world, (double)x + 0.5, (double)y + 1.3 + rand.nextDouble() * 0.2, (double)z + 0.5, 0.0, 0.0, 0.0){
                    double axisX;
                    double axisZ;
                    double angle;
                    {
                        this.axisX = 0.0;
                        this.axisZ = 0.0;
                        this.angle = 0.0;
                        this.field_70159_w = 0.05 * (this.field_70146_Z.nextDouble() - 0.5);
                        this.field_70179_y = 0.05 * (this.field_70146_Z.nextDouble() - 0.5);
                        this.field_70181_x = 0.0;
                        this.field_70547_e = 25;
                        this.axisX = this.field_70165_t;
                        this.axisZ = this.field_70161_v;
                        this.field_70545_g = 0.05f;
                        this.angle = this.field_70146_Z.nextDouble() * 2.0 * 3.1415;
                        this.field_70145_X = true;
                        this.func_70538_b(0.6f, 0.0f, 1.0f);
                    }

                    public void func_70071_h_() {
                        super.func_70071_h_();
                        this.func_82338_g((float)Math.cos(1.57 * (double)this.field_70546_d / (double)this.field_70547_e));
                    }

                    public int func_70537_b() {
                        return 0;
                    }
                });
            }
        }

        @Override
        @SideOnly(value=Side.CLIENT)
        public void renderInWorld(RenderItem customRenderItem, double x, double y, double z) {
            if (!this.getUtil().getProcess().isInProgress()) {
                return;
            }
            ItemStack stack = this.getUtil().getStack(6);
            this.dummyEntityItem.field_70170_p = this.getMachine().getWorld();
            this.dummyEntityItem.func_92058_a(stack);
            ++this.dummyEntityItem.field_70292_b;
            this.dummyEntityItem.field_70290_d = 0.0f;
            if (stack == null) {
                return;
            }
            EntityPlayer player = BinnieCore.proxy.getPlayer();
            double dx = x + 0.5 - player.field_70142_S;
            double dz = z + 0.5 - player.field_70136_U;
            double t = Math.atan2(dz, dx) * 180.0 / 3.1415;
            GL11.glPushMatrix();
            GL11.glRotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
            GL11.glTranslatef((float)0.0f, (float)-0.2f, (float)0.0f);
            customRenderItem.func_76986_a(this.dummyEntityItem, 0.0, 0.0, 0.0, 0.0f, 0.0f);
            GL11.glPopMatrix();
        }

        @Override
        public void syncToNBT(NBTTagCompound nbt) {
            NBTTagCompound item = new NBTTagCompound();
            ItemStack stack = this.getUtil().getStack(6);
            if (stack != null) {
                stack.func_77955_b(item);
                nbt.func_74782_a("item", (NBTBase)item);
            }
        }

        @Override
        public void syncFromNBT(NBTTagCompound nbt) {
            if (nbt.func_74764_b("item")) {
                this.getUtil().setStack(6, ItemStack.func_77949_a((NBTTagCompound)nbt.func_74775_l("item")));
            } else {
                this.getUtil().setStack(6, null);
            }
        }

        @Override
        public void onInventoryUpdate() {
            this.getMachine().getWorld().func_147471_g(this.getMachine().getTileEntity().field_145851_c, this.getMachine().getTileEntity().field_145848_d, this.getMachine().getTileEntity().field_145849_e);
        }
    }

    public static class SlotValidatorUnanalysed
    extends SlotValidator {
        public SlotValidatorUnanalysed() {
            super(null);
        }

        @Override
        public boolean isValid(ItemStack itemStack) {
            return Analyser.isAnalysable(itemStack) && !Analyser.isAnalysed(itemStack);
        }

        @Override
        public String getTooltip() {
            return "Unanalysed Item";
        }
    }

    public static class ComponentAnalyserLogic
    extends ComponentProcess
    implements IProcess {
        private static final float DYE_PER_TICK = 0.002f;

        public ComponentAnalyserLogic(Machine machine) {
            super(machine, 900, 300);
        }

        @Override
        public ErrorState canWork() {
            if (this.getUtil().isSlotEmpty(6)) {
                return new ErrorState.NoItem("No item to analyse", 6);
            }
            boolean analysed = Analyser.isAnalysed(this.getUtil().getStack(6));
            if (analysed) {
                return new ErrorState.InvalidItem("Already Analysed", "Item has already been analysed", 6);
            }
            return super.canWork();
        }

        @Override
        public ErrorState canProgress() {
            if (this.getUtil().getSlotCharge(13) == 0.0f) {
                return new ErrorState.Item("Insufficient Dye", "Not enough DNA dye to analyse", new int[]{13});
            }
            return super.canProgress();
        }

        @Override
        protected void onFinishTask() {
            super.onFinishTask();
            ItemStack itemStack = this.getUtil().getStack(6);
            itemStack = Analyser.analyse(itemStack);
            this.getInventory().func_70299_a(6, itemStack);
        }

        @Override
        protected void onTickTask() {
            this.getUtil().useCharge(13, 0.002f);
        }
    }

    public static class PackageAnalyser
    extends GeneticMachine.PackageGeneticBase
    implements IMachineInformation {
        public PackageAnalyser() {
            super("analyser", GeneticsTexture.Analyser, 9961727, true);
        }

        @Override
        public void createMachine(Machine machine) {
            new ComponentGeneticGUI(machine, GeneticsGUI.Analyser);
            ComponentInventorySlots inventory = new ComponentInventorySlots(machine);
            inventory.addSlotArray(slotReserve, "Input Slot");
            for (InventorySlot slot : inventory.getSlots(slotReserve)) {
                slot.setValidator(new SlotValidatorUnanalysed());
                slot.forbidExtraction();
            }
            inventory.addSlot(6, "Analyse Slot");
            inventory.getSlot(6).setValidator(new SlotValidatorUnanalysed());
            inventory.getSlot(6).setReadOnly();
            inventory.getSlot(6).forbidInteraction();
            inventory.addSlot(13, "Dye Slot");
            inventory.getSlot(13).forbidExtraction();
            inventory.getSlot(13).setValidator(new SlotValidator(ModuleMachine.IconDye){

                @Override
                public boolean isValid(ItemStack itemStack) {
                    return itemStack.func_77969_a(GeneticsItems.DNADye.get(1));
                }

                @Override
                public String getTooltip() {
                    return "DNA Dye";
                }
            });
            inventory.addSlotArray(slotFinished, "Output Slot");
            for (InventorySlot slot : inventory.getSlots(slotFinished)) {
                slot.forbidInsertion();
                slot.setReadOnly();
            }
            ComponentInventoryTransfer transfer = new ComponentInventoryTransfer(machine);
            transfer.addRestock(slotReserve, 6, 1);
            transfer.addStorage(6, slotFinished, new ComponentInventoryTransfer.Condition(){

                @Override
                public boolean fufilled(ItemStack stack) {
                    return Analyser.isAnalysed(stack);
                }
            });
            new ComponentChargedSlots(machine).addCharge(13);
            new ComponentPowerReceptor(machine, 500);
            new ComponentAnalyserLogic(machine);
            new ComponentAnalyserFX(machine);
        }

        @Override
        public TileEntity createTileEntity() {
            return new TileEntityMachine(this);
        }

        @Override
        public void register() {
        }
    }
}

