/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.machine;

import binnie.Binnie;
import binnie.botany.api.EnumFlowerChromosome;
import binnie.botany.gardening.Gardening;
import binnie.core.BinnieCore;
import binnie.core.Mods;
import binnie.core.genetics.Tolerance;
import binnie.core.machines.IMachine;
import binnie.core.machines.Machine;
import binnie.core.machines.TileEntityMachine;
import binnie.core.machines.inventory.ComponentInventorySlots;
import binnie.core.machines.inventory.ComponentInventoryTransfer;
import binnie.core.machines.inventory.InventorySlot;
import binnie.core.machines.inventory.SlotValidator;
import binnie.core.machines.power.ComponentPowerReceptor;
import binnie.core.machines.power.ComponentProcessIndefinate;
import binnie.core.machines.power.ErrorState;
import binnie.craftgui.minecraft.IMachineInformation;
import binnie.genetics.core.GeneticsGUI;
import binnie.genetics.core.GeneticsTexture;
import binnie.genetics.genetics.Gene;
import binnie.genetics.machine.ComponentGeneticGUI;
import binnie.genetics.machine.GeneticMachine;
import binnie.genetics.machine.Inoculator;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.EnumTolerance;
import forestry.api.genetics.IAlleleTolerance;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import forestry.api.lepidopterology.EnumButterflyChromosome;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;

public class Acclimatiser {
    public static final int[] slotReserve = new int[]{0, 1, 2, 3};
    public static final int slotTarget = 4;
    public static final int[] slotAcclimatiser = new int[]{5, 6, 7};
    public static final int[] slotDone = new int[]{8, 9, 10, 11};
    private static List<ToleranceSystem> toleranceSystems = new ArrayList<ToleranceSystem>();
    static Map<ItemStack, Float> temperatureItems = new HashMap<ItemStack, Float>();
    static Map<ItemStack, Float> humidityItems = new HashMap<ItemStack, Float>();

    private static ToleranceSystem getToleranceSystem(ItemStack stack, ItemStack acclim) {
        ISpeciesRoot root = AlleleManager.alleleRegistry.getSpeciesRoot(stack);
        if (root == null) {
            return null;
        }
        for (ToleranceSystem system : toleranceSystems) {
            if (root.getUID() != system.uid || !system.type.hasEffect(acclim)) continue;
            return system;
        }
        return null;
    }

    public static void addTolerance(String uid, int chromosome, ToleranceType type) {
        toleranceSystems.add(new ToleranceSystem(uid, chromosome, type));
    }

    public static float getTemperatureEffect(ItemStack item) {
        for (ItemStack stack : temperatureItems.keySet()) {
            if (!stack.func_77969_a(item)) continue;
            return temperatureItems.get(stack).floatValue();
        }
        return 0.0f;
    }

    public static float getHumidityEffect(ItemStack item) {
        for (ItemStack stack : humidityItems.keySet()) {
            if (!stack.func_77969_a(item)) continue;
            return humidityItems.get(stack).floatValue();
        }
        return 0.0f;
    }

    public static void addTemperatureItem(ItemStack itemstack, float amount) {
        if (itemstack == null) {
            return;
        }
        temperatureItems.put(itemstack, Float.valueOf(amount));
    }

    public static void addHumidityItem(ItemStack itemstack, float amount) {
        if (itemstack == null) {
            return;
        }
        humidityItems.put(itemstack, Float.valueOf(amount));
    }

    public static void setupRecipes() {
        if (BinnieCore.isApicultureActive()) {
            Acclimatiser.addTolerance(Binnie.Genetics.getBeeRoot().getUID(), EnumBeeChromosome.HUMIDITY_TOLERANCE.ordinal(), ToleranceType.Humidity);
            Acclimatiser.addTolerance(Binnie.Genetics.getBeeRoot().getUID(), EnumBeeChromosome.TEMPERATURE_TOLERANCE.ordinal(), ToleranceType.Temperature);
        }
        if (BinnieCore.isLepidopteryActive()) {
            Acclimatiser.addTolerance(Binnie.Genetics.getButterflyRoot().getUID(), EnumButterflyChromosome.HUMIDITY_TOLERANCE.ordinal(), ToleranceType.Humidity);
            Acclimatiser.addTolerance(Binnie.Genetics.getButterflyRoot().getUID(), EnumButterflyChromosome.TEMPERATURE_TOLERANCE.ordinal(), ToleranceType.Temperature);
        }
        if (BinnieCore.isBotanyActive()) {
            Acclimatiser.addTolerance(Binnie.Genetics.getFlowerRoot().getUID(), EnumFlowerChromosome.HUMIDITY_TOLERANCE.ordinal(), ToleranceType.Humidity);
            Acclimatiser.addTolerance(Binnie.Genetics.getFlowerRoot().getUID(), EnumFlowerChromosome.TEMPERATURE_TOLERANCE.ordinal(), ToleranceType.Temperature);
            Acclimatiser.addTolerance(Binnie.Genetics.getFlowerRoot().getUID(), EnumFlowerChromosome.PH_TOLERANCE.ordinal(), ToleranceType.PH);
        }
        Acclimatiser.addTemperatureItem(new ItemStack(Items.field_151065_br), 0.5f);
        Acclimatiser.addTemperatureItem(new ItemStack(Items.field_151072_bj), 0.75f);
        Acclimatiser.addTemperatureItem(new ItemStack(Items.field_151129_at), 0.75f);
        Acclimatiser.addTemperatureItem(new ItemStack(Items.field_151126_ay), -0.15f);
        Acclimatiser.addTemperatureItem(new ItemStack(Blocks.field_150432_aD), -0.75f);
        Acclimatiser.addHumidityItem(new ItemStack(Items.field_151131_as), 0.75f);
        Acclimatiser.addHumidityItem(new ItemStack((Block)Blocks.field_150354_m), -0.15f);
        Acclimatiser.addTemperatureItem(Mods.Forestry.stack("canLava"), 0.75f);
        Acclimatiser.addTemperatureItem(Mods.Forestry.stack("refractoryLava"), 0.75f);
        Acclimatiser.addHumidityItem(Mods.Forestry.stack("waterCan"), 0.75f);
        Acclimatiser.addHumidityItem(Mods.Forestry.stack("refractoryWater"), 0.75f);
        Acclimatiser.addHumidityItem(Mods.Forestry.stack("waxCapsuleWater"), 0.75f);
    }

    public static boolean canAcclimatise(ItemStack stack, List<ItemStack> acclimatisers) {
        if (stack == null || acclimatisers.isEmpty()) {
            return true;
        }
        for (ItemStack acclim : acclimatisers) {
            if (!Acclimatiser.canAcclimatise(stack, acclim)) continue;
            return true;
        }
        return false;
    }

    public static boolean canAcclimatise(ItemStack stack, ItemStack acclim) {
        ToleranceSystem system = Acclimatiser.getToleranceSystem(stack, acclim);
        if (system == null) {
            return false;
        }
        return system.canAlter(stack, acclim);
    }

    public static ItemStack acclimatise(ItemStack stack, ItemStack acc) {
        ToleranceSystem system = Acclimatiser.getToleranceSystem(stack, acc);
        return system.alter(stack, acc);
    }

    public static Tolerance alterTolerance(Tolerance tol, float effect) {
        int[] is = tol.getBounds();
        int[] range = new int[2];
        range = effect < 0.0f ? new int[]{is[0] - 1, is[1]} : new int[]{is[0], is[1] + 1};
        if (range[0] < -5) {
            range[0] = -5;
        }
        if (range[1] > 5) {
            range[1] = 5;
        }
        EnumTolerance[] up = new EnumTolerance[]{EnumTolerance.NONE, EnumTolerance.UP_1, EnumTolerance.UP_2, EnumTolerance.UP_3, EnumTolerance.UP_4, EnumTolerance.UP_5};
        EnumTolerance[] down = new EnumTolerance[]{EnumTolerance.NONE, EnumTolerance.DOWN_1, EnumTolerance.DOWN_2, EnumTolerance.DOWN_3, EnumTolerance.DOWN_4, EnumTolerance.DOWN_5};
        EnumTolerance[] both = new EnumTolerance[]{EnumTolerance.NONE, EnumTolerance.BOTH_1, EnumTolerance.BOTH_2, EnumTolerance.BOTH_3, EnumTolerance.BOTH_4, EnumTolerance.BOTH_5};
        if (range[0] == 0) {
            return Tolerance.get(up[range[1]]);
        }
        if (range[1] == 0) {
            return Tolerance.get(down[-range[0]]);
        }
        int avg = (int)((float)(-range[0] + range[1]) / 2.0f + 0.6f);
        return Tolerance.get(both[avg]);
    }

    private static class ToleranceSystem {
        String uid;
        int chromosomeOrdinal;
        ToleranceType type;

        private ToleranceSystem(String uid, int chromosomeOrdinal, ToleranceType type) {
            this.uid = uid;
            this.chromosomeOrdinal = chromosomeOrdinal;
            this.type = type;
        }

        public boolean canAlter(ItemStack stack, ItemStack acclim) {
            IIndividual member = AlleleManager.alleleRegistry.getIndividual(stack);
            IGenome genome = member.getGenome();
            IAlleleTolerance tolAllele = (IAlleleTolerance)genome.getActiveAllele(this.chromosomeOrdinal);
            Tolerance tol = Tolerance.get(tolAllele.getValue());
            float effect = this.type.getEffect(acclim);
            if (effect > 0.0f && tol.getBounds()[1] < 5) {
                return true;
            }
            return effect < 0.0f && tol.getBounds()[0] > -5;
        }

        public ItemStack alter(ItemStack stack, ItemStack acc) {
            Random rand = new Random();
            float effect = this.type.getEffect(acc);
            if (rand.nextFloat() > Math.abs(effect)) {
                return stack;
            }
            IIndividual member = AlleleManager.alleleRegistry.getIndividual(stack);
            IGenome genome = member.getGenome();
            IAlleleTolerance tolAllele = (IAlleleTolerance)genome.getActiveAllele(this.chromosomeOrdinal);
            Tolerance tol = Tolerance.get(tolAllele.getValue());
            Tolerance newTol = Acclimatiser.alterTolerance(tol, effect);
            if (rand.nextFloat() > 1.0f / (-((float)newTol.getBounds()[0]) + (float)newTol.getBounds()[1])) {
                return stack;
            }
            ISpeciesRoot root = AlleleManager.alleleRegistry.getSpeciesRoot(stack);
            Inoculator.setGene(new Gene(newTol.getAllele(), root.getKaryotype()[this.chromosomeOrdinal], root), stack, rand.nextInt(2));
            return stack;
        }
    }

    public static enum ToleranceType {
        Temperature,
        Humidity,
        PH;


        public float getEffect(ItemStack stack) {
            switch (this) {
                case Temperature: {
                    return Acclimatiser.getTemperatureEffect(stack);
                }
                case Humidity: {
                    return Acclimatiser.getHumidityEffect(stack);
                }
                case PH: {
                    if (Gardening.isAcidFertiliser(stack)) {
                        return -0.5f * (float)Gardening.getFertiliserStrength(stack);
                    }
                    if (!Gardening.isAlkalineFertiliser(stack)) break;
                    return 0.5f * (float)Gardening.getFertiliserStrength(stack);
                }
            }
            return 0.0f;
        }

        public boolean hasEffect(ItemStack stack) {
            return this.getEffect(stack) != 0.0f;
        }
    }

    public static class ValidatorAcclimatiserItem
    extends SlotValidator {
        public ValidatorAcclimatiserItem() {
            super(null);
        }

        @Override
        public boolean isValid(ItemStack stack) {
            for (ToleranceType type : ToleranceType.values()) {
                if (!type.hasEffect(stack)) continue;
                return true;
            }
            return false;
        }

        @Override
        public String getTooltip() {
            return "Acclimatising Items";
        }
    }

    public static class ComponentAcclimatiserLogic
    extends ComponentProcessIndefinate {
        public ComponentAcclimatiserLogic(IMachine machine) {
            super(machine, 2.0f);
        }

        @Override
        public ErrorState canWork() {
            if (this.getUtil().getStack(4) == null) {
                return new ErrorState.NoItem("No Individual to Acclimatise", 4);
            }
            if (this.getUtil().getNonNullStacks(slotAcclimatiser).isEmpty()) {
                return new ErrorState.NoItem("No Acclimatising Items", slotAcclimatiser);
            }
            return super.canWork();
        }

        @Override
        public ErrorState canProgress() {
            if (!Acclimatiser.canAcclimatise(this.getUtil().getStack(4), this.getUtil().getNonNullStacks(slotAcclimatiser))) {
                return new ErrorState.InvalidItem("Cannot Acclimatise this individual with these items", 4);
            }
            return super.canProgress();
        }

        @Override
        protected boolean inProgress() {
            return this.canWork() == null;
        }

        @Override
        protected void onTickTask() {
            super.onTickTask();
            if (this.getUtil().getRandom().nextInt(100) == 0) {
                this.attemptAcclimatisation();
            }
        }

        protected void attemptAcclimatisation() {
            ArrayList<ItemStack> acclms = new ArrayList<ItemStack>();
            for (ItemStack s : this.getUtil().getNonNullStacks(slotAcclimatiser)) {
                if (!Acclimatiser.canAcclimatise(this.getUtil().getStack(4), s)) continue;
                acclms.add(s);
            }
            ItemStack acc = (ItemStack)acclms.get(this.getUtil().getRandom().nextInt(acclms.size()));
            ItemStack acclimed = Acclimatiser.acclimatise(this.getUtil().getStack(4), acc);
            if (acclimed != null) {
                this.getUtil().setStack(4, acclimed);
                boolean removed = false;
                for (int i : slotAcclimatiser) {
                    if (removed || this.getUtil().getStack(i) == null || !this.getUtil().getStack(i).func_77969_a(acc)) continue;
                    this.getUtil().decreaseStack(i, 1);
                    removed = true;
                }
            }
        }
    }

    public static class PackageAcclimatiser
    extends GeneticMachine.PackageGeneticBase
    implements IMachineInformation {
        public PackageAcclimatiser() {
            super("acclimatiser", GeneticsTexture.Acclimatiser, 9857609, true);
        }

        @Override
        public void createMachine(final Machine machine) {
            new ComponentGeneticGUI(machine, GeneticsGUI.Acclimatiser);
            ComponentInventorySlots inventory = new ComponentInventorySlots(machine);
            inventory.addSlot(4, "Acclimatising Slot");
            inventory.getSlot(4).setValidator(new SlotValidator.Individual());
            inventory.getSlot(4).setReadOnly();
            inventory.getSlot(4).forbidExtraction();
            for (InventorySlot slot : inventory.addSlotArray(slotReserve, "Input Slot")) {
                slot.forbidExtraction();
                slot.setValidator(new SlotValidator.Individual());
            }
            for (InventorySlot slot : inventory.addSlotArray(slotDone, "Output Slot")) {
                slot.setReadOnly();
                slot.setValidator(new SlotValidator.Individual());
            }
            for (InventorySlot slot : inventory.addSlotArray(slotAcclimatiser, "Acclimatiser Item Slot")) {
                slot.setValidator(new ValidatorAcclimatiserItem());
            }
            ComponentInventoryTransfer transfer = new ComponentInventoryTransfer(machine);
            transfer.addRestock(slotReserve, 4, 1);
            transfer.addStorage(4, slotDone, new ComponentInventoryTransfer.Condition(){

                @Override
                public boolean fufilled(ItemStack stack) {
                    return !Acclimatiser.canAcclimatise(stack, machine.getMachineUtil().getNonNullStacks(slotAcclimatiser));
                }
            });
            new ComponentPowerReceptor(machine, 5000);
            new ComponentAcclimatiserLogic(machine);
        }

        @Override
        public TileEntity createTileEntity() {
            return new TileEntityMachine(this);
        }

        @Override
        public void register() {
        }
    }
}

