/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.item;

import binnie.Binnie;
import binnie.genetics.Genetics;
import binnie.genetics.api.IGene;
import binnie.genetics.api.IItemSerum;
import binnie.genetics.genetics.Gene;
import binnie.genetics.genetics.GeneArrayItem;
import binnie.genetics.item.ItemGene;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosome;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemSerumArray
extends ItemGene
implements IItemSerum {
    public ItemSerumArray() {
        super("serumArray");
        this.func_77656_e(16);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.func_77624_a(itemstack, entityPlayer, list, par4);
    }

    @Override
    public int getCharges(ItemStack stack) {
        return stack.func_77973_b().func_77612_l() - stack.func_77960_j();
    }

    @Override
    public IGene[] getGenes(ItemStack stack) {
        return this.getGeneItem(stack).getGenes().toArray(new IGene[0]);
    }

    @Override
    public ISpeciesRoot getSpeciesRoot(ItemStack stack) {
        return this.getGeneItem(stack).getSpeciesRoot();
    }

    @Override
    public IGene getGene(ItemStack stack, int chromosome) {
        return this.getGeneItem(stack).getGene(chromosome);
    }

    @Override
    public GeneArrayItem getGeneItem(ItemStack stack) {
        return new GeneArrayItem(stack);
    }

    @Override
    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List itemList) {
        for (ISpeciesRoot root : AlleleManager.alleleRegistry.getSpeciesRoot().values()) {
            for (IIndividual template : root.getIndividualTemplates()) {
                if (template.getGenome().getPrimary().isSecret()) continue;
                GeneArrayItem item = new GeneArrayItem();
                for (IChromosomeType type : root.getKaryotype()) {
                    IAllele active;
                    IChromosome c = template.getGenome().getChromosomes()[type.ordinal()];
                    if (c == null || (active = c.getActiveAllele()) == null) continue;
                    item.addGene(new Gene(active, type, root));
                }
                ItemStack array = new ItemStack((Item)this);
                item.writeToItem(array);
                itemList.add(array);
            }
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister register) {
        this.icons[0] = Genetics.proxy.getIcon(register, "machines/genome.glass");
        this.icons[1] = Genetics.proxy.getIcon(register, "machines/genome.cap");
        this.icons[2] = Genetics.proxy.getIcon(register, "machines/genome.edges");
        this.icons[3] = Genetics.proxy.getIcon(register, "machines/genome.dna");
    }

    @Override
    public String func_77653_i(ItemStack itemstack) {
        GeneArrayItem gene = this.getGeneItem(itemstack);
        return Binnie.Genetics.getSystem(gene.getSpeciesRoot()).getDescriptor() + " Serum Array";
    }

    @Override
    public ItemStack addGene(ItemStack stack, IGene gene) {
        GeneArrayItem geneI = this.getGeneItem(stack);
        geneI.addGene(gene);
        geneI.writeToItem(stack);
        return stack;
    }

    public static ItemStack create(IGene gene) {
        ItemStack item = new ItemStack((Item)Genetics.itemSerumArray);
        item.func_77964_b(item.func_77958_k());
        GeneArrayItem seq = new GeneArrayItem(gene);
        seq.writeToItem(item);
        return item;
    }
}

