/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.item;

import binnie.Binnie;
import binnie.genetics.Genetics;
import binnie.genetics.api.IGene;
import binnie.genetics.api.IItemSerum;
import binnie.genetics.genetics.Gene;
import binnie.genetics.genetics.GeneDataArray;
import binnie.genetics.genetics.GeneItem;
import binnie.genetics.item.ItemGene;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.ISpeciesRoot;
import java.util.List;
import java.util.Map;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;

public class ItemSerum
extends ItemGene
implements IItemSerum {
    public ItemSerum() {
        super("serum");
        this.func_77656_e(16);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack itemstack, EntityPlayer entityPlayer, List list, boolean par4) {
        super.func_77624_a(itemstack, entityPlayer, list, par4);
    }

    @Override
    public int getCharges(ItemStack stack) {
        return stack.func_77973_b().func_77612_l() - stack.func_77960_j();
    }

    @Override
    public void func_150895_a(Item par1, CreativeTabs par2CreativeTabs, List itemList) {
        for (ISpeciesRoot root : AlleleManager.alleleRegistry.getSpeciesRoot().values()) {
            Map<IChromosomeType, List<IAllele>> chromosomeMap = GeneDataArray.getChromosomeMap(root);
            for (Map.Entry<IChromosomeType, List<IAllele>> entry : chromosomeMap.entrySet()) {
                IChromosomeType chromosome = entry.getKey();
                for (IAllele allele : entry.getValue()) {
                    Gene gene = Gene.create(allele, chromosome, root);
                    if (gene == null) continue;
                    GeneItem item = new GeneItem(gene);
                    ItemStack stack = new ItemStack((Item)this);
                    item.writeToItem(stack);
                    itemList.add(stack);
                }
            }
        }
    }

    @Override
    public IGene[] getGenes(ItemStack stack) {
        return new IGene[]{this.getGeneItem(stack).getGene()};
    }

    @Override
    public ISpeciesRoot getSpeciesRoot(ItemStack stack) {
        return this.getGeneItem(stack).getSpeciesRoot();
    }

    @Override
    public IGene getGene(ItemStack stack, int chromosome) {
        return this.getGeneItem(stack).getGene();
    }

    @Override
    public GeneItem getGeneItem(ItemStack stack) {
        return new GeneItem(stack);
    }

    @Override
    public String func_77653_i(ItemStack itemstack) {
        GeneItem gene = this.getGeneItem(itemstack);
        return Binnie.Genetics.getSystem(gene.getSpeciesRoot()).getDescriptor() + " Serum";
    }

    @Override
    public ItemStack addGene(ItemStack stack, IGene gene) {
        GeneItem geneI = this.getGeneItem(stack);
        geneI.addGene(gene);
        geneI.writeToItem(stack);
        return stack;
    }

    public static ItemStack create(IGene gene) {
        ItemStack item = new ItemStack(Genetics.itemSerum);
        item.func_77964_b(item.func_77958_k());
        GeneItem seq = new GeneItem(gene);
        seq.writeToItem(item);
        return item;
    }
}

