/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.genetics;

import binnie.core.genetics.BreedingSystem;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleFloat;
import forestry.api.genetics.IAlleleInteger;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class GeneticEngineeringSystem {
    BreedingSystem breedingSystem;
    public Map<IChromosomeType, List<IAllele>> chromosomeMap = new HashMap<IChromosomeType, List<IAllele>>();
    static List<IAllele> speciesList;

    public GeneticEngineeringSystem(BreedingSystem system) {
        this.breedingSystem = system;
        for (IIndividual indiv : this.breedingSystem.getSpeciesRoot().getIndividualTemplates()) {
            for (IChromosomeType chromosome : this.breedingSystem.getSpeciesRoot().getKaryotype()) {
                if (!this.chromosomeMap.containsKey(chromosome)) {
                    this.chromosomeMap.put(chromosome, new ArrayList());
                }
                try {
                    IAllele a1 = indiv.getGenome().getActiveAllele(chromosome.ordinal());
                    IAllele a2 = indiv.getGenome().getInactiveAllele(chromosome.ordinal());
                    if (a1 != null) {
                        this.chromosomeMap.get(chromosome).add(a1);
                    }
                    if (a2 == null) continue;
                    this.chromosomeMap.get(chromosome).add(a2);
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        for (IChromosomeType chromosome : this.breedingSystem.getSpeciesRoot().getKaryotype()) {
            List<IAllele> alleles = this.getAlleles(chromosome);
            TreeSet<IAllele> set = new TreeSet<IAllele>(new ComparatorAllele());
            set.addAll(alleles);
            ArrayList<IAllele> list = new ArrayList<IAllele>();
            list.addAll(set);
            this.chromosomeMap.put(chromosome, list);
        }
    }

    public List<IAllele> getAlleles(IChromosomeType chromosome) {
        return this.chromosomeMap.get(chromosome);
    }

    public ISpeciesRoot getSpeciesRoot() {
        return this.breedingSystem.getSpeciesRoot();
    }

    class ComparatorAllele
    implements Comparator<IAllele> {
        ComparatorAllele() {
        }

        @Override
        public int compare(IAllele o1, IAllele o2) {
            if (o1 instanceof IAlleleFloat && o2 instanceof IAlleleFloat) {
                return Float.valueOf(((IAlleleFloat)o1).getValue()).compareTo(Float.valueOf(((IAlleleFloat)o2).getValue()));
            }
            if (o1 instanceof IAlleleInteger && o2 instanceof IAlleleInteger) {
                return Integer.valueOf(((IAlleleInteger)o1).getValue()).compareTo(((IAlleleInteger)o2).getValue());
            }
            return o1.getUID().compareTo(o2.getUID());
        }
    }
}

