/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.genetics;

import binnie.Binnie;
import binnie.core.genetics.BreedingSystem;
import binnie.genetics.api.IGene;
import binnie.genetics.genetics.Gene;
import binnie.genetics.genetics.IGeneItem;
import forestry.api.core.INBTTagable;
import forestry.api.genetics.ISpeciesRoot;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;

public class GeneItem
implements INBTTagable,
IGeneItem {
    IGene gene;

    public GeneItem(ItemStack stack) {
        if (stack == null) {
            return;
        }
        this.readFromNBT(stack.func_77978_p());
    }

    public GeneItem(IGene gene) {
        this.gene = gene;
    }

    public boolean isCorrupted() {
        return this.gene == null;
    }

    @Override
    public void writeToItem(ItemStack stack) {
        if (this.gene == null || stack == null) {
            return;
        }
        NBTTagCompound nbt = stack.func_77942_o() ? stack.func_77978_p() : new NBTTagCompound();
        this.writeToNBT(nbt);
        stack.func_77982_d(nbt);
    }

    @Override
    public int getColour(int renderPass) {
        if (renderPass == 2 && this.getBreedingSystem() != null) {
            return this.getBreedingSystem().getColour();
        }
        return 0xFFFFFF;
    }

    @Override
    public void getInfo(List list) {
        String chromosomeName = this.getBreedingSystem().getChromosomeName(this.gene.getChromosome().ordinal());
        list.add("\u00a76" + chromosomeName + "\u00a77: " + this.gene.getName());
    }

    public BreedingSystem getBreedingSystem() {
        if (this.gene == null) {
            return null;
        }
        return Binnie.Genetics.getSystem(this.gene.getSpeciesRoot().getUID());
    }

    public IGene getGene() {
        return this.gene;
    }

    public void readFromNBT(NBTTagCompound nbt) {
        if (nbt != null) {
            this.gene = Gene.create(nbt.func_74775_l("gene"));
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        if (this.gene == null) {
            return;
        }
        NBTTagCompound geneNBT = this.gene.getNBTTagCompound();
        nbt.func_74782_a("gene", (NBTBase)geneNBT);
    }

    @Override
    public ISpeciesRoot getSpeciesRoot() {
        return this.gene.getSpeciesRoot();
    }

    @Override
    public void addGene(IGene gene) {
        this.gene = gene;
    }
}

