/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.genetics;

import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleFloat;
import forestry.api.genetics.IAlleleInteger;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IGenome;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.ISpeciesRoot;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeSet;

public class GeneDataArray {
    static List<IChromosomeType> invalidChromosomeTypes = new ArrayList<IChromosomeType>();
    static Map<ISpeciesRoot, Map<IChromosomeType, List<IAllele>>> chromosomeArray = new LinkedHashMap<ISpeciesRoot, Map<IChromosomeType, List<IAllele>>>();

    public static void loadAlleles() {
        for (ISpeciesRoot root : AlleleManager.alleleRegistry.getSpeciesRoot().values()) {
            LinkedHashMap chromosomeMap = new LinkedHashMap();
            for (IChromosomeType chromosome : root.getKaryotype()) {
                TreeSet<IAllele> alleles = new TreeSet<IAllele>(new ComparatorAllele());
                for (IIndividual individual : root.getIndividualTemplates()) {
                    IGenome genome = individual.getGenome();
                    try {
                        IAllele a1 = genome.getActiveAllele(chromosome.ordinal());
                        IAllele a2 = genome.getInactiveAllele(chromosome.ordinal());
                        if (chromosome.getAlleleClass().isInstance(a1)) {
                            alleles.add(a1);
                        }
                        if (!chromosome.getAlleleClass().isInstance(a2)) continue;
                        alleles.add(a2);
                    }
                    catch (Exception e) {}
                }
                if (alleles.size() == 0) {
                    invalidChromosomeTypes.add(chromosome);
                    continue;
                }
                ArrayList<IAllele> alleleList = new ArrayList<IAllele>();
                alleleList.addAll(alleles);
                chromosomeMap.put(chromosome, alleleList);
            }
            chromosomeArray.put(root, chromosomeMap);
        }
    }

    public static Map<IChromosomeType, List<IAllele>> getChromosomeMap(ISpeciesRoot root) {
        return chromosomeArray.get(root);
    }

    static class ComparatorAllele
    implements Comparator<IAllele> {
        ComparatorAllele() {
        }

        @Override
        public int compare(IAllele o1, IAllele o2) {
            if (o1 instanceof IAlleleFloat && o2 instanceof IAlleleFloat) {
                return Float.valueOf(((IAlleleFloat)o1).getValue()).compareTo(Float.valueOf(((IAlleleFloat)o2).getValue()));
            }
            if (o1 instanceof IAlleleInteger && o2 instanceof IAlleleInteger) {
                return Integer.valueOf(((IAlleleInteger)o1).getValue()).compareTo(((IAlleleInteger)o2).getValue());
            }
            return o1.getUID().compareTo(o2.getUID());
        }
    }
}

