/*
 * Decompiled with CFR 0.152.
 */
package binnie.genetics.genetics;

import binnie.Binnie;
import binnie.genetics.api.IGene;
import forestry.api.core.INBTTagable;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.ISpeciesRoot;
import net.minecraft.nbt.NBTTagCompound;

public class Gene
implements INBTTagable,
IGene {
    IAllele allele;
    IChromosomeType chromosome;
    ISpeciesRoot root;

    @Override
    public ISpeciesRoot getSpeciesRoot() {
        return this.root;
    }

    public Gene(IAllele allele, IChromosomeType chromosome, ISpeciesRoot root) {
        this.allele = allele;
        this.chromosome = chromosome;
        this.root = root;
    }

    public Gene(NBTTagCompound nbt) {
        this.readFromNBT(nbt);
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.allele = AlleleManager.alleleRegistry.getAllele(nbt.func_74779_i("allele"));
        this.root = AlleleManager.alleleRegistry.getSpeciesRoot(nbt.func_74779_i("root"));
        byte chromoID = nbt.func_74771_c("chromo");
        if (this.root != null && chromoID >= 0 && chromoID < this.root.getKaryotype().length) {
            this.chromosome = this.root.getKaryotype()[chromoID];
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74778_a("allele", this.allele.getUID());
        nbt.func_74778_a("root", this.root.getUID());
        nbt.func_74774_a("chromo", (byte)this.chromosome.ordinal());
    }

    public boolean isCorrupted() {
        return this.allele == null || this.chromosome == null || this.root == null;
    }

    public static Gene create(NBTTagCompound nbt) {
        Gene gene = new Gene(nbt);
        return gene.isCorrupted() ? null : gene;
    }

    public static Gene create(IAllele allele, IChromosomeType chromosome, ISpeciesRoot root) {
        Gene gene = new Gene(allele, chromosome, root);
        return gene.isCorrupted() ? null : gene;
    }

    @Override
    public NBTTagCompound getNBTTagCompound() {
        NBTTagCompound nbt = new NBTTagCompound();
        this.writeToNBT(nbt);
        return nbt;
    }

    @Override
    public String getName() {
        return Binnie.Genetics.getSystem(this.root).getAlleleName(this.chromosome, this.allele);
    }

    @Override
    public IChromosomeType getChromosome() {
        return this.chromosome;
    }

    @Override
    public IAllele getAllele() {
        return this.allele;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Gene)) {
            return false;
        }
        Gene g = (Gene)obj;
        return this.allele == g.allele && this.chromosome.ordinal() == g.chromosome.ordinal() && this.root == g.root;
    }
}

