/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.machines;

import binnie.core.machines.Machine;
import binnie.core.machines.TileEntityMachine;
import binnie.core.machines.inventory.ComponentInventorySlots;
import binnie.core.machines.inventory.ComponentTankContainer;
import binnie.core.machines.inventory.InventorySlot;
import binnie.core.machines.inventory.MachineSide;
import binnie.core.machines.inventory.TankValidator;
import binnie.core.machines.power.ComponentPowerReceptor;
import binnie.core.machines.power.ComponentProcess;
import binnie.core.machines.power.ErrorState;
import binnie.core.machines.power.IProcess;
import binnie.craftgui.minecraft.IMachineInformation;
import binnie.extratrees.core.ExtraTreeTexture;
import binnie.extratrees.core.ExtraTreesGUID;
import binnie.extratrees.machines.ExtraTreeMachine;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;

public class Infuser {
    public static int tankInput = 0;
    public static int tankOutput = 1;
    static Map<Fluid, FluidStack> recipes = new HashMap<Fluid, FluidStack>();

    public static FluidStack getOutput(FluidStack fluid, ItemStack stack) {
        if (fluid == null) {
            return null;
        }
        return recipes.get(fluid.getFluid());
    }

    public static boolean isValidInputLiquid(FluidStack fluid) {
        int i = 0;
        if (i < 3) {
            return recipes.containsKey(fluid.getFluid());
        }
        return false;
    }

    public static boolean isValidOutputLiquid(FluidStack fluid) {
        for (Map.Entry<Fluid, FluidStack> entry : recipes.entrySet()) {
            if (!entry.getValue().isFluidEqual(fluid)) continue;
            return true;
        }
        return false;
    }

    public static void addRecipe(FluidStack input, FluidStack output) {
        recipes.put(input.getFluid(), output);
    }

    public static class TankValidatorInfuserOutput
    extends TankValidator {
        @Override
        public boolean isValid(FluidStack itemStack) {
            return Infuser.isValidOutputLiquid(itemStack);
        }

        @Override
        public String getTooltip() {
            return "Infused Liquids";
        }
    }

    public static class TankValidatorInfuserInput
    extends TankValidator {
        @Override
        public boolean isValid(FluidStack itemStack) {
            return Infuser.isValidInputLiquid(itemStack);
        }

        @Override
        public String getTooltip() {
            return "Infusable Liquids";
        }
    }

    public static class ComponentInfuserLogic
    extends ComponentProcess
    implements IProcess {
        ItemStack infusing;

        public ComponentInfuserLogic(Machine machine) {
            super(machine, 1600, 800);
        }

        @Override
        public int getProcessEnergy() {
            return this.getProcessLength() * 2;
        }

        @Override
        public int getProcessLength() {
            return 20;
        }

        @Override
        public ErrorState canWork() {
            if (this.getUtil().isTankEmpty(tankInput)) {
                return new ErrorState.InsufficientLiquid("No Input Liquid", tankInput);
            }
            return super.canWork();
        }

        @Override
        public ErrorState canProgress() {
            if (!this.getUtil().isTankEmpty(tankOutput) && this.getOutput() != null && !this.getOutput().isFluidEqual(this.getUtil().getFluid(tankOutput))) {
                return new ErrorState.Tank("No Room", "No room for liquid", new int[]{tankOutput});
            }
            if (this.getUtil().getFluid(tankOutput) != null && !this.getUtil().getFluid(tankOutput).isFluidEqual(this.getOutput())) {
                return new ErrorState.TankSpace("Different fluid in tank", tankOutput);
            }
            return super.canProgress();
        }

        private FluidStack getOutput() {
            return Infuser.getOutput(this.getUtil().getFluid(tankInput), this.infusing);
        }

        @Override
        protected void onFinishTask() {
            FluidStack output = this.getOutput().copy();
            this.getUtil().fillTank(tankOutput, output);
        }

        @Override
        protected void onTickTask() {
        }

        @Override
        public String getTooltip() {
            return "Infusing";
        }
    }

    public static class PackageInfuser
    extends ExtraTreeMachine.PackageExtraTreeMachine
    implements IMachineInformation {
        public PackageInfuser() {
            super("infuser", ExtraTreeTexture.infuserTexture, true);
        }

        @Override
        public void createMachine(Machine machine) {
            new ExtraTreeMachine.ComponentExtraTreeGUI(machine, ExtraTreesGUID.Infuser);
            ComponentInventorySlots inventory = new ComponentInventorySlots(machine);
            ComponentTankContainer tanks = new ComponentTankContainer(machine);
            tanks.addTank(tankInput, InventorySlot.NameInput, 5000);
            tanks.getTankSlot(tankInput).setValidator(new TankValidatorInfuserInput());
            tanks.getTankSlot(tankInput).setOutputSides(MachineSide.TopAndBottom);
            tanks.addTank(tankOutput, InventorySlot.NameOutput, 5000);
            tanks.getTankSlot(tankOutput).setValidator(new TankValidatorInfuserOutput());
            tanks.getTankSlot(tankOutput).setReadOnly();
            tanks.getTankSlot(tankOutput).setOutputSides(MachineSide.Sides);
            new ComponentPowerReceptor(machine);
            new ComponentInfuserLogic(machine);
        }

        @Override
        public TileEntity createTileEntity() {
            return new TileEntityMachine(this);
        }

        @Override
        public void register() {
        }
    }
}

